<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableLanding extends JTable
{
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_landings', 'id', $db);
	}



	/**
	 * Overload the store method for the Weblinks table.
	 *
	 * @param   boolean	Toggle whether null values should be updated.
	 * @return  boolean  True on success, false on failure.
	 * @since   1.6
	 */
	public function store($updateNulls = false)
	{
		
		
		$date	= JFactory::getDate();
		$user	= JFactory::getUser();
		$isEdit = false;
		if ($this->id) {
			// Existing item
			$this->modified	= $date->toSql();
			$this->modified_by	= $user->get('id');
			$isEdit = true;

		} else {
			// so we don't touch either of these if they are set.
			if (!intval($this->created)) {
				$this->created = $date->toSql();
			}
			if (empty($this->created_by)) {
				$this->created_by = $user->get('id');
			}


		}
		
		$resualt = parent::store($updateNulls);

		
		if($isEdit == false){
			
			$db = $this->getDbo();
			$landing_id = $db->insertid();
			$query = $db->getQuery(true);
			$query->insert ( $db->quoteName ( '#__mrocket_daily_stat' ));
			$query->set ( $db->qn('landing_id') .' = '.$db->q($this->id));
			$query->set ( $db->qn('date') .' = CURDATE()');
			$db->setQuery ( $query );
			$db->execute ();
			
		}
		
		

		// Attempt to store the user data.
		return $resualt;
	}

	/**
	 * Overloaded check method to ensure data integrity.
	 *
	 * @return  boolean  True on success.
	 */
	public function check()
	{

		if($this->is_split == '1')
			return true;
		
		if(empty($this->alias)){
			if(!empty($this->seo_title))
				$this->alias = $this->seo_title;
			else 
				$this->alias = $this->title;
		}
		$this->alias = JApplication::stringURLSafe($this->alias);

                if(empty($this->alias)){
                    $this->alias = JFactory::getDate ()->toSql ();
                    $this->alias = JApplication::stringURLSafe($this->alias);
                }
                    
		// check for user limitaion
		

		// check that alias is not taken
		$i = '';
		$alias = $this->alias;
		do {
			$this->alias = $alias.$i;
			$query = 'SELECT id FROM #__mrocket_landings WHERE alias = '.$this->_db->quote($this->alias);
			if(empty($i))
				$i = 0;
			$i = $i+1;
			$this->_db->setQuery($query);

			$xid = (int) $this->_db->loadResult();
		}while ($xid && $xid != (int) $this->id);
		
		
		

		return true;
	}

	public function delete($pk = null)
	{
		// select user_id first


		$row = $this->load($pk, true);
		if(!$row)
			return false;
	
		$result = parent::delete($pk);

		return $result;
	}


}
