DROP TABLE IF EXISTS `#__mrocket_temp`;
CREATE TABLE `#__mrocket_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `campaign_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `main_keyword` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(800) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `public_accsess` tinyint(1) DEFAULT NULL,
  `form_json` text,
  `form_or_cta` enum('form','cta','none') DEFAULT NULL,
  `form_name` varchar(255) DEFAULT NULL,
  `responder_type` varchar(255) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `responder_sequence_id` varchar(255) DEFAULT NULL,
  `convert_from_another` varchar(255) DEFAULT NULL,
  `convert_again` varchar(255) DEFAULT NULL,
  `have_paypal` tinyint(1) DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `submit_text` varchar(255) DEFAULT NULL,
  `notification` tinyint(1) DEFAULT NULL,
  `notification_email` varchar(255) DEFAULT NULL,
  `cta_type` enum('image','text') DEFAULT NULL,
  `cta_image_src` varchar(255) DEFAULT NULL,
  `cta_image_alt` varchar(255) DEFAULT NULL,
  `cta_text` text,
  `after_filling` enum('menu_item','redirect_url','message','to_landing_page') DEFAULT NULL,
  `menu_item` int(11) DEFAULT NULL,
  `message` text,
  `to_landing_page` int(11) DEFAULT NULL,
  `adding_tag` varchar(11) DEFAULT NULL,
  `page_html` longtext,
  `page_editor` longtext,
  `redirect_url` varchar(255) DEFAULT NULL,
  `is_split` tinyint(1) DEFAULT NULL,
  `removing_tag` varchar(255) DEFAULT NULL,
  `paypal_account` varchar(255) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT NULL,
  `modal_header` varchar(255) DEFAULT NULL,
  `modal_body` text,
  `modal_background_color` varchar(255) DEFAULT NULL,
  `modal_background-color_transparent` tinyint(4) DEFAULT NULL,
  `modal_background_image` varchar(255) DEFAULT NULL,
  `modal_background_repeat` varchar(255) DEFAULT NULL,
  `modal_text_color` varchar(255) DEFAULT NULL,
  `css` text,
  `javascript` text,
  `hidden_css` text,
  `convert_lead` tinyint(1) DEFAULT '0',
  `modal_editor` text,
  `paypal_currency` enum('AUD','BRL','CAD','EUR','GBP','JPY','USD','NZD','CHF','HKD','SGD','SEK','DKK','PLN','NOK','HUF','CZK','MXN','MYR','PHP','TWD','THB','ILS','TRY') NOT NULL,
  `paypal_product_name` varchar(255) DEFAULT NULL,
  `after_pay` enum('to_landing_page','redirect_url','message','menu_item') DEFAULT NULL COMMENT 'this will be used for canceling payment',
  `pay_menu_item` int(11) DEFAULT NULL,
  `pay_redirect_url` varchar(255) DEFAULT NULL,
  `pay_to_landing_page` int(11) DEFAULT NULL,
  `pay_message` text,
  `page_option` longtext NOT NULL,
  `viewing_tag` varchar(600) DEFAULT NULL,
  `save_type` enum('auto','preview') DEFAULT NULL,
  `landing_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

