DROP TABLE IF EXISTS `#__mrocket_campaign`;
DROP TABLE IF EXISTS `#__mrocket_daily_stat`;
DROP TABLE IF EXISTS `#__mrocket_landings`;
DROP TABLE IF EXISTS `#__mrocket_landing_templates`;
DROP TABLE IF EXISTS `#__mrocket_leads`;
DROP TABLE IF EXISTS `#__mrocket_leads_cron`;
DROP TABLE IF EXISTS `#__mrocket_leads_tags`;
DROP TABLE IF EXISTS `#__mrocket_payments`;
DROP TABLE IF EXISTS `#__mrocket_refcodes`;
DROP TABLE IF EXISTS `#__mrocket_responder_templates`;
DROP TABLE IF EXISTS `#__mrocket_statuses`;
DROP TABLE IF EXISTS `#__mrocket_tags`;
DROP TABLE IF EXISTS `#__mrocket_temp`;
DROP TABLE IF EXISTS `#__mrocket_lead_campaigns`;
DROP TABLE IF EXISTS `#__mrocket_lead_statuses`;
DROP TABLE IF EXISTS `#__mrocket_reponders_sequences`;
DROP TABLE IF EXISTS `#__mrocket_api`;
DROP TABLE IF EXISTS `#__mrocket_responder_attachments`;
DROP TABLE IF EXISTS `#__mrocket_webinar`;
DROP TABLE IF EXISTS `#__mrocket_api_types`;
DROP TABLE IF EXISTS `#__mrocket_actions`;
DROP TABLE IF EXISTS `#__mrocket_lead_details`;
DROP TABLE IF EXISTS `#__mrocket_logs`;
DROP TABLE IF EXISTS `#__mrocket_messages`;
DROP TABLE IF EXISTS `#__mrocket_action_item`;
CREATE TABLE IF NOT EXISTS `#__mrocket_campaign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `desc` text NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `responder_id` int(11) DEFAULT '0' COMMENT 'This will be used by wizard to set predefined responder',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__mrocket_daily_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `landing_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `visit` int(11) NOT NULL,
  `submission` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `landing_id` (`landing_id`),
  KEY `date` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__mrocket_landings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `campaign_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `main_keyword` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(800) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `public_accsess` tinyint(1) DEFAULT NULL,
  `form_json` text,
  `form_or_cta` enum('form','cta', 'none') DEFAULT NULL,
  `form_name` varchar(255) DEFAULT NULL,
  `responder_type` varchar(255) DEFAULT NULL,
  `api_id` INT NULL,
  `responder_sequence_id` varchar(255) DEFAULT NULL,
  `convert_from_another` varchar(255) DEFAULT NULL,
  `convert_again` varchar(255) DEFAULT NULL,
  `have_paypal` tinyint(1) DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `submit_text` varchar(255) DEFAULT NULL,
  `notification` tinyint(1) DEFAULT NULL,
  `notification_email` TEXT DEFAULT NULL,
  `cta_type` enum('image','text') DEFAULT NULL,
  `cta_image_src` varchar(255) DEFAULT NULL,
  `cta_image_alt` varchar(255) DEFAULT NULL,
  `cta_text` text,
  `after_filling` enum('menu_item','redirect_url','message','to_landing_page') DEFAULT NULL,
  `menu_item` int(11) DEFAULT NULL,
  `message` text,
  `to_landing_page` int(11) DEFAULT NULL,
  `adding_tag` VARCHAR(255) NULL DEFAULT NULL,
  `page_html` longtext,
  `page_editor` longtext,
  `redirect_url` varchar(255) DEFAULT NULL,
  `is_split` tinyint(1) DEFAULT NULL,
  `removing_tag` VARCHAR(255) NULL DEFAULT NULL,
  `paypal_account` varchar(255) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT NULL,
  `modal_header` varchar(255) DEFAULT NULL,
  `modal_body` text,
  `modal_background_color` varchar(255) DEFAULT NULL,
  `modal_background-color_transparent` tinyint(4) DEFAULT NULL,
  `modal_background_image` varchar(255) DEFAULT NULL,
  `modal_background_repeat` varchar(255) DEFAULT NULL,
  `modal_text_color` varchar(255) DEFAULT NULL,
  `css` TEXT DEFAULT NULL ,
  `javascript` TEXT DEFAULT NULL ,
  `hidden_css` TEXT DEFAULT NULL ,
  `convert_lead` tinyint(1) DEFAULT 0,
  `modal_editor` TEXT DEFAULT NULL ,
  `paypal_currency` ENUM('AUD','BRL','CAD','EUR','GBP','JPY','USD','NZD','CHF','HKD','SGD','SEK','DKK','PLN','NOK','HUF','CZK','MXN','MYR','PHP','TWD','THB','ILS','TRY', 'IRI') NOT NULL,
  `paypal_product_name` varchar(255) DEFAULT NULL,
  `after_pay` enum('menu_item','redirect_url','to_landing_page', 'message') DEFAULT NULL,
  `pay_menu_item` int(11) DEFAULT NULL,
  `pay_redirect_url` varchar(255) DEFAULT NULL,   
  `pay_to_landing_page` int(11) DEFAULT NULL,  
  `pay_message` text,
  `page_option` LONGTEXT,
  `viewing_tag` VARCHAR(250) DEFAULT NULL,
  `exit_popup_modal` LONGTEXT NOT NULL , 
  `exit_popup_modal_editor` LONGTEXT NOT NULL,
   PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB  AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__mrocket_landing_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(350) NOT NULL,
  `desc` text NOT NULL,
  `html` longtext NOT NULL,
  `modal_html` longtext NOT NULL,
  `form` text,
  `type` enum('COM_MARKETINGROCKET_SQUEEZE_PAGE','COM_MARKETINGROCKET_CONTENT_PAGE','COM_MARKETINGROCKET_SALES_PAGE','COM_MARKETINGROCKET_CHECKOUT_PAGE','COM_MARKETINGROCKET_SPECIAL_OFFER_PAGE','COM_MARKETINGROCKET_OTHER','COM_MARKETINGROCKET_THANKYOU_PAGE','COM_MARKETINGROCKET_BLANK_TEMPLATE') DEFAULT NULL,
  `hidden_css` text,
  `css` text,
  `unique_name` VARCHAR(100) NOT NULL,
  `exit_modal_html` TEXT NOT NULL,
  `page_option` LONGTEXT NOT NULL,
  `javascript` TEXT NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  AUTO_INCREMENT=1 ;

INSERT INTO `#__mrocket_landing_templates` (`id`, `name`, `desc`, `html`, `modal_html`, `form`, `type`, `hidden_css`, `css`, `unique_name`, `exit_modal_html`, `page_option`, `javascript`) VALUES
(1, 'Blank Canvas', 'Full Page Bootstrap 12 Column Blank Template. Create your own template from scratch.', '<div style="display: block;" class="MR-ELEMENTS" id="MarketingRocket">		<div aria-css="" style="" class="container-fluid added-element" id="MR_aBvAE8">			<div class="row-fluid" id="MR_aPvAnK">				<div class="col-md-12 span12 sortable" id="MarketingRocketMain">	<div id="MR_ahINYd" class="container-fluid">				<div id="MR_aqE86X" class="container-fluid container">						<div id="MR_atNhOT" class="row-fluid droppable ui-droppable">																				<div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn"><i class="fa fa-gear"></i></a></div></div>					<div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary"><i class="fa fa-gear"></i></a><a data-original-title="Remove" class="MR_remove btn-mini btn hasTooltip btn-primary"><i class="fa fa-times"></i></a><a data-original-title="Move Up" class="MR_SORT_UP hasTooltip btn-mini btn btn-primary"><i class="fa fa-chevron-up"></i></a><a data-original-title="Move Down" class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary"><i class="fa fa-chevron-down"></i></a></div></div>					</div></div>						</div>		<div class="el-button-holder"><a data-original-title="Page Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary"><i class="fa fa-gear"></i></a><a data-original-title="Delete Item" class="MR_remove btn-mini btn hasTooltip btn-primary"><i class="fa fa-times"></i></a></div></div>	</div>', '<div style="display: none;" id="MR_Modal_View" class="MR-ELEMENTS">                    <div aria-css="" style="" id="MR_a3R3E7" class="container-fluid added-element">                        <div id="MR_aY9QE7" class="row-fluid">                            <div id="MR_Modal_View_Modal" class="col-md-12 span12 sortable preview">								                                <div id="MR_ayzDKH" class="container-fluid haschild">                                    <div id="MR_aCFZeZ" class="row-fluid droppable ui-droppable haschild">                                                                            <article id="MR_aM553n" aria-type="articlebox" class="col-md-12 span12 simplebox added-element cant_drag ui-resizable ui-draggable"><div class="drag-point"></div><div class="element-type-holder">Text Box</div><div class="el-button-holder"><a class="MR_SORT_LEFT hasTooltip btn-mini btn" data-original-title="Move Left"><i class="fa fa-chevron-left"></i></a><a class="MR_SORT_RIGHT hasTooltip btn-mini btn" data-original-title="Move Right"><i class="fa fa-chevron-right"></i></a><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings"><i class="fa fa-gear"></i></a><a class="MR_remove btn-mini btn hasTooltip" data-original-title="Remove"><i class="fa fa-times"></i></a><a class="MR_duplicate btn-mini btn hasTooltip" data-original-title="Duplicate"><i class="fa fa-files-o"></i></a></div><div title="Rich Text Editor, editor1" style="position: relative;" class="content code-holder cke_editable cke_editable_inline cke_contents_ltr cke_show_borders" contenteditable="true"><p style="text-align:center;"><span style="font-size:25px;"><strong><span style="font-family:verdana, geneva, sans-serif;">Enter your Details Below.</span></strong></span></p></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-s"></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-e"></div></article><div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn">                                            <i class="fa fa-gear"></i>                                        </a></div></div>                                                                                                                                                                                <div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary">                                        <i class="fa fa-gear"></i>                                    </a><a data-original-title="Remove" class="MR_remove btn-mini btn hasTooltip btn-primary">                                        <i class="fa fa-times"></i>                                    </a><a data-original-title="Move Up" class="MR_SORT_UP hasTooltip btn-mini btn btn-primary">                                        <i class="fa fa-chevron-up"></i>                                    </a><a data-original-title="Move Down" class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary">                                        <i class="fa fa-chevron-down"></i>                                    </a></div></div><div id="MR_anc6C9" class="container-fluid haschild">                                    <div id="MR_aiC7ut" class="row-fluid haschild">                                        <div id="MR_aNEgyS" class="col-md-12 span12 simplebox form-modal-holder added-element ui-draggable ui-resizable form-vertical" aria-type="form">                                           <span>{placeholder}</span>                                                                                                                                   <div class="form-wrapper form-vertical"><div class="control-group"><div class="control-label">\n  <span>Name\n  \n    <abbr title="required">*</abbr>\n  \n</span></div><div class="controls"><input class="rf-size-"></input></div></div><div class="control-group"><div class="control-label">\n  <span>Email\n  \n    <abbr title="required">*</abbr>\n  \n</span></div><div class="controls"><input class="rf-size-"></input></div></div></div><div aria-css="" id="MR_form_submit" aria-mainclass="button-4" aria-type="button" class="added-element ui-draggable MR-button"><i></i><span>Enter Now!</span><div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings"><i class="fa fa-gear"></i></a></div></div>                                        <div class="el-button-holder"><a data-original-title="Move Left" class="MR_SORT_LEFT hasTooltip btn-mini btn">                                               <i class="fa fa-chevron-left"></i>                                           </a><a data-original-title="Move Right" class="MR_SORT_RIGHT hasTooltip btn-mini btn">                                                <i class="fa fa-chevron-right"></i>                                            </a><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn">                                                <i class="fa fa-gear"></i>                                            </a><a class="MR_Custom hasTooltip btn-mini btn" data-original-title="Edit Form"><i class="fa fa-pencil-square-o"></i></a></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-s"></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-e"></div></div>                                                                            <div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings">                                            <i class="fa fa-gear"></i>                                        </a></div></div>                                                                                                                                            <div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn btn-primary" data-original-title="Item Settings">                                        <i class="fa fa-gear"></i>                                    </a><a class="MR_SORT_UP hasTooltip btn-mini btn btn-primary" data-original-title="Move Up">                                        <i class="fa fa-chevron-up"></i>                                    </a><a class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary" data-original-title="Move Down">                                        <i class="fa fa-chevron-down"></i>                                    </a></div></div>                                                            <div class="container-fluid haschild" id="MR_aCk5la"><div id="MR_aaP2eq" class="row-fluid droppable ui-droppable haschild"><article id="MR_a1FTFq" aria-type="articlebox" class="col-md-12 span12 simplebox added-element cant_drag ui-resizable ui-draggable"><div class="drag-point"></div><div class="element-type-holder">Text Box</div><div class="el-button-holder"><a class="MR_SORT_LEFT hasTooltip btn-mini btn" data-original-title="Move Left"><i class="fa fa-chevron-left"></i></a><a class="MR_SORT_RIGHT hasTooltip btn-mini btn" data-original-title="Move Right"><i class="fa fa-chevron-right"></i></a><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings"><i class="fa fa-gear"></i></a><a class="MR_remove btn-mini btn hasTooltip" data-original-title="Remove"><i class="fa fa-times"></i></a><a class="MR_duplicate btn-mini btn hasTooltip" data-original-title="Duplicate"><i class="fa fa-files-o"></i></a></div><div title="Rich Text Editor, editor2" style="position: relative;" class="content code-holder cke_editable cke_editable_inline cke_contents_ltr cke_show_borders" contenteditable="true"><p style="text-align:center;">We respect your privacy, and will never share your information with third parties.</p></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-s"></div><div style="z-index: 90;" class="ui-resizable-handle ui-resizable-e"></div></article><div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings"><i class="fa fa-gear"></i></a></div></div><div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn btn-primary" data-original-title="Item Settings"><i class="fa fa-gear"></i></a><a class="MR_remove btn-mini btn hasTooltip btn-primary" data-original-title="Remove"><i class="fa fa-times"></i></a><a class="MR_SORT_UP hasTooltip btn-mini btn btn-primary" data-original-title="Move Up"><i class="fa fa-chevron-up"></i></a><a class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary" data-original-title="Move Down"><i class="fa fa-chevron-down"></i></a><a class="MR_duplicate btn-mini btn hasTooltip btn-primary" data-original-title="Add Section"><i class="fa fa-plus"></i></a></div></div><div class="container-fluid" id="MR_ar4ugF"><div id="MR_aGzJw0" class="row-fluid droppable ui-droppable"><div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn" data-original-title="Item Settings"><i class="fa fa-gear"></i></a></div></div><div class="el-button-holder"><a class="MR_Admin hasTooltip btn-mini btn btn-primary" data-original-title="Item Settings"><i class="fa fa-gear"></i></a><a class="MR_remove btn-mini btn hasTooltip btn-primary" data-original-title="Remove"><i class="fa fa-times"></i></a><a class="MR_SORT_UP hasTooltip btn-mini btn btn-primary" data-original-title="Move Up"><i class="fa fa-chevron-up"></i></a><a class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary" data-original-title="Move Down"><i class="fa fa-chevron-down"></i></a><a class="MR_duplicate btn-mini btn hasTooltip btn-primary" data-original-title="Add Section"><i class="fa fa-plus"></i></a></div></div></div>                        </div>                                            <div class="el-button-holder"><a data-original-title="Page Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary"><i class="fa fa-gear"></i></a></div></div>                </div>', '[{"label":"Name","field_type":"text","required":true,"field_options":{},"cid":"c1","name":"first-name"},{"label":"Email","field_type":"email","required":true,"field_options":{},"cid":"c10","cantdelete":true,"name":"email"}]', 'COM_MARKETINGROCKET_SQUEEZE_PAGE', '{"MR_form_submit":{"styles":{"cursor":"pointer","display":"none","background-color":"rgb(240, 130, 0)","color":"rgb(255, 255, 255)","font-size":"18px","text-decoration":"none","padding-left":"20px","padding-top":"20px","margin-top":"0px","padding-right":"20px","padding-bottom":"20px","margin-bottom":"0px","border-color":"rgb(228, 90, 5)","border-width":"0px 0px 5px 0px","border-style":"solid","border-radius":"5px","font-weight":"bold"},"hover":{"background-color":"rgb(228, 90, 5)","color":"rgb(255, 255, 255)","text-decoration":"none"},"iconStyle":{"color":"#ffffff"},"iconStyleHover":{"color":"rgb(255, 255, 255)"}},"MR_form_submit_exit":{"styles":{"display":"none"},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_aNEgyS":{"styles":{"text-align":"center"},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_aCk5la":{"styles":{},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_a3R3E7":{"styles":{"padding-left":"20px","padding-right":"20px","padding-top":"20px","padding-bottom":"20px","margin-top":"0px","margin-bottom":"0px","background-color":"rgb(255, 255, 255)","border-width":"0px 0px 0px 0px"},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_Modal_View":{"styles":{},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_ar4ugF":{"styles":{},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MR_aBvAE8":{"styles":{"padding-left":"0px","padding-right":"0px","padding-top":"0px","padding-bottom":"0px","margin-top":"0px","margin-bottom":"0px","background-color":"rgb(255, 255, 255)","border-radius":"0px"},"hover":{},"iconStyle":{},"iconStyleHover":{}},"MarketingRocket":{"styles":{},"hover":{},"iconStyle":{},"iconStyleHover":{}}}', '', 'blank-canvas', '<div style="display: none; width: 400px;" class="MR-ELEMENTS" id="MR_Exit_View_Holder">\n    <div id="MR_aDAUZX" class="container-fluid added-element">\n        <div class="row-fluid" id="MR_aPvAnK">\n            <div class="col-md-12 span12 sortable preview" id="MR_Exit_View">\n                <div id="MR_aFBrqH" class="container-fluid">\n                    <div id="MR_atNhOT" class="row-fluid droppable ui-droppable">\n                        \n                    <div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn">\n                            <i class="fa fa-gear">\n                      </i>\n                        </a></div></div>\n                    \n                    \n                    \n                     \n                <div class="el-button-holder"><a data-original-title="Item Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary">\n                        <i class="fa fa-gear"></i>\n                    </a><a data-original-title="Remove" class="MR_remove btn-mini btn hasTooltip btn-primary">\n                        <i class="fa fa-times"></i>\n                    </a><a data-original-title="Move Up" class="MR_SORT_UP hasTooltip btn-mini btn btn-primary">\n                        <i class="fa fa-chevron-up"></i>\n                    </a><a data-original-title="Move Down" class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary">\n                        <i class="fa fa-chevron-down"></i>\n                    </a></div></div>\n            </div>\n        </div> <div class="el-button-holder"><a data-original-title="Page Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary"><i class="fa fa-gear"></i></a></div></div>\n</div>', '{"selected_form_style":"","load_fonts":null}', '');


CREATE TABLE IF NOT EXISTS `#__mrocket_leads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `landing_id` int(11) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(255) DEFAULT NULL,
  `form_data` text,
  `lead_status` int(11) DEFAULT NULL,
  `is_temp` tinyint(1) DEFAULT '0',
  `note` text,
  `converted_date` date DEFAULT NULL,
  `user_id` int(11) DEFAULT 0,
  `w_metter` decimal(8,2) NOT NULL DEFAULT '0.00',
  `w_last_log_id` INT NOT NULL DEFAULT '0',
  `recieve_email` TINYINT NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;



CREATE TABLE `#__mrocket_leads_cron` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) DEFAULT NULL,
  `cron_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cron_job` varchar(255) DEFAULT NULL COMMENT 'defualt responder or mailchimp',
  `responder_id` varchar(100) DEFAULT NULL,
  `is_done` tinyint(1) DEFAULT '0',
  `is_clicked` tinyint(1) DEFAULT '0',
  `is_show` tinyint(1) DEFAULT '0',
  `ref` varchar(255) DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `body` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11;





CREATE TABLE IF NOT EXISTS `#__mrocket_leads_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) DEFAULT NULL,
  `tag_id` int(11) DEFAULT NULL,
  `campaign_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__mrocket_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `landing_id` int(11) DEFAULT NULL,
  `lead_id` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `payer_email` varchar(255) DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `ref_code` varchar(255) DEFAULT NULL,
  `params` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__mrocket_refcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) DEFAULT NULL,
  `landing_id` int(11) DEFAULT NULL,
  `ref_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;



CREATE TABLE `#__mrocket_responder_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `sequence_id` int(11) NOT NULL,
  `from_name` varchar(300) NOT NULL,
  `from_email` varchar(300) NOT NULL,
  `send_type` enum('before','after','on_date','rough') NOT NULL DEFAULT 'after',
  `send_option` varchar(300) NOT NULL,
  `subject` varchar(350) NOT NULL,
  `body` longtext NOT NULL,
  `published` tinyint(4) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `type` enum('marketing','responder','pre','template','mass','invoice','mass_template', 'opt_in') NOT NULL DEFAULT 'responder',
  `webinar_id` int(11) DEFAULT NULL,
  `unique_name` varchar(100) NOT NULL,
  `split_by` int(11) NOT NULL DEFAULT '0',
  `must_show_next` int(11) NOT NULL DEFAULT '0',
  `css` text NOT NULL,
  `editor_body` longtext NOT NULL,
  `options` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19;

INSERT INTO `#__mrocket_responder_templates` (`id`, `name`, `sequence_id`, `from_name`, `from_email`, `send_type`, `send_option`, `subject`, `body`, `published`, `created`, `modified`, `modified_by`, `created_by`, `publish_up`, `publish_down`, `type`, `webinar_id`, `unique_name`) VALUES
(1, 'Notification', 0, 'NULL', 'NULL', 'after', '0', 'New Lead Notification', '<p>New Lead With Name : {%email.lead.first_name%} {%email.lead.last_name%} Registered In {%email.campaign_name%} Campaign </p>', 1, '2014-04-01 09:44:32', '0000-00-00 00:00:00', 0, 428, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'pre', NULL, NULL),
(Null, 'Simple Email', 0, 'John Doe', 'test@email.com', 'before', '0', '', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;">  <head>    <meta name="viewport" content="width=device-width" />    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />    <title>Really Simple HTML Email Template</title>  </head>  <body bgcolor="#f6f6f6" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; -webkit-font-smoothing: antialiased; -webkit-text-size-adjust: none; width: 100% !important; height: 100%; margin: 0; padding: 0;">&#13;&#13;&#13;<table style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; width: 100%; margin: 0; padding: 20px;"><tr style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"><td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"></td>&#13;		<td bgcolor="#FFFFFF" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto; padding: 20px; border: 1px solid #f0f0f0;">&#13;&#13;			&#13;			<div style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; max-width: 600px; display: block; margin: 0 auto; padding: 0;">&#13;			<table style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; width: 100%; margin: 0; padding: 0;"><tr style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"><td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;">&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">Hi there,</p>&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">Sometimes all you want is to send a simple HTML email with a basic design.</p>&#13;						<h1 style="font-family: ''Helvetica Neue'', Helvetica, Arial, ''Lucida Grande'', sans-serif; font-size: 36px; line-height: 1.2; color: #000; font-weight: 200; margin: 40px 0 10px; padding: 0;">Really simple HTML email template</h1>&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">This is a really simple email template. It''s sole purpose is to get you to click the button below.</p>&#13;						<h2 style="font-family: ''Helvetica Neue'', Helvetica, Arial, ''Lucida Grande'', sans-serif; font-size: 28px; line-height: 1.2; color: #000; font-weight: 200; margin: 40px 0 10px; padding: 0;">How do I use it?</h2>&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">All the information you need is on GitHub.</p>&#13;						<table style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; width: 100%; margin: 0; padding: 0;"><tr style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"><td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 10px 0;">&#13;									<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;"><a href="https://github.com/leemunroe/html-email-template" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 2; color: #FFF; text-decoration: none; font-weight: bold; text-align: center; cursor: pointer; display: inline-block; border-radius: 25px; background-color: #348eda; margin: 0 10px 0 0; padding: 0; border-color: #348eda; border-style: solid; border-width: 10px 20px;">View the source and instructions on GitHub</a></p>&#13;								</td>&#13;							</tr></table><p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">Feel free to use, copy, modify this email template as you wish.</p>&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;">Thanks, have a lovely day.</p>&#13;						<p style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6; font-weight: normal; margin: 0 0 10px; padding: 0;"><a href="http://twitter.com/leemunroe" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; color: #348eda; margin: 0; padding: 0;">Follow @leemunroe on Twitter</a></p>&#13;					</td>&#13;				</tr></table></div>&#13;			&#13;									&#13;		</td>&#13;		<td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"></td>&#13;	</tr></table><table style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; width: 100%; clear: both !important; margin: 0; padding: 0;"><tr style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"><td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"></td>&#13;		<td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto; padding: 0;">&#13;			&#13;			&#13;			<div style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; max-width: 600px; display: block; margin: 0 auto; padding: 0;">&#13;				<table style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; width: 100%; margin: 0; padding: 0;"><tr style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"><td align="center" style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;">&#13;										</td>&#13;					</tr></table></div>&#13;			&#13;				&#13;		</td>&#13;		<td style="font-family: ''Helvetica Neue'', ''Helvetica'', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6; margin: 0; padding: 0;"></td>&#13;	</tr></table></body></html>', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'template', 0, 'simple_template_no1'),
(Null, '3 Days After Opt-In - Fear', 2, 'John Doe', 'test@email.com', 'after', '1', 'This is your last chance', '<p>This is it…I’m done talking to you about this: <br />{landing-link=%wizard%}Your Text{/landing-link}<br />For the last few days I’ve been encouraging you to get in while you can, but now time is up. After today, you won’t hear me talking about it any longer. <br />So this is your last chance. <br />Get in now, or risk missing out completely: <br />{landing-link=%wizard%}Your Text{/landing-link}</p>\r\n<p><br />All the best,</p>\r\n<p><em><strong>[Name]</strong></em></p>\r\n<p><br />P.S. Remember, not only will it get you [insert specific benefit provided by the offer here], but it will also give you the momentum you desperately need to achieve [insert broad-­­based desired end result]. <br />Get off the fence and get started NOW: <br />{landing-link=%wizard%}Your Text{/landing-link}</p>\r\n<p> </p>\r\n<div style="color: #212121; font-family: ''Helvetica Neue'', Helvetica, Arial, sans-serif; font-size: 13.1999998092651px; line-height: 19.7999992370605px;">\r\n<table style="width: 469px; height: 56px;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="text-align: right;" lang="" dir="" scope="" rowspan="1" colspan="1" valign="top"><span style="font-size: x-small;"><strong>Phone:<br /></strong><strong>Web:</strong><br /><strong>Email:</strong></span> <span style="font-size: x-small;"><br /></span></td>\r\n<td lang="" dir="" scope="" valign="top"><span style="font-size: x-small;">123 123 123<br /><a href="http://www.marketing-rocket.com/" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>ourwebsite.com</span> <span style="font-size: x-small;"><br /><a href="mailto:eden@marketing-rocket.com" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>our@emailhere.com</span></td>\r\n<td lang="" dir="" scope="" valign="middle"><img src="/media/com_marketingrocket/email-logo.jpg" alt="" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>', 1, '2015-05-10 09:38:32', '0000-00-00 00:00:00', 0, 428, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'template', 48, '3-days-after-initial-opt-in'),
(Null, '1 Day After Opt-In - Gain', 2, 'John Doe', 'test@email.com', 'after', '1', 'Have you seen this yet?', '<p>Yesterday you requested my [insert lead magnet title/description here], and I just wanted to check back in a see if you had a chance to [read/watch] it yet.</p>\r\n<p>More importantly, I wanted to make sure you saw this:</p>\r\n<p>{landing-link=%wizard%}Your Text{/landing-link}</p>\r\n<p>If you’re really serious about [insert topic/known desired end result], then this is the ideal first step.</p>\r\n<p>Not only does it work, at only [insert price] it’s the tiniest investment you can make and still have a realistic expectation of results.</p>\r\n<p>So get it now while you can:</p>\r\n<p>{landing-link=%wizard%}Your Text{/landing-link}</p>\r\n<p>This price won’t be available much longer, so I would grab your copy now while it’s still fresh in your mind. </p>\r\n<p><br />Talk soon,</p>\r\n<p><em><strong>[Name]</strong></em></p>\r\n<p><span style="color: #212121; font-family: ''Helvetica Neue'', Helvetica, Arial, sans-serif; font-size: 13.1999998092651px; line-height: 19.7999992370605px;"></span></p>\r\n<table style="font-family: ''Helvetica Neue'', Helvetica, Arial, sans-serif; width: 469px; height: 56px;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="text-align: right;" lang="" dir="" scope="" rowspan="1" colspan="1" valign="top"><span style="font-size: x-small;"><strong>Phone:<br /></strong><strong>Web:</strong><br /><strong>Email:</strong></span> <span style="font-size: x-small;"><br /></span></td>\r\n<td lang="" dir="" scope="" valign="top"><span style="font-size: x-small;">123 123 123<br /><a href="http://www.marketing-rocket.com/" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>ourwebsite.com</span> <span style="font-size: x-small;"><br /><a href="mailto:eden@marketing-rocket.com" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>our@emailhere.com</span></td>\r\n<td lang="" dir="" scope="" valign="middle"><img src="/media/com_marketingrocket/email-logo.jpg" alt="" /></td>\r\n</tr>\r\n</tbody>\r\n</table>', 1, '2015-05-10 08:00:57', '2015-05-10 09:39:35', 0, 428, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'template', 48, '1-day-after-initial-opt-in'),
(Null, '2 Days After Opt-In - Logic', 2, 'John Doe', 'test@email.com', 'after', '1', 'I''m a little surprised?', '<p>Call me crazy, but I’m a little surprised you still haven’t taken me up on this:</p>\r\n<p>{landing-link=%wizard%}Your Text{/landing-link}</p>\r\n<p>If you really want to [insert known desired end result] (and I’m guessing you do or you wouldn’t have even visited my site), then this is the ideal first step.</p>\r\n<p><br />Remember, not only will it get you [insert specific benefit provided by the offer here], but it will also give you the momentum you desperately need to achieve [insert broad-­­based desired end result].</p>\r\n<p><br />So DO IT NOW before it gets lost in the shuffle of life.</p>\r\n<p>Talk soon,</p>\r\n<p><em><strong>[Name]</strong></em></p>\r\n<p><span style="color: #212121; font-family: ''Helvetica Neue'', Helvetica, Arial, sans-serif; font-size: 13.1999998092651px; line-height: 19.7999992370605px;"></span></p>\r\n<table style="font-family: ''Helvetica Neue'', Helvetica, Arial, sans-serif; width: 469px; height: 56px;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="text-align: right;" lang="" dir="" scope="" rowspan="1" colspan="1" valign="top"><span style="font-size: x-small;"><strong>Phone:<br /></strong><strong>Web:</strong><br /><strong>Email:</strong></span> <span style="font-size: x-small;"><br /></span></td>\r\n<td lang="" dir="" scope="" valign="top"><span style="font-size: x-small;">123 123 123<br /><a href="http://www.marketing-rocket.com/" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>ourwebsite.com</span> <span style="font-size: x-small;"><br /><a href="mailto:eden@marketing-rocket.com" target="_blank" style="color: #3f51b5; z-index: 0; position: relative;">y</a>our@emailhere.com</span></td>\r\n<td lang="" dir="" scope="" valign="middle"><img src="/media/com_marketingrocket/email-logo.jpg" alt="" /></td>\r\n</tr>\r\n</tbody>\r\n</table>', 1, '2015-05-10 08:06:09', '2015-05-10 08:07:44', 0, 428, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'template', 48, '2-days-after-initial-opt-in');
INSERT INTO `#__mrocket_responder_templates` (`id`, `name`, `sequence_id`, `from_name`, `from_email`, `send_type`, `send_option`, `subject`, `body`, `published`, `created`, `modified`, `modified_by`, `created_by`, `publish_up`, `publish_down`, `type`, `webinar_id`, `unique_name`, `split_by`, `must_show_next`, `css`, `editor_body`) VALUES
(null, 'Inovice', 0, 'Marketing Rocket', 'test@test.com', 'after', '', 'Inovice', '<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td align="left" width="100%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td width="100%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td align="left" valign="top" width="50%">\r\n<p style="font-size: 12pt; font-family: arial, helvetica, sans-serif; font-weight: bold;">Your Company Name</p>\r\n<p style="font-family: arial, helvetica, sans-serif;">Someplace Drive 123,<br /> 12345 Somewhere,<br /> Country</p>\r\n<p style="font-family: arial, helvetica, sans-serif;">VAT Number: XX012345678<br /> Tel: +00 123 456 7890</p>\r\n</td>\r\n<td align="center" valign="middle" width="50%">Your logo goes here</td>\r\n</tr>\r\n<tr>\r\n<td colspan="2" align="left" width="100%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td align="left" valign="top" width="50%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td colspan="2" style="background-color: #d6d6d6;" align="left">\r\n<h4 style="margin: 0px;"><span style="font-family: arial, helvetica, sans-serif;">Customer Information</span></h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">First Name</span></strong></td>\r\n<td align="left">{%email.lead.first_name%}</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">Last Name</span></strong></td>\r\n<td align="left">{%email.lead.last_name%}</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">Email</span></strong></td>\r\n<td align="left">{%email.lead.email%}</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong>&nbsp;</strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align="left" valign="top" width="50%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td colspan="2" style="background-color: #d6d6d6;" align="left">\r\n<h4 style="margin: 0px;"><span style="font-family: arial, helvetica, sans-serif;">Invoice Information</span></h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">Invoice Number</span></strong></td>\r\n<td align="left"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal;">{%invoice.number%}</span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">Invoice Date</span></strong></td>\r\n<td align="left"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal;">{%invoice.date%}</span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">This invoice is <span style="color: #008000;">PAID</span></span></strong></td>\r\n<td align="left">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong>&nbsp;</strong></td>\r\n<td align="left">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;">Payment method</span></strong></td>\r\n<td align="left"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal;">{%invoice.method%}</span></td>\r\n</tr>\r\n<tr>\r\n<td align="left" width="50%"><strong><span style="font-family: arial, helvetica, sans-serif;"></span></strong></td>\r\n<td align="left"><span style="font-family: arial, helvetica, sans-serif;"></span></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan="2" style="background-color: #d6d6d6;" align="left">\r\n<h4 style="margin: 0px;"><span style="font-family: arial, helvetica, sans-serif;">Order Items</span></h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan="2" align="left" width="100%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td style="text-align: left;" align="left" valign="top" width="15%"><strong><span style="font-family: arial, helvetica, sans-serif;">Item&nbsp;</span></strong></td>\r\n<td style="text-align: left;" align="right" valign="top" width="25%"><strong><span style="font-family: arial, helvetica, sans-serif;">Price</span></strong></td>\r\n</tr>\r\n<tr>\r\n<td style="text-align: left;" align="left" valign="top" width="15%"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal; background-color: #ffffff;">{%invoice.product_name%}</span></td>\r\n<td style="text-align: right;" align="right" valign="top" width="25%"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal;">{%invoice.price%}<span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal;">{%invoice.currency%}</span></span></td>\r\n</tr>\r\n<tr>\r\n<td style="text-align: left;" align="left" valign="top" width="15%">&nbsp;</td>\r\n<td style="text-align: right;" align="right" valign="top" width="25%">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td align="right" valign="top" width="75%"><strong><span style="font-family: arial, helvetica, sans-serif;">Subtotal :</span></strong></td>\r\n<td style="text-align: right;" align="right" valign="top" width="25%"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal; text-align: right;">{%invoice.price%}</span><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal; text-align: right;">{%invoice.currency%}</span></td>\r\n</tr>\r\n<tr>\r\n<td align="right" valign="top" width="75%"><strong><span style="font-family: arial, helvetica, sans-serif;">VAT% :</span></strong></td>\r\n<td style="text-align: right;" align="right" valign="top" width="25%"><span style="font-family: arial, helvetica, sans-serif;">0</span></td>\r\n</tr>\r\n<tr>\r\n<td style="background-color: #f5f5f5; text-align: right;"><strong><span style="font-family: arial, helvetica, sans-serif;">Total Payable Amount :</span></strong></td>\r\n<td style="background-color: #f5f5f5; text-align: right;"><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal; text-align: right;">{%invoice.price%}</span><span style="color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; line-height: normal; text-align: right;">{%invoice.currency%}</span></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan="2" style="background-color: #d6d6d6;" align="left">\r\n<h4 style="margin: 0px;"><span style="font-family: arial, helvetica, sans-serif;">Invoice Notes</span></h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan="2" align="left" width="100%">\r\n<table border="0" style="width: 100%;" cellspacing="0" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style="font-family: arial, helvetica, sans-serif;"></span></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'invoice', NULL, '', 0, 0, '', '');

INSERT INTO `#__mrocket_responder_templates` (`id`, `name`, `sequence_id`, `from_name`, `from_email`, `send_type`, `send_option`, `subject`, `body`, `published`, `created`, `modified`, `modified_by`, `created_by`, `publish_up`, `publish_down`, `type`, `webinar_id`, `unique_name`, `split_by`, `must_show_next`, `css`, `editor_body`, `options`) VALUES
(NULL, 'Opt In', 0, '', '', 'after', '', 'Please Confirm your request', '<p>Hello,</p>\r\n<p>Thanks for your request to join {%email.campaign_name%}.</p>\r\n<p>Click this link to confirm your request to join the list:</p>\r\n<p>{opt-in-link}Click Here{/opt-in-link}</p>\r\n<p>Clicking the link above will confirm your email address and allow you to receive the information you requested. If you cannot click on the link, please copy and paste it into your web browse.</p>\r\n<p>If you did not request to be on this list, please ignore this message. We confirm addresses prior to adding them to our list to prevent forged or unwanted sign-ups.</p>\r\n<p>Thank you,</p>', 1, '2016-08-24 09:22:34', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'opt_in', NULL, '', 0, 0, '', '', '');


CREATE TABLE IF NOT EXISTS `#__mrocket_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT 'name of this record',
  `description` mediumtext CHARACTER SET utf8 NOT NULL COMMENT 'description of this record',
  `default` tinyint(1) DEFAULT '0' COMMENT 'Default status',
  `final` tinyint(1) DEFAULT '0',
  `published` tinyint(1) DEFAULT '0' COMMENT 'publication status of record - 0 is Unpublished, 1 is Published, -2 is Trashed',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'when record was created, in UTC',
  `created_by` int(11) NOT NULL DEFAULT '0' COMMENT 'User id of record creator',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'when record was last modified in UTC',
  `modified_by` int(11) NOT NULL DEFAULT '0' COMMENT 'User id of last modifier',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  AUTO_INCREMENT=4 ;



INSERT INTO `#__mrocket_statuses` (`id`, `name`, `description`, `default`, `final`, `published`, `created`, `created_by`, `modified`, `modified_by`) VALUES
(1, 'New Lead', '', 1, 0, 1, '2014-04-04 18:35:32', 0, '2014-04-04 18:39:27', 0),
(2, 'Not Interested ', '', 0, 0, 1, '2014-04-04 18:35:44', 0, '0000-00-00 00:00:00', 0),
(3, 'Converted', '', 0, 1, 1, '2014-04-04 18:35:54', 0, '2014-04-04 18:38:57', 0);


CREATE TABLE IF NOT EXISTS `#__mrocket_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `desc` text NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL,
  KEY `id` (`id`)
) ENGINE=InnoDB  AUTO_INCREMENT=5 ;


INSERT INTO `#__mrocket_tags` (`id`, `title`, `desc`, `created`, `modified`, `modified_by`, `created_by`, `published`) VALUES
(1, 'Cold', '', '2014-04-04 18:34:08', '0000-00-00 00:00:00', 0, 0, 1),
(2, 'Warm', '', '2014-04-04 18:34:16', '0000-00-00 00:00:00', 0, 0, 1),
(3, 'Hot', '', '2014-04-04 18:34:50', '2014-04-04 18:34:55', 0, 0, 1),
(4, 'On Fire', '', '2014-04-04 18:35:07', '0000-00-00 00:00:00', 0, 0, 1);


CREATE TABLE `#__mrocket_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `campaign_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `main_keyword` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(800) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `public_accsess` tinyint(1) DEFAULT NULL,
  `form_json` text,
  `form_or_cta` enum('form','cta','none') DEFAULT NULL,
  `form_name` varchar(255) DEFAULT NULL,
  `responder_type` varchar(255) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `responder_sequence_id` varchar(255) DEFAULT NULL,
  `convert_from_another` varchar(255) DEFAULT NULL,
  `convert_again` varchar(255) DEFAULT NULL,
  `have_paypal` tinyint(1) DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `submit_text` varchar(255) DEFAULT NULL,
  `notification` tinyint(1) DEFAULT NULL,
  `notification_email` varchar(255) DEFAULT NULL,
  `cta_type` enum('image','text') DEFAULT NULL,
  `cta_image_src` varchar(255) DEFAULT NULL,
  `cta_image_alt` varchar(255) DEFAULT NULL,
  `cta_text` text,
  `after_filling` enum('menu_item','redirect_url','message','to_landing_page') DEFAULT NULL,
  `menu_item` int(11) DEFAULT NULL,
  `message` text,
  `to_landing_page` int(11) DEFAULT NULL,
  `adding_tag` varchar(11) DEFAULT NULL,
  `page_html` longtext,
  `page_editor` longtext,
  `redirect_url` varchar(255) DEFAULT NULL,
  `is_split` tinyint(1) DEFAULT NULL,
  `removing_tag` varchar(255) DEFAULT NULL,
  `paypal_account` varchar(255) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT NULL,
  `modal_header` varchar(255) DEFAULT NULL,
  `modal_body` text,
  `modal_background_color` varchar(255) DEFAULT NULL,
  `modal_background-color_transparent` tinyint(4) DEFAULT NULL,
  `modal_background_image` varchar(255) DEFAULT NULL,
  `modal_background_repeat` varchar(255) DEFAULT NULL,
  `modal_text_color` varchar(255) DEFAULT NULL,
  `css` text,
  `javascript` text,
  `hidden_css` text,
  `convert_lead` tinyint(1) DEFAULT '0',
  `modal_editor` text,
  `paypal_currency` enum('AUD','BRL','CAD','EUR','GBP','JPY','USD','NZD','CHF','HKD','SGD','SEK','DKK','PLN','NOK','HUF','CZK','MXN','MYR','PHP','TWD','THB','ILS','TRY') NOT NULL,
  `paypal_product_name` varchar(255) DEFAULT NULL,
  `after_pay` enum('to_landing_page','redirect_url','message','menu_item') DEFAULT NULL COMMENT 'this will be used for canceling payment',
  `pay_menu_item` int(11) DEFAULT NULL,
  `pay_redirect_url` varchar(255) DEFAULT NULL,
  `pay_to_landing_page` int(11) DEFAULT NULL,
  `pay_message` text,
  `page_option` longtext NOT NULL,
  `viewing_tag` varchar(600) DEFAULT NULL,
  `save_type` enum('auto','preview','html') DEFAULT NULL,
  `landing_id` int(11) DEFAULT NULL,
  `exit_popup_modal` LONGTEXT NOT NULL , 
  `exit_popup_modal_editor` LONGTEXT NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `#__mrocket_lead_campaigns` (
  `lead_id` int(11) NOT NULL,
  `campaign_id` int(11) NOT NULL,
  UNIQUE KEY `user_id_2` (`lead_id`,`campaign_id`)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS `#__mrocket_lead_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_id` int(11) DEFAULT NULL,
  `lead_id` int(11) DEFAULT NULL,
  `campaign_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead` (`lead_id`)
) ENGINE=InnoDB;


CREATE TABLE IF NOT EXISTS `#__mrocket_reponders_sequences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `campaign_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `add_to_existing_lead` tinyint(1) NOT NULL DEFAULT '0',
  `add_to_recieved_before` tinyint(1) NULL DEFAULT '0',
  `send_to_tags_if` enum('any','all') NOT NULL,
  `send_to_tags` varchar(255) NOT NULL,
  `dont_send_to_tags_if` enum('any','all') NOT NULL,
  `dont_send_to_tags` varchar(255) NOT NULL,
  `adding_tag` INT NOT NULL DEFAULT '0',
  `adding_tag_before` INT NOT NULL DEFAULT '0',
  `adding_tag_end` INT NOT NULL DEFAULT '0',
  `remove_tag_end` INT NOT NULL DEFAULT '0',
  `from_name` varchar(255) NOT NULL,
  `from_email` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `#__mrocket_api` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `api` text,
  `type` varchar(255) DEFAULT NULL,
  `params` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4;

CREATE TABLE IF NOT EXISTS `#__mrocket_responder_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `responder_id` int(11) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `orginal_file_name` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3;


CREATE TABLE IF NOT EXISTS `#__mrocket_webinar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `description` text NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `timezone` varchar(255) DEFAULT NULL,
  `public_status` enum('public','private','unlisted') NOT NULL,
  `api_id` int(11) DEFAULT NULL,
  `video_id` varchar(11) DEFAULT NULL,
  `snipest_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0;


CREATE TABLE `#__mrocket_lead_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `landing_id` int(11) DEFAULT NULL,
  `lead_id` int(11) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `value` varchar(2000) DEFAULT NULL,
  `label` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_id` (`lead_id`),
  KEY `field_name` (`field_name`)
) ENGINE=InnoDB AUTO_INCREMENT=75;

CREATE TABLE IF NOT EXISTS `#__mrocket_api_types` (
  `type` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `params` text,
  `category` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `plugin` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`type`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB;

-- ----------------------------
-- Records of jo_mrocket_api_types
-- ----------------------------
INSERT INTO `#__mrocket_api_types` VALUES ('google', 'Hangout Webinar', 'Google Youtube Api For Creating Webianrs', null, 'other', '<i class=\"fa fa-5x fa fa-5x fa-google\"></i>', null);
INSERT INTO `#__mrocket_api_types` VALUES ('mail_chimp', 'MailChimp', 'Api for handling all marketing emails tasks through MailChimp', '', 'marketing_email', '<img src=\"components/com_marketingrocket/assets/images/mailchimp-logo.png\"  />', null);



CREATE TABLE `#__mrocket_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `landing_id` int(11) NOT NULL,
  `condition_type` enum('any','all','dont_any','dont_all','all_time') NOT NULL,
  `tags` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `responder_type` varchar(255) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `target` varchar(30) NOT NULL,
  `order` int(11) DEFAULT NULL,
  `type` enum('landing_action','tag_action') NOT NULL DEFAULT 'landing_action',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB;


CREATE TABLE `#__mrocket_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `log` text NOT NULL,
  `time` datetime NOT NULL,
  `lead_id` int(11) NOT NULL,
  `target_id` int(11) NOT NULL,
  `table` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `lead_id` (`lead_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21;

CREATE TABLE `#__mrocket_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `read_status` tinyint(1) DEFAULT '0',
  `is_system` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9;

CREATE TABLE `#__mrocket_action_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
