<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelWizard extends JModelAdmin
{
    public $dir = '';
    public function __construct($config = array()) {
        $this->dir = JPATH_SITE
            .DS.'media'
            .DS.'com_marketingrocket'
            .DS.'wizard'
            .DS;
        parent::__construct($config);
    }
    public function getTemplates(){
        
        $files = $this->Sort_Directory_Files_By_Last_Modified($this->dir, 'asc');
        $files = $files[0];
//        Zend_Debug::dump($files);
//        die;
//        $files  = scandir($this->dir);
        $filesArray = array();
        foreach ($files as $key => $file){
            $file = $file['file'];
            if($file == '.' || $file == '..' || $file == 'index.html' || strpos($file, '.xml') === false)
                continue;
            
            try {
                $row = new stdClass();
                $row->file = $file;
                
                $dom = new DOMDocument();
                $dom->load($this->dir.$file);

                $row->title = $dom->getElementsByTagName('title')->item(0)->nodeValue;
                 if($dom->getElementsByTagName('icon')->length > 0)
                    $row->icon = $dom->getElementsByTagName('icon')->item(0)->nodeValue;
                else 
                    $row->icon = '<i class="fa"></i>';
                
                $row->name = $dom->getElementsByTagName('name')->item(0)->nodeValue;
                

                $filesArray[] = $row;
            }
            catch(Exception $e){
                
            }
        }
        return $filesArray;
    }
    
    public function getTemplate($name){
        if(!file_exists($this->dir.$name)){
            throw new Exception('Template Dosn"t Exist');
        }
        $dom = new DOMDocument();
        $dom->load($this->dir.$name);
        
        $obj = new stdClass();
        $obj->name = $dom->getElementsByTagName('name')->item(0)->nodeValue;
        $obj->file = $dom->getElementsByTagName('name')->item(0)->nodeValue.'.xml';
        $obj->title = $dom->getElementsByTagName('title')->item(0)->nodeValue;
        
        if($dom->getElementsByTagName('icon')->length > 0)
            $obj->icon = $dom->getElementsByTagName('icon')->item(0)->nodeValue;
        else 
            $obj->icon = '<i class="fa"></i>';
        
        $obj->desc = $dom->getElementsByTagName('desc')->item(0)->nodeValue;
        
        if($dom->getElementsByTagName('image')->length > 0)
            $obj->image = $dom->getElementsByTagName('image')->item(0)->getAttribute('src');
        else 
            $obj->image = '';
        
        $items = array();
        
        $landingsCount = 0;
        
        foreach($dom->getElementsByTagName('items')->item(0)->getElementsByTagName('item') as $item){
            $rowObj = new stdClass();
            $rowObj->type = $item->getElementsByTagName('type')->item(0)->nodeValue;
            
            if($rowObj->type == 'landing')
                $landingsCount++;
            
            if($item->getElementsByTagName('name')->length > 0)
                $rowObj->name = $item->getElementsByTagName('name')->item(0)->nodeValue;
            else 
                $rowObj->name = '';
            
            $options = $item->getElementsByTagName('options');
            $rowObj->options = $this->_fillOptions($options->item(0));
            
            if($rowObj->type == 'start'){
                $startObj = new stdClass();
                $startObj->count = 0;
                $startObj->title = (!empty($rowObj->options->title)) ? $rowObj->options->title : $rowObj->name;
                $startObj->subject = (!empty($rowObj->options->subject)) ? $rowObj->options->subject : '';
                $startObj->selected_template = (!empty($rowObj->options->template)) ? $rowObj->options->template : '';
                
                $rowObj->options->days = new stdClass();
                $rowObj->options->days->day = array(
                     $startObj
                );
            }
            
            if($rowObj->type == 'responder'){
                $rowObj->sequence_name = $rowObj->name;
            }
            
            $items[] = $rowObj;
        }
        
        $obj->landingCount = $landingsCount;
        $obj->items = $items;
        return $obj;
    }
    
    private function _fillOptions($element){
        $obj = new stdClass();
        $childs = $element->childNodes;
        $count = 0;
        
        foreach ($childs as $child){
            $nodeName = $child->nodeName;
            if($nodeName == '#text')
                continue;
            $row = new stdClass();
            $ret = $this->_fillOptions($child);
            if(empty($ret)){
                
                if(in_array($nodeName, array(
                    'send_to_tags',
                    'dont_send_to_tags',
                    'adding_tag',
                    'viewing_tag',
                    'removing_tag',
                    'tags'
                )))
                {
                    $ret = $this->handleTags($child->nodeValue);
                }
                else {
                    $ret = $child->nodeValue;    
                }
                
            }
            
            if(isset($obj->$nodeName)){
                if(is_array($obj->$nodeName)){
                    array_push($obj->$nodeName, $ret);
                }
                else 
                    $obj->$nodeName = array($obj->$nodeName ,  $ret);
            }
            else 
                $obj->$nodeName = $ret;
            
            $count++;
            
            
        }
        if($count == 0)
            return false;
        
        return $obj;
    }
    
    public function handleTags($tagsString){
        if($this->_isJson($tagsString)){
            $tags = json_decode($tagsString);
        }
        else {
            $tags = array($tagsString);
        }
        $array = array();
        
        $db = $this->getDbo();
        foreach ($tags as $tag){
            
            $q = $db->getQuery(true);
            
            $q->select('id')->from('#__mrocket_tags')
                    ->where('LOWER(title) = '.$db->q(strtolower($tag)));
            
            $db->setQuery($q);
            
            $res = $db->loadResult();
            
            if(!empty($res)){
                $array[] = $res;
            }
            else {
                $tagTable = $this->getTable('Tag', 'MarketingrocketTable');
                $tagTable->title = $tag;
                $tagTable->published = 1;
                $tagTable->store();
                $array[] = $tagTable->id;
            }
        }
        if(!empty($array))
            return json_encode($array);
        else 
            return '';
    }

    public function getForm($data = array(), $loadData = true) {
        
        $input = JFactory::getApplication()->input;
        if(empty($data)){
             $step = $input->getInt('step', 1);
        }
        else {
            $step = $data['step'];
        }
        if($step > 1){
            $session = JFactory::getSession();
            $template = $session->get('wizard', false, 'com_marketingrocket');

            $step = $template->items[$step-2]->type;
        }
        $form = $this->loadForm('com_marketingrocket.step_'.$step, 'step_'.$step, array('control' => 'jform', 'load_data' => $loadData));
        
        

        if (empty($form))
        {
            return false;
        }

        return $form;
    }
    
    protected function loadFormData()
    {
        $input = JFactory::getApplication()->input;
         
        $step = $input->getInt('step', 1);
        
        // Check the session for previously entered form data.
        $data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.'.$step.'.data', array());

        if (empty($data))
        {
            if($step == 1){
                $session = JFactory::getSession();
                $template = $session->get( 'wizard', null, 'com_marketingrocket');
                $data = array('name' => trim($template->title), 'desc' => trim(strip_tags($template->desc)));
            }
            else {
                $session = JFactory::getSession();
                $template = $session->get( 'wizard', null, 'com_marketingrocket');

                if($template->items[$step-2]->type == 'landing'){
                    if(!empty($template->items[$step-2]->name))
                        $data = array('name' => $template->items[$step-2]->name);
                    
                    if(!empty($template->items[$step-2]->selected_template))
                        $data['selected_template'] = $template->items[$step-2]->selected_template;
                }
                else if($template->items[$step-2]->type == 'responder'){
                    $item = $template->items[$step-2];
                    if(!empty($item->responder_type)){
                        
                        $data = array('responder_type' => $item->responder_type);
                        $data['sequence_name'] = $item->sequence_name;
                        if($item->responder_type == 'default'){
                            $data['from_name'] = $item->from_name;
                            $data['from_email'] = $item->from_email;
                            
                            $data['add_to_existing_lead'] = $item->add_to_existing_lead;
                            
                            $data['send_to_tags_if'] = $item->send_to_tags_if;
                            $data['send_to_tags'] = @json_decode($item->send_to_tags);
                            $data['dont_send_to_tags_if'] = $item->dont_send_to_tags_if;
                            $data['dont_send_to_tags'] = @json_decode($item->dont_send_to_tags);
                            
                            $data['adding_tag'] = $item->adding_tag;
                            
                        }
                        else {
                            $data['api_id'] = $item->api_id;
                            $data['responder_sequence_id'] = $item->responder_sequence_id;
                        }
                    }
                    else {
                        $data['sequence_name'] = @$item->sequence_name;
                        
                        foreach ($item->options as $key => $val){
                            if(is_array($val))
                                continue;
                            
                            if($this->_isJson($val)){
                                $val = @json_decode($val);
                            }
                            $data[$key] = $val;
                        }
                    }
                }
            }
            $data['step'] = $step;
        }

        return $data;
    }
    
    public function validate($form, $data, $group = null) {
        $data = $this->trimArray($data);
        return parent::validate($form, $data, $group);
    }
    
    private function trimArray($data){
        foreach ($data as $key => $val){
            if(is_array($val))
                $val = $this->trimArray($val);
            else 
                $val = trim($val);
            $data[$key] = $val;
        }
        return $data;
    }
    
    function Sort_Directory_Files_By_Last_Modified($dir, $sort_type = 'descending', $date_format = "F d Y H:i:s.")
    {
        $files = scandir($dir);

        $array = array();

        foreach($files as $file)
        {
            if($file != '.' && $file != '..')
            {
                $now = time();
                $last_modified = filemtime($dir.$file);

                $time_passed_array = array();

                $diff = $now - $last_modified;

                $days = floor($diff / (3600 * 24));

                if($days)
                {
                $time_passed_array['days'] = $days;
                }

                $diff = $diff - ($days * 3600 * 24);

                $hours = floor($diff / 3600);

                if($hours)
                {
                $time_passed_array['hours'] = $hours;
                }

                $diff = $diff - (3600 * $hours);

                $minutes = floor($diff / 60);

                if($minutes)
                {
                $time_passed_array['minutes'] = $minutes;
                }

                $seconds = $diff - ($minutes * 60);

                $time_passed_array['seconds'] = $seconds;

            $array[] = array('file'         => $file,
                             'timestamp'    => $last_modified,
                             'date'         => date ($date_format, $last_modified),
                             'time_passed'  => $time_passed_array);
            }
        }

        usort($array, create_function('$a, $b', 'return strcmp($a["timestamp"], $b["timestamp"]);'));

        if($sort_type == 'descending')
        {
            krsort($array);
        }

        return array($array, $sort_type);
    }
    
    private function _isJson($string) {
        return is_array(@json_decode($string,true));
    }


}
