<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelWebinar extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	public function getTable($type = 'Webinar', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_marketingrocket.webinar', 'webinar', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}


		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
            // Check the session for previously entered form data.
            $data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.webinar.data', array());

            if (empty($data))
            {
                    $data = $this->getItem();
            }

            return $data;
	}
        
        public function save($data) {
            $db = $this->getDbo();
            $db->transactionStart();
            $data['api_id'] = JFactory::getApplication()->input->getInt('api');
            
            $table      = $this->getTable();
            $key = $table->getKeyName();
            $pk = (!empty($data[$key])) ? $data[$key] : (int) $this->getState($this->getName() . '.id');
            $isNew = true;
            if ($pk > 0)
            {
                    $isNew = false;
            }
            $ret = parent::save($data);
            if($ret == true){
                $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
             
                $apiRow = $apiModel->getItem($data['api_id']);
                if(empty($apiRow)){
                    $db->transactionRollback();
                    throw new Exception('Api Not Found');
                }
                
                try {
                    
                    require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.
                                  'com_marketingrocket'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Google'.DIRECTORY_SEPARATOR.'autoload.php';
                    $urlPatch = JUri::getInstance();
                    $client = new Google_Client();
                    $client->setClientId($apiRow->client_id);
                    $client->setClientSecret($apiRow->client_secret);
                    $client->setScopes('https://www.googleapis.com/auth/youtube');
                    $redirect = filter_var(JUri::root().'administrator/index.php?option=com_marketingrocket&task=webinar.auth',
                        FILTER_SANITIZE_URL);
                    $client->setRedirectUri($redirect);
                    
                    $array = array('access_token' => $apiRow->token, 'expires_in' => $apiRow->expire, 'created' => $apiRow->created);
                    $client->setAccessToken(json_encode($array));
                    // Define an object that will be used to make all API requests.
                    $youtube = new Google_Service_YouTube($client);


                    $broadcastSnippet = new Google_Service_YouTube_LiveBroadcastSnippet();
                    $broadcastSnippet->setTitle($data['title']);
                    $broadcastSnippet->setDescription($data['description']);
                    
                    $startDate =& JFactory::getDate( strtotime($data['start_time']), $data['timezone'] );
                    
                    $broadcastSnippet->setScheduledStartTime($startDate->toISO8601(true));
                    
                    $endDate =& JFactory::getDate( strtotime($data['end_time']), $data['timezone'] );
                    
                    $broadcastSnippet->setScheduledEndTime($endDate->toISO8601(true));
                    

                    $status = new Google_Service_YouTube_LiveBroadcastStatus();
                    $status->setPrivacyStatus($data['public_status']);

                    $broadcastInsert = new Google_Service_YouTube_LiveBroadcast();
                    $broadcastInsert->setSnippet($broadcastSnippet);
                    $broadcastInsert->setStatus($status);
                    $broadcastInsert->setKind('youtube#liveBroadcast');
                  
                    if($isNew){
                        $broadcastsResponse = $youtube->liveBroadcasts->insert('snippet,status',
                                $broadcastInsert, array());
                        
                        $streamSnippet = new Google_Service_YouTube_LiveStreamSnippet();
                        $streamSnippet->setTitle($data['title'].' Stream');

                        $cdn = new Google_Service_YouTube_CdnSettings();
                        $cdn->setFormat("1080p");
                        $cdn->setIngestionType('rtmp');

                        $streamInsert = new Google_Service_YouTube_LiveStream();
                        $streamInsert->setSnippet($streamSnippet);
                        $streamInsert->setCdn($cdn);
                        $streamInsert->setKind('youtube#liveStream');

                        $streamsResponse = $youtube->liveStreams->insert('snippet,cdn',
                        $streamInsert, array());
                         // Bind the broadcast to the live stream.
                        $bindBroadcastResponse = $youtube->liveBroadcasts->bind(
                            $broadcastsResponse['id'],'id,contentDetails',
                            array(
                                'streamId' => $streamsResponse['id'],
                            ));
                        $data['video_id'] = $streamsResponse['id'];
                        $data['id'] = $this->getState($this->getName() . '.id');
                        $data['snipest_id'] = $broadcastsResponse['id'];
                        $table->load($pk);
                        $data['created'] = $table->created;
                        $data['created_by'] = $table->created_by;
                        parent::save($data);
                    }
                    else {
                         $table->load($pk);
                         $broadcastInsert->setId($table->snipest_id);
                         $broadcastsResponse = $youtube->liveBroadcasts->update('snippet,status',
                                $broadcastInsert, array());
                    }
                   
                    
                }
                catch (Exception $e){
                        $db->transactionRollback();
                        $errors = $e->getErrors();
                        foreach ($errors as $error)
                            $this->setError($error['message']);
                        return false;
                    }




            
            }
            $db->transactionCommit();
            return $ret;
        }
        
}
