<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelVisualiser extends JModelAdmin
{
	private $_item;
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	
	public function getTable($type = 'Landing', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

        private function _cols(){
            $db = $this->getDbo();
            return array(
                            $db->qn('id'),
                            $db->qn('title'),
                            $db->qn('alias'),
                            $db->qn('to_landing_page'),
                            $db->qn('responder_type'),
                            $db->qn('responder_sequence_id'),
                            $db->qn('type', 'page_type')
                        );
        }
	
	public function getForm($data = array(), $loadData = true){
		
		$form = $this->loadForm('com_marketingrocket.visualiser', 'visualiser', array('control' => 'jform', 'load_data' => $loadData));
		
		if (empty($form))
		{
				
			return false;
		}
		return $form;
	
	}
	
	protected function loadFormData()
	{
		
		$data = new stdClass();
		$data->id = (int) $this->getState($this->getName(). '.id');
		if(empty($data->id))
			$data->id =  @$this->_item->id;
		return $data;
		
	}
	
	public function getItem($pk = null){
		$db= $this->getDbo();
		$pk = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
		if(empty($pk)){
			$query = $db->getQuery(true);
			$query->select('*')->from($db->qn('#__mrocket_campaign'))->order('id ASC');
			$db->setQuery($query);
			$this->_item = $db->loadObject();
			$pk = $this->_item->id;
		}
		
		$query = $db->getQuery(true);
		$query->select('a.*')
		->from($db->qn('#__mrocket_landings').' AS a')
		->where('a.campaign_id = '.$db->q($pk))
		->where('a.published = 1')
		->order('a.to_landing_page DESC')
		;
		$db->setQuery($query);
		return $db->loadObjectList();
		
	}
        
        public function getParents(){
            $db = JFactory::getDbo();
            $campaignId = JFactory::getApplication()->input->getInt('id', 0);
            if(empty($campaignId)){
              
                $query = $db->getQuery(true);
                $query->select('*')->from($db->qn('#__mrocket_campaign'))->order('id ASC');
                $db->setQuery($query);
                $this->_item = $db->loadObject();
                $campaignId = $this->_item->id;
                  JFactory::getApplication()->input->set('id', $campaignId);
            }
            if(empty($campaignId))
                return array();
            
            $q = $db->getQuery(true);
            $q->select($db->qn('to_landing_page'))
                    ->from($db->qn('#__mrocket_landings'))
                    ->where($db->qn('to_landing_page').' != 0')
                    ->where($db->qn('published').' = 1')
                    ->where($db->qn('campaign_id').' = '.$campaignId)
            ;
            $db->setQuery($q);
            $res = $db->loadColumn();
            
            if(empty($res)){
                return array();
            }
            $q = $db->getQuery(true);
            $q->select(
                    $this->_cols()
                    )
                    ->from($db->qn('#__mrocket_landings'))
                    ->where($db->qn('id').' NOT IN ('.implode(',', $res).')')
                    ->where($db->qn('published').' = 1')
                    ->where($db->qn('campaign_id').' = '.$campaignId)
                    ;
            $db->setQuery($q);
            return $db->loadObjectList();
        }
        
        public function getLandings($ids){
            
            if(empty($ids)){
                return array();
            }
            
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select($this->_cols()
                    )
                     ->from($db->qn('#__mrocket_landings'))
                    ->where($db->qn('id').' IN ('.implode(',', $ids).')')
                     ->where($db->qn('published').' = 1')
            ;
            $db->setQuery($q);
            return $db->loadObjectList();
            
        }
        
        public function getResponder($id){
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            
            $q->select(array(
                            $db->qn('id'),
                            $db->qn('name')
                        )
                    )
                    ->from($db->qn('#__mrocket_reponders_sequences'))
                    ->where($db->qn('id').' = '.$db->q($id))
                    ;
            $db->setQuery($q);
            return $db->loadObject();
        }
        
        public function findTargets($sequenceId, &$parents = false){
            
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select(array($db->qn('id'), $db->qn('body')))
                    ->from($db->qn('#__mrocket_responder_templates'))
                    ->where($db->qn('sequence_id').' = '.$db->q($sequenceId))
                    ->where($db->qn('published').' = '.$db->q(1))
                    ->where($db->qn('type').' = '.$db->q('responder'))
                    
                    ;
            $db->setQuery($q);
            $res = $db->loadObjectList();
            $targets = array();
            foreach ($res as $row)
            {
                $this->_findTargets($row, $parents, $targets);
            }
            return $targets;
        }
        public function findTargetsOfResponders($alias, $nextParent){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select(array($db->qn('id'), $db->qn('body')))
                    ->from($db->qn('#__mrocket_responder_templates'))
                    ->where($db->qn('unique_name').' IN ("'.  implode('","', $alias).'")')
                    ->where($db->qn('published').' = '.$db->q(1))
                    ->where($db->qn('type').' = '.$db->q('template'))
                    
                    ;
            $db->setQuery($q);
            $res = $db->loadObjectList();
            foreach ($res as $row){
                if(strpos($row->body, '{landing-link=%wizard%}') !== false){
                    $targets[] = $nextParent;
                    return $targets;
                }
            }
            return array();
            
            
        }
        
        private function _findTargets($row, &$parents, &$targets){
            $pattern = '/({landing-link={1})(.[^}]+)(}{1})(.*[^{]{1})({\/landing\-link}{1})/';
            preg_match_all($pattern, $row->body, $matches);
            foreach ($matches[0] as  $key => $match){
                $alias = $matches[2][$key];
                $landingTable = JTable::getInstance('Landing', 'MarketingrocketTable');
                $landingTable->load(array('alias' => $alias, 'published' => 1));
                if(!empty($landingTable->id) && !in_array($landingTable->id, $targets)){
                    $targets[] = $landingTable->id;
                }
                if($parents !== false){
                    foreach ($parents as $key => $parent){
                        if($parent->id == $landingTable->id){ // this is not a parent
                            unset($parents[$key]);
                            break;
                        }
                    }
                }
            }
        }
        
        public function getLandingActions($landingId){
            $db = $this->getDbo();
            $q = $db->getQuery(true);            
            $q->select('*')->from('#__mrocket_actions')
                    ->where($db->qn('landing_id') .' = '.$db->q($landingId))
                    ->where($db->qn('action') .' = '.$db->q('open_landing'))
                ;
            
            $db->setQuery($q);
            return $db->loadObjectList();
            
        }
        
        public function getSplits($landing){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select($this->_cols())->from('#__mrocket_landings')
                    ->where($db->qn('id').' != '.$db->q($landing->id))
                    ->where($db->qn('alias').' = '.$db->q($landing->alias))
                    ->where($db->qn('published').' = 1');
            
            $db->setQuery($q);
            return $db->loadObjectList();
            
        }
        
        public function getNotConnected($landingList){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $campaignId = JFactory::getApplication()->input->getInt('id', 0);
            
            
            $q->select($this->_cols())->from('#__mrocket_landings')
                    ->where($db->qn('published').' = 1')
                    ->where($db->qn('campaign_id') .' = '.$db->q($campaignId));
            if(!empty($landingList))
                    $q->where($db->qn('id') .' NOT IN ('.implode(',', $landingList).')');
            $db->setQuery($q);
            
            return $db->loadObjectList();
            
        }
	




}
