<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelStatus extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
            
            if($record->final == 1){
                 $this->setError(JText::_('COM_MARKETINGROCKET_FINAL_CANT_BE_DELETED'));
                return false;
            }
            if($record->default == 1){
                 $this->setError(JText::_('COM_MARKETINGROCKET_DEFAULT_CANT_BE_DELETED'));
                return false;
            }
            if (!empty($record->id))
            {

                    return parent::canDelete($record);

            }
	}

	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Status', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.status', 'status', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}




		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.status.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}

	public function save($data){
		if(parent::save($data)){
			if($data['default'] == '1'){
		
				$db = $this->getDbo ();
				$query = $db->getQuery(true);
				$query->update ( $db->quoteName ( '#__mrocket_statuses' ) );
				$query->set ( $db->quoteName('default') .' = 0');
				$query->where ( array (
						'id != ' .$this->getState('status.id'),
						$db->quoteName('default').' = 1'
				) );
				$db->setQuery ( $query );
				$db->execute (); 		
			}
			return true;
		}
		else 
			return false;
		
	}
	public function makeDefault($id){
		$id = $id[0];
		$db = $this->getDbo ();
		$query = $db->getQuery(true);
		$query->update ( $db->quoteName ( '#__mrocket_statuses' ) );
		$query->set ( $db->quoteName('default') .' = 0');
		$db->setQuery ( $query );
		$db->execute ();
	
		$query = $db->getQuery(true);
		$query->update ( $db->quoteName ( '#__mrocket_statuses' ) );
		$query->set ( $db->quoteName('default') .' = 1');
		$query->where ( array (
				'id = ' .$db->q($id)
		) );
		$db->setQuery ( $query );
		$db->execute ();
	}
	public function makeFinal($id, $value){
		$id = $id[0];
		$db = $this->getDbo ();
		$query = $db->getQuery(true);
		$query->update ( $db->quoteName ( '#__mrocket_statuses' ) );
		$query->set ( $db->quoteName('final') .' = '.$db->q($value));
		$query->where ( array (
				'id = ' .$db->q($id)
		) );
		$db->setQuery ( $query );
		$db->execute ();
	}
	


}
