<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelSequence extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		
		if (!empty($record->id))
		{
			return parent::canDelete($record);

		}
	}

	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Sequence', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.sequence', 'sequence', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}



		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.sequence.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
                        if(is_object($data)){
                            $data->send_to_tags = @json_decode($data->send_to_tags);
                            $data->dont_send_to_tags = @json_decode($data->dont_send_to_tags);
                        }
                        else {
                            $data['send_to_tags'] = @json_decode($data['send_to_tags']);
                            $data['dont_send_to_tags'] = @json_decode($data['dont_send_to_tags']);
                        }
		}

		return $data;
	}
        
        
        public function save($data){

            $data['send_to_tags'] = (!empty($data['send_to_tags'])) ? json_encode($data['send_to_tags']) : '';
            
            $data['dont_send_to_tags'] = (!empty($data['dont_send_to_tags'])) ? json_encode($data['dont_send_to_tags']) : '';
             
            $ret = parent::save($data);
            if($ret && JFactory::getApplication()->input->get('task', '') == 'save2copy'){
                $id = $this->getState($this->getName() . '.id');
                $oldId = JFactory::getApplication()->input->getInt('id');

                $db = $this->getDbo();
                $q = $db->getQuery(true);

                $session = JFactory::getSession();

                $ids = $session->get('responder_copy', array(), 'MR');

                $q->select('*')->from($db->qn('#__mrocket_responder_templates'))
                        ->where($db->qn('id').' IN ('.implode(',', $ids).')')
                        ;
                $db->setQuery($q);
                $responders = $db->loadAssocList();
                
                foreach ($responders as $responder){
                    $table = JTable::getInstance('Responder', 'MarketingrocketTable');
                    $responderId = $responder['id'];
//                    $responder['id'] = null;
                    $responder['sequence_id'] = $id;
//                    $responder['published'] = 1;
                    $table->save($responder);
                    

                    
                }
                $session->clear('responder_copy', 'MR');
                
            }
            return $ret;
            
	}
        
        public function getResponders(){
            $pk =  (int) $this->getState($this->getName() . '.id');
            if(empty($pk))
                return array();
            
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select('*')->from($db->qn('#__mrocket_responder_templates'))
                    ->where($db->qn('sequence_id').' = '.$pk)
                    ->where($db->qn('type').' = '.$db->q('responder'))
                    ->order('split_by DESC')
                ;
            $db->setQuery($q);
            
            return $db->loadObjectList();
            
        }
        
        public function delete(&$pks)
	{
            $ret = parent::delete($pks);
            if($ret){
                $db = $this->getDbo();
                foreach ($pks as $pk){
                    $q = $db->getQuery(true);
                    $q->select('id')->from($db->qn('#__mrocket_responder_templates'))
                        ->where($db->qn('sequence_id').' = '.$db->q($pk))
                        ->where($db->qn('type').' = '.$db->q('responder'))
                        ;
                    $db->setQuery($q);
                    $responders = $db->loadColumn();
                    if(!empty($responders)){
                        $responderModel = JModelLegacy::getInstance('Responder','MarketingrocketModel');
                        $responderModel->delete($responders);
                    }
                    
                }
            }
            return $ret;
        }




}
