<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

class JFormRuleBetween extends JFormRule {
    public function test(SimpleXMLElement $element, $value, $group = null, JRegistry $input = null, JForm $form = null)
    {
        if(!defined('DS'))
            define('DS', DIRECTORY_SEPARATOR);
        
        set_include_path(implode(PATH_SEPARATOR, array(
            realpath(JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'libs'),
            get_include_path(),
        )));
        
        require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'libs'.DS.'Zend'.DS.'Validate'.DS.'Between.php';
        
        $min = $element['min'] ? (string) $element['min'] : 0;
        $max = $element['max'] ? (string) $element['max'] : 10;
        $inclusive = $element['inclusive'] ? (string) $element['inclusive'] : true;
        
        $validate = new Zend_Validate_Between(array('min' => $min, 'max' => $max, 'inclusive' => $inclusive));
        if($validate->isValid($value)){
            return true;
        }
        else {
           return false;
        }
    }
    
}