<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
defined('_JEXEC') or die;

class MarketingrocketModelResponders extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id',
				'name',
                                'created',
                                'published',
                                'c.name',
                                'sent',
                                'opened',
                                'clicked'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);



		$published = $this->getUserStateFromRequest($this->context.'.filter.state', 'filter_state', '', 'string');
		$this->setState('filter.state', $published);




		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.id', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
                try {
                    $db->setQuery('SET OPTION SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                try {
                
                    $db->setQuery('SET SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                
                
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.id, a.name,c.name AS campaign_name,a.created, a.published, a.publish_up, a.publish_down'
			)
		);
		$query->from($db->quoteName('#__mrocket_responder_templates').' AS a');

		// Join over the users for the checked out user.
		$query->select('uc.name AS editor');
		$query->join('LEFT', $db->quoteName('#__users').' AS uc ON uc.id=a.created_by');
		
		// get stats
		$query->select('(SELECT COUNT(id) FROM '.$db->qn('#__mrocket_leads_cron').' as '.$db->qn('lc').' WHERE '.$db->qn('a.id').' = '.$db->qn('lc.responder_id').' AND '.$db->qn('lc.is_show').' = 1 AND '.$db->qn('lc.is_done').' = 1) AS opened');
		$query->select('(SELECT COUNT(id) FROM '.$db->qn('#__mrocket_leads_cron').' as '.$db->qn('lc3').' WHERE '.$db->qn('a.id').' = '.$db->qn('lc3.responder_id').' AND '.$db->qn('lc3.is_clicked').' = 1 AND '.$db->qn('lc3.is_done').' = 1) AS clicked');
		$query->select('COUNT(lc3.id) AS sent')
		->join('LEFT', $db->quoteName('#__mrocket_leads_cron').' AS lc3 ON a.id = lc3.responder_id AND lc3.is_done = 1')
		;
		
		
		// Join over the campaign.
		
		$query->join('INNER', $db->quoteName('#__mrocket_reponders_sequences').' AS c ON c.id = a.sequence_id');
		$query->where('a.id > 0')
		->where('a.type = '.$db->q('responder'))
		;
		
		$query->group('a.id');
		// Implement View Level Access
// 		if (!$user->authorise('core.admin'))
// 		{
// 			$groups	= implode(',', $user->getAuthorisedViewLevels());
// 			$query->where('a.access IN ('.$groups.')');
// 		}

		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.')');
			}
		}
                
                $status = $this->getState('filter.published');
                
                if (is_numeric($status))
		{
                    $query->where('a.published = '.$status);
		}
                
                $sequence = $this->getState('filter.sequence_id');
                
                if (is_numeric($sequence))
		{
                    $query->where('a.sequence_id = '.$sequence);
		}



		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
		

		return $query;
	}
}
