<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelResponderAttachment extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';
        
        public function getAttachments(){
            $input = JFactory::getApplication()->input;
            if($input->getInt('wizard', 0) > 0){
                $session = JFactory::getSession();
                $template = $session->get( 'wizard', null, 'com_marketingrocket');
                if(!empty($template->items[$input->getInt('wizard', 0)-2]->options->days->day[$input->getInt('day', 0)])){
                    $item = $template->items[$input->getInt('wizard', 0)-2]->options->days->day[$input->getInt('day', 0)];
                    if(!empty($item->attachments)){
                        return $item->attachments;
                    }
                }
            }
            
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if(!empty($id)){
                $db = $this->getDbo();
                $query = $db->getQuery(true);
                
                $query->select('*')->from('#__mrocket_responder_attachments')
                        ->where('responder_id = '.$id);
                
                $db->setQuery($query);
                return $db->loadObjectList();
            }
            return array();
        }
        
        public function getSizeOfAttachments($id){
            $db = $this->getDbo();
            $query = $db->getQuery(true);

            $query->select('SUM(size)')->from('#__mrocket_responder_attachments')
                    ->where('responder_id = '.$id);

            $db->setQuery($query);
            return $db->loadResult();
        }

        public function getForm($data = array(), $loadData = true) {

        }

        public function getTable($type = 'Responderattachment', $prefix = 'MarketingrocketTable', $config = array())
        {
                return JTable::getInstance($type, $prefix, $config);
        }

}
