<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelResponder extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{

		if (!empty($record->id))
		{
			return parent::canDelete($record);

		}
	}

	public function getItem($pk = null)
    {
        if(JFactory::getApplication()->input->getString('type') == 'opt_in' && JFactory::getApplication()->input->getInt('id', 0) == 0){

            $table = $this->getTable();
            $table->load(array('type' => 'opt_in'));
            JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=responder&layout=edit&id='.$table->id.'&type=opt_in', false));

        }

        return parent::getItem($pk);
    }

    /**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Responder', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.responder', 'responder', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}
                
                $input = JFactory::getApplication()->input;
                if($input->getInt('wizard', 0) > 0){
                    $form->removeField('sequence_id');
//                    $form->removeField('name');
                    $form->removeField('from_name');
                    $form->removeField('from_email');
//                    $form->removeField('subject');
                }
                
                if($input->getString('tmpl') == 'component'){
                    $form->setFieldAttribute('sequence_id', 'type', 'hidden');
                    
                    $form->setFieldAttribute('sequence_id', 'default', $input->getInt('sequence'));
                    
                    $form->removeField('from_name');
                    $form->removeField('from_email');
                }
                else {
                    $form->removeField('split_id');
                    if($input->getInt('id') > 0)
                        $form->setFieldAttribute('sequence_id', 'type', 'hidden');
                }
		$requestType = JFactory::getApplication()->input->getString('type', 'responder');
                
                $itemType = $this->getItem();
                
                
                if(JComponentHelper::getParams('com_marketingrocket')->get('email_editor','simple') == 'full'){
                    $form->setFieldAttribute('body', 'type', 'hidden');
                }
                
                
		
		if($requestType != 'responder' || (!empty($itemType->type) && $itemType->type != 'responder')) {
			$form->removeField('send_after_day');
            $form->removeField('send_after_hour');
            $form->removeField('send_after_minute');

            $form->removeField('send_type');
            $form->removeField('send_on_date');
            $form->removeField('send_before_webinar');
            $form->removeField('send_before_hour');
            $form->removeField('send_before_day');
                        
//			$form->removeField('published');
			$form->removeField('publish_up');
			$form->removeField('publish_down');
			$form->removeField('sequence_id');
// 			$form->setFieldAttribute('campaign_id', 'disabled', 'true');
                        
            $form->setFieldAttribute('from_name', 'required', 'true');
            $form->setFieldAttribute('from_email', 'required', 'true');
		}
               

		// Modify the form based on access controls.
		if (!$this->canEditState((object) $data))
		{
			// Disable fields for display.
			$form->setFieldAttribute('ordering', 'disabled', 'true');
			$form->setFieldAttribute('state', 'disabled', 'true');
			$form->setFieldAttribute('publish_up', 'disabled', 'true');
			$form->setFieldAttribute('publish_down', 'disabled', 'true');

			// Disable fields while saving.
			// The controller has already verified this is a record you can edit.
			$form->setFieldAttribute('ordering', 'filter', 'unset');
			$form->setFieldAttribute('state', 'filter', 'unset');
			$form->setFieldAttribute('publish_up', 'filter', 'unset');
			$form->setFieldAttribute('publish_down', 'filter', 'unset');
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.responder.data', array());
		
		if (empty($data))
		{
                    
                    $input = JFactory::getApplication()->input;
                    if($input->getInt('wizard', 0) > 0){
                        $session = JFactory::getSession();
                        $template = $session->get( 'wizard', null, 'com_marketingrocket');
                        if(!empty($template->items[$input->getInt('wizard', 0)-2]->options->days->day[$input->getInt('day', 0)])){
                            $item = $template->items[$input->getInt('wizard', 0)-2]->options->days->day[$input->getInt('day', 0)];
                            if(!empty($item->formData) && $item->selected_template == $input->getInt('template')){
                                $data = $item->formData;
                            }
                            else {
                                $data['send_after_day'] = $item->count;
                                $data['name'] = (!empty($item->title)) ? $item->title : 'Day '.$item->count;
                                $data['subject'] = @$item->subject;

                                $db = $this->getDbo();
                                $query = $db->getQuery(true);
                                
                                $query
                                    ->select('body')
                                    ->from($db->qn('#__mrocket_responder_templates'))
                                    ->where('type = "template"')
                                    ->where('unique_name = '.$db->q($input->getString('template')))
                                ;

                                $db->setQuery($query);
                                $data['body'] =  $db->loadResult();
                            }
                            
                            
                            
                        }
                       
                    }
                    else {
                        $data = $this->getItem();
                        
                        switch ($data->send_type){
                            case 'before' :
                                $row = explode(':', $data->send_option);
                                $data->send_before_day = $row[0];
                                $data->send_before_hour = $row[1];
                                break;
                            case 'after':
                                $data->send_after_day = $data->send_option/1440;
                                $data->send_after_day = (int)$data->send_after_day ;
                                
                                $data->send_after_hour = ($data->send_option%1440)/60;
                                $data->send_after_hour = (int) $data->send_after_hour;
                                
                                $data->send_after_minute = ($data->send_option%60);
                                $data->send_after_minute = (int) $data->send_after_minute;
                                
                                break;
                            case 'on_date':
                                $data->send_on_date = $data->send_option; 
                                break;
                            case 'rough':
                                $row = explode('|',  $data->send_option);
                                $data->rough_send_after_day = $row[0];
                                $row = explode(':', $row[1]);
                                $data->rough_send_on_hour = $row[0];
                                $data->rough_send_on_minute = $row[1];
                                break;
                        }
                        if(!empty($data->split_by)){
                            $table = $this->getTable();
                            $table->load($data->id);
                            
                            $target = $table->getSplit();
                            $data->split_id = $target->id;
                            
                        }
                        if($input->getInt('campaign_id', 0) > 0){
                            $campaignTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                            $campaignTable->load($input->getInt('campaign_id'));
                            
                            if(!empty($campaignTable->responder_id)){
                                $responderTable = JTable::getInstance('Responder', 'MarketingrocketTable');
                                $responderTable->load($campaignTable->responder_id);
                                
                                $data->body = $responderTable->body;
                            }
                        }
                        if(empty($data->name)){
                            $data->published = 1; // this will show it published for added resonder in sequence before user save it
                        }
                    }
		}
		return $data;
	}
	public function save($data)
	{
		$db = $this->getDbo();
		
		if($data['type'] == "marketing")
			$data['published'] = 1;

        $data['publish_down'] = 0;

        switch ($data['send_type']){
            case 'before':
                $data['send_option'] = $data['send_before_day'].':'.$data['send_before_hour'];

                break;
            case 'after':
                $data['send_option'] = ($data['send_after_day']*1440)+($data['send_after_hour']*60)+($data['send_after_minute']);
                break;
            case 'on_date':
                $data['send_option'] = $data['send_on_date'];

                if($data['unpublish_ondate'] == '1'){
                    $date = JFactory::getDate($data['send_option']);
                    $date->modify('+5 Minute');
                    $data['publish_down'] = $date->toSql();
                }
                break;
            case 'rough':
                $data['send_option'] = $data['rough_send_after_day'].'|'.$data['rough_send_on_hour'].':'.$data['rough_send_on_minute'];
                break;

        }
        if(!isset($data['published']))
            $data['published'] = 1;

        if(empty($data['from_name']) && !empty($data['sequence_id'])) // save from iframe so we will get send information from sequence
        {
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_reponders_sequences'))->where($db->qn('id').' = '.$db->q($data['sequence_id']));
            $db->setQuery($q);
            $sequence = $db->loadObject();
            $data['from_name'] = $sequence->from_name;
            $data['from_email'] = $sequence->from_email;


        }
                
        if(!empty($data['split_id']))
        {
            $table = $this->getTable();
            $table->load($data['split_id']);
            $table->split_by = substr(time(), 5).rand(1000, 9999);
            $table->must_show_next = 0;
            if($table->check())
                $table->store();
            else {
                $this->setError($table->getError());
                return false;
            }

            $data['split_by'] = $table->split_by;
            $data['must_show_next'] = 1;

        }
        else {
            $data['split_by'] = 0;
        }
		$ret = parent::save($data);
        $responderId = $this->getState('responder.id');
                
        $attachmentsModel = JModelLegacy::getInstance('ResponderAttachment', 'MarketingrocketModel', array('ignore_request' => true));
                
		if($ret){
            if(!empty($_FILES['attachment']) && $data['type'] != 'template'){

                $totalSize = $attachmentsModel->getSizeOfAttachments($responderId);
                $maxAttachment = 2000000;
                foreach ($_FILES['attachment']['name'] as $key => $file){
                    if(empty($file))
                        continue;
                    $path = pathinfo($file);
                    if(!in_array($path['extension'], array('docx', 'doc', 'xls', 'xlsx', 'ppt', 'pptx', 'jpg', 'png', 'gif' , 'pdf'))){
                        $this->setError(sprintf(JText::_('COM_MARKETINGROCKET_EXTENSION_NOT_ALLOWED'), $path['extension']));
                        $ret = false;
                        continue;
                    }
                    $totalSize += $_FILES['attachment']['size'][$key];
                    if($totalSize > $maxAttachment){
                        $this->setError(JText::_('COM_MARKETINGROCKET_MAXIMUM_SIZE_ERROR'));
                        $ret = false;
                        break;
                    }
                    $tempName = md5(uniqid().time());
                    $uploaded = move_uploaded_file(
                            $_FILES['attachment']['tmp_name'][$key],
                            JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                            DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$tempName);
                    if($uploaded){
                        $query = $db->getQuery(true);
                        $query->insert('#__mrocket_responder_attachments')
                                ->set('responder_id = '.$responderId)
                                ->set('file_name = '.$db->q($tempName))
                                ->set('orginal_file_name = '.$db->q($file))
                                ->set('size = '.$_FILES['attachment']['size'][$key])
                            ;
                        $db->setQuery($query);
                        $db->execute();
                    }
                }
            }
            if(JFactory::getApplication()->input->getInt('campaign_id', 0) > 0 ){
                try {

                    $db->transactionStart();
                    $query = $db->getQuery(true);
                    $query->select('*')->from($db->qn('#__mrocket_lead_campaigns'))->where('campaign_id = '.JFactory::getApplication()->input->getInt('campaign_id'));
                    $db->setQuery($query);
                    $list = $db->loadObjectList();
                    foreach ($list as $row){
                                        $leadCron  = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                                        $leadCron->lead_id = $row->lead_id;
                                        $leadCron->cron_date = JFactory::getDate()->toSql();
                                        $leadCron->cron_job = 'default';
                                        $leadCron->responder_id = $responderId;
                                        if($leadCron->check())
                                            $leadCron->store();
                    }
                    $db->transactionCommit();
                }
                catch (Exception $e){
                    $db->transactionRollback();
                    $this->setError($e);
                    return false;
                }
            }
            else if(JFactory::getApplication()->input->get('type', '') == 'leademail'){
                $session = JFactory::getSession();
                $ids =$session->get( 'send_email_list', array(), 'com_marketingrocket');
                if(!empty($ids)){
                    try {
                        $db->transactionStart();
                        $time = time()-1000;
                        foreach ($ids as $id){
                                $query = $db->getQuery(true);
                                $query->insert ( $db->quoteName ( '#__mrocket_leads_cron' ) );
                                $query->set ( $db->qn('lead_id') .' = '.$db->q($id));
                                $query->set ( $db->qn('cron_date') .' = '.$db->q(JFactory::getDate($time)));
                                $query->set ( $db->qn('cron_job') .' = '.$db->q('default'));
                                $query->set ( $db->qn('responder_id') .' = '.$db->q($responderId));
                                $db->setQuery ( $query );
                                $db->execute ();
                        }
                        $db->transactionCommit();
                    }
                    catch (Exception $e){
				        $db->transactionRollback();
				        $this->setError($e);
				        return false;
                    }
                                
                    $session->clear('send_email_list', 'com_marketingrocket');
                    require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
                    $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&view=cron');
                    @file_get_contents($url);
                }
            }
                    
			
		}
		return $ret;
	}
	
	public function getTemplateList(){
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query
		->select('*')
		->from($db->qn('#__mrocket_responder_templates'))
		->where('type = "template"');
		
		$db->setQuery($query);
		return $db->loadObjectList();
	}
        
        public function resetstat($pks)
	{
            $pks = (array) $pks;
            $db = $this->getDbo();
            try {
                $db->transactionStart();
                
                // Access checks.
                foreach ($pks as $i => $pk)
                {
                    $q = $db->getQuery(true);
                    $q->update($db->qn('#__mrocket_leads_cron'))
                            ->set($db->qn('is_done') .' = -1')
                            ->where($db->qn('is_done') .' = 1')
                            ->where($db->qn('responder_id') .' = '.$db->q($pk))
                            ;
                    $db->setQuery($q);
                    $db->execute();
                    
                }
                
                $db->transactionCommit();
            }
            catch (Exception $e){
                $db->transactionRollback();
                throw new Exception($e);
            }
        }
        public function validate($form, $data, $group = null)
	{
            if(isset($data['from_name']) && (empty($data['from_name']) || empty($data['from_email']))){
                $table = $this->getTable('Sequence');
                $table->load($data['sequence_id']);
                
                if(empty($table->from_name) || empty($table->from_email)){
                    $this->setError(JText::_('COM_MARKETINGROCKET_SEQUENCE_INFORMATION_IS_EMPTY'));
                    return false;
                }
                
            }
            
            return parent::validate($form, $data, $group);
        }
        
        public function delete(&$pks)
	{
            $ret = parent::delete($pks);
            if($ret){
                $db = $this->getDbo();
                foreach ($pks as $pk){
                    $q = $db->getQuery(true);
                    $q->select('*')->from($db->qn('#__mrocket_responder_attachments'))
                            ->where($db->qn('responder_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $attachments = $db->loadObjectList();
                    foreach ($attachments as $attachment){
                         $attachmentTable = JTable::getInstance('Responderattachment', 'MarketingrocketTable');
                         $attachmentTable->delete($attachment->id);
                         @unlink(JPATH_SITE.DS.'media'.DS.'com_marketingrocket'.
                                        DS.'attachments'.DS.$attachment->file_name);
                    }
                }
            }
            return $ret;
        }
        
        public function dynamicList(&$fieldOptions, $element, $form){
            $db = $this->getDbo();
            
            
            $input = JFactory::getApplication()->input;
            if($input->getInt('wizard', 0) > 0){
                $wizardId = $input->getInt('wizard', 0);
                $inputDay = $input->getInt('day', 0);
                $session = JFactory::getSession();
                $template = $session->get( 'wizard', null, 'com_marketingrocket');

                $days = $template->items[$wizardId-2]->options->days->day;
                foreach ($days as $key => $day){
                    if($key == $inputDay)
                        continue;
                    $key = $key+1;
                    $fieldOptions[] = array(
                        'value' => $key,
                        'text' => @$day->title
                    );
                }
                return;
            }
            $q = $db->getQuery(true);
            
            $id = JFactory::getApplication()->input->getInt('id', 0);
            
            $this->populateState();
            $item = $this->getItem();
            $q->select('id,name')
                    ->from('#__mrocket_responder_templates')
                    ->where($db->qn('sequence_id').' = '.$db->q($item->sequence_id))
                    ->where($db->qn('type').' = '.$db->q('responder'))
                ;
            
            if(!empty($id))
                $q->where ($db->qn('id').' != '.$id);
            
            $db->setQuery($q);
            $res = $db->loadObjectList();
            foreach ($res as $row){
                $fieldOptions[] = array(
                    'value' => $row->id,
                    'text' => $row->name
                    );
            }
        }

}
