<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelReports extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 
				'title',
				'created',
				'campaign_name',
				'allvisits',
				'allsubmission',
				'converted',
				'published'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');
		
		// Load the filter state.
		$begin = $this->getUserStateFromRequest($this->context.'.filter.begin', 'filter_begin');
		$this->setState('filter.begin', $begin);

		$end = $this->getUserStateFromRequest($this->context.'.filter.end', 'filter_end');
		$this->setState('filter.end', $end);
                
                $end = $this->getUserStateFromRequest($this->context.'.filter.campaign', 'filter_campaign');
		$this->setState('filter.campaign', $end);
                
                $groupBy = $this->getUserStateFromRequest($this->context.'.filter.group', 'filter_group');
		$this->setState('filter.group', $groupBy);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.id', 'asc');
                $limit = $app->getUserStateFromRequest('global.list.limit', 'limit', '10', 'uint');
                $this->setState('list.limit', $limit);                
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		
            
            $this->populateState();
            
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.*,
				c.name as campaign_name,
	SUM(b.visit) AS allvisits,
	SUM(b.submission) AS allsubmission,(
		SELECT
			COUNT(l.id)
		FROM
			#__mrocket_leads AS l
		INNER JOIN #__mrocket_lead_statuses AS ls ON l.id = ls.lead_id
		INNER JOIN #__mrocket_statuses AS s ON ls.status_id = s.id
		AND s.final = 1
		WHERE l.landing_id = a.id
		GROUP BY
			l.landing_id
	)
	AS converted'
			)
		);
		$query->from($db->quoteName('#__mrocket_landings').' AS a');
		$query->join('LEFT', $db->qn('#__mrocket_campaign') .' AS c ON a.campaign_id = c.id');
		$query->join('LEFT', $db->qn('#__mrocket_daily_stat') .' AS b ON a.id = b.landing_id');
		//$query->where($db->qn('a.published') .' = 1');
		$query->group('b.landing_id');
		// Filter by search in title
		$begin = $this->getState('filter.begin');
		$end = $this->getState('filter.end');
		if (!empty($begin) || !empty($end))
		{
			if(!empty($begin))
				$query->where('b.date >= '.$db->q($begin));
			if(!empty($end))
				$query->where('b.date <= '.$db->q($end));
		}
		else {
                    $startDate = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
                    $startDate->modify('-30 day');
                    
                    $query->where('b.date >= '.$db->q($startDate->format('Y-m-d')));
		}
                
                $campaingId = $this->getState('filter.campaign');
                if(!empty($campaingId)){
                    $query->where('a.campaign_id = '.$db->q($campaingId));
                }

		
		$query->order('converted'.' '.'DESC,allsubmission DESC,allvisits DESC');

	
		return $query;
	}
	
	public function getDailyStat(&$startDate = null, $endDate = null){
		if(empty($startDate)){
                    $startDate = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
                    $startDate->modify('-30 day');
                    $startDate = $startDate->format('Y-m-d');
		}
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query
		->select('SUM(a.visit) as visits, SUM(a.submission) as submissions, a.date')
		->from($db->qn('#__mrocket_daily_stat').' AS a')
		->where('a.date >= '.$db->q($startDate));
		if(!empty($endDate))
			$query->where('a.date <= '.$db->q($endDate));
                
                $campaingId = $this->getState('filter.campaign');
                $query->join('INNER', $db->qn('#__mrocket_landings').' as b ON a.landing_id = b.id');
                if(!empty($campaingId)){
                            $query->where('b.campaign_id = '.$db->q($campaingId));
                }
                
		$query->group('date');
		$db->setQuery($query);
		return $db->loadObjectList('date');
	}
        public function getPrevMonthStat($start = null, $end = null){
                if($start == null){
                    $start = date('Y-m-d', strtotime("first day of last month"));
                }
                if($end == null){
                    $end = date('Y-m-d', strtotime("last day of last month"));
                }
                $db = $this->getDbo();
		$query	= $db->getQuery(true);
		$query
		->select('SUM(visit) as visits, SUM(submission) as submissions, date')
		->from($db->qn('#__mrocket_daily_stat'))
		->where('date >= '.$db->q($start));
		$query->where('date <= '.$db->q($end));
		$query->group('SUBSTR(date,0,7)');
		$db->setQuery($query);
                
                return $db->loadObject();
        }
        
	public function getConvertedCount($startDate = null, $endDate = null){
		if(empty($startDate)){
                    $startDate = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
                    $startDate->modify('-30 day');
                    $startDate = $startDate->format('Y-m-d');
		}
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query
		->select('COUNT(a.id) as C')
		->from($db->qn('#__mrocket_leads') .' AS a')
                ->join('INNER', $db->qn('#__mrocket_lead_statuses', 'ls').' ON '.$db->qn('a.id').' = '.$db->qn('ls.lead_id'))
		->join('INNER', $db->qn('#__mrocket_statuses', 'b').' ON '.$db->qn('ls.status_id').' = '.$db->qn('b.id'))
                ->join('INNER', $db->qn('#__mrocket_logs', 'lo').' ON '.$db->qn('lo.lead_id').' = '.$db->qn('a.id').' AND '.$db->qn('lo.type').' = '.$db->q('convert').' AND '.$db->qn('lo.target_id').' = '.$db->qn('b.id'))
		->where('lo.time >= '.$db->q($startDate))
		->where('b.final = 1')
		;
		if(!empty($endDate))
			$query->where('lo.time <= '.$db->q($endDate));
		
		$db->setQuery($query);
		$res = $db->loadObject();
		return $res->C;
	}
}
