<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelQueueds extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 
                                'cron_date',
                                'responder_name',
                                'sequence_name',
                                'email',
                                'is_done',
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);



		


		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('id', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(array(
                   'a.*',
                   'CONCAT('.$db->qn('b.first_name').', " ",'.$db->qn('b.last_name').') AS full_name',
                    $db->qn('b.email'),
                    $db->qn('c.name', 'responder_name'),
                    $db->qn('d.name', 'sequence_name'),
                    $db->qn('c.sequence_id')
                ));
		$query->from($db->qn('#__mrocket_leads_cron', 'a'))
                        ->innerJoin($db->qn('#__mrocket_leads', 'b').' ON '.$db->qn('a.lead_id').' = '.$db->qn('b.id'))
                        ->innerJoin($db->qn('#__mrocket_responder_templates', 'c').' ON '.$db->qn('a.responder_id').' = '.$db->qn('c.id'))
                        ->leftJoin($db->qn('#__mrocket_reponders_sequences', 'd').' ON '.$db->qn('c.sequence_id').' = '.$db->qn('d.id'))
//                        ->where($db->qn('c.published').' = 1')
                        ->where($db->qn('b.is_temp').' = 0')
                        ;

		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('( '.$db->qn('c.name').' LIKE '.$search.' OR '.$db->qn('b.last_name').' LIKE '.$search.' OR '.$db->qn('b.email').' LIKE '.$search.')')
                                ;
			}
		}
                
                $sequence = $this->getState('filter.sequence_id');
                if (!empty($sequence))
		{
                    $query->where($db->qn('c.sequence_id').' = '.$db->q($sequence));
                }
                
                // Add filter for registration ranges select list
		$range = $this->getState('filter.range');
                
                // Apply the range filter.
		if ($range)
		{
			// Get UTC for now.
			$dNow = new JDate;
			$dStart = clone $dNow;

			switch ($range)
			{
				case 'past_week':
					$dStart->modify('-7 day');
					break;

				case 'past_1month':
					$dStart->modify('-1 month');
					break;

				case 'past_3month':
					$dStart->modify('-3 month');
					break;

				case 'past_6month':
					$dStart->modify('-6 month');
					break;

				case 'post_year':
				case 'past_year':
					$dStart->modify('-1 year');
					break;

				case 'today':
					// Ranges that need to align with local 'days' need special treatment.
					$app = JFactory::getApplication();
					$offset = $app->getCfg('offset');

					// Reset the start time to be the beginning of today, local time.
					$dStart = new JDate('now', $offset);
					$dStart->setTime(0, 0, 0);

					// Now change the timezone back to UTC.
					$tz = new DateTimeZone('GMT');
					$dStart->setTimezone($tz);
					break;
			}

			if ($range == 'post_year')
			{
				$query->where(
					'a.cron_date < ' . $db->quote($dStart->format('Y-m-d H:i:s'))
				);
			}
			else
			{
				$query->where(
					'a.cron_date >= ' . $db->quote($dStart->format('Y-m-d H:i:s')) .
						' AND a.cron_date <=' . $db->quote($dNow->format('Y-m-d H:i:s'))
				);
			}
		}
                
    $sendStatus = $this->getState('filter.is_done');
    if($sendStatus == 1){
        $query->where($db->qn('is_done').' = 1');
    }
    else if($sendStatus == 0){
        $query->where($db->qn('is_done').' = 0')
        ->where($db->qn('c.published').' = 1');
    }

		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
                
		
		return $query;
	}

	public function getTotalLeft(){
	    $q = $this->getDbo()->getQuery(true);
        $date = JFactory::getDate();
        $db = $this->getDbo();
        $q->select('COUNT(a.id)')->from($this->getDbo()->qn('#__mrocket_leads_cron', 'a'))
            ->innerJoin($db->qn('#__mrocket_responder_templates', 'b').' ON '.$db->qn('a.responder_id').' = '.$db->qn('b.id'))
            ->innerJoin($db->qn('#__mrocket_leads', 'lead').' ON '.$db->qn('a.lead_id').' = '.$db->qn('lead.id'))
             ->where($db->qn('a.cron_date').' <= '.$db->q($date->toSql(true)))
            ->where('a.is_done = 0')
            ->where('b.published = 1')
            ->where('(lead.is_temp = 0 OR b.sequence_id = -1 OR b.type = "opt_in")')
        ;
        $db->setQuery($q);
        return $db->loadResult();

    }
}
