<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelQueued extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		
		if (!empty($record->id))
		{
			return parent::canDelete($record);

		}
	}

	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Leadcrons', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.queued', 'queued', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
            // Check the session for previously entered form data.
            $data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.queued.data', array());

            if (empty($data))
            {
                    $data = $this->getItem();
                    if($data->is_done == 1){
                        $data->status = JText::_('COM_MARKETINGROCKET_SENT');
                    }
                    else 
                        $data->status = JText::_('COM_MARKETINGROCKET_IN_QUEUE');
            }
            
            

            return $data;
	}
        
        public function getItem($pk = null) {
            $pk = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
            $db = $this->getDbo();
            
            $q = $db->getQuery(true)
                    ->select(array(
                        'a.*',
                        'CONCAT('.$db->qn('b.first_name').', " ",'.$db->qn('b.last_name').') AS full_name',
                        $db->qn('b.email')
                    ))
                    ->from($db->qn('#__mrocket_leads_cron', 'a'))
                    ->innerJoin($db->qn('#__mrocket_leads', 'b').' ON '.$db->qn('a.lead_id').' = '.$db->qn('b.id'))
                    ->where($db->qn('a.id').' = '.$db->q($pk))
                ;
            $db->setQuery($q);
            
            return $db->loadObject();
        }

}
