<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLogic extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		
		if (!empty($record->id))
		{
			return parent::canDelete($record);

		}
	}

	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Logic', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
            $app = JFactory::getApplication();

		// Get the form.
            $form = $this->loadForm('com_marketingrocket.logic', 'logic', array('control' => 'jform', 'load_data' => $loadData));

            if (empty($form))
            {

                    return false;
            }



            // Modify the form based on access controls.
            if (!$this->canEditState((object) $data))
            {
                    // Disable fields for display.
                    $form->setFieldAttribute('ordering', 'disabled', 'true');
                    $form->setFieldAttribute('state', 'disabled', 'true');
                    $form->setFieldAttribute('publish_up', 'disabled', 'true');
                    $form->setFieldAttribute('publish_down', 'disabled', 'true');

                    // Disable fields while saving.
                    // The controller has already verified this is a record you can edit.
                    $form->setFieldAttribute('ordering', 'filter', 'unset');
                    $form->setFieldAttribute('state', 'filter', 'unset');
                    $form->setFieldAttribute('publish_up', 'filter', 'unset');
                    $form->setFieldAttribute('publish_down', 'filter', 'unset');
            }

            return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
        {
                // Check the session for previously entered form data.
                $data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.logic.data', array());

                if (empty($data))
                {
                        $data = $this->getItem();
                }

                return $data;
        }   
        
        public function delete(&$pks) {
            $ret = parent::delete($pks);
            if($ret == false)
                return false;
            
            $db = $this->getDbo();
            $q = $db->getQuery();
            foreach ($pks as $pk){
                $q->clear();
                $q->delete($db->qn('#__mrocket_actions'))->where($db->qn('landing_id').' = '.$db->q($pk))
                    ->where($db->qn('type').' = '.$db->q('tag_action'))
                    ;
                $db->setQuery($q);
                $db->execute();
            }
            
            return true;
                
        }
}
