<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLeadtag extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	public function getTable($type = 'Leadtag', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.leadtag', 'leadtag', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			
			return false;
		}


		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.leadtag.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}
        
        public function validate($form, $data, $group = NULL){
             print_r($data);
            $data = parent::validate($form, $data, $group);
            if($data === false)
                return false;
           
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            
            $lead_id = $data['lead_id'];
            if(empty($lead_id)){
                 $item = $this->getItem($data['id']);
                 $lead_id = $item->lead_id;
            }
            
            $query->select('*')->from('#__mrocket_leads_tags')
                    ->where('lead_id = '.$db->q($lead_id))
                    ->where('tag_id = '.$db->q($data['tag_id']))
                    ->where('campaign_id = '.$db->q($data['campaign_id']))
                    ;
            $id = JApplicationCms::getInstance()->input->getInt('id');
            if(!empty($id)){
                $query->where('id != '.$id);
            }
            $db->setQuery($query);
            $row = $db->loadObject();
            
            if(!empty($row)){
                $this->setError(JText::_('COM_MARKETING_THIS_LEAD_HAVE_THIS_TAG'));
                return false;
            }
            return $data;
            
        }
        
        




}
