<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * Methods supporting a list of  records.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_weblinks
 * @since       1.6
 */
class MarketingrocketModelLeadstatuses extends JModelList
{

        protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);



		


		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('id', 'asc');
	}
    
    
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.id,c.name as campaign_name,s.name as status_name');
		$query->from($db->quoteName('#__mrocket_lead_statuses').' AS a');
                $query->join('INNER' , $db->qn('#__mrocket_statuses'). ' AS s ON a.status_id = s.id');
                $query->join('INNER' , $db->qn('#__mrocket_campaign'). ' AS c ON a.campaign_id = c.id');
                
                $query->where('a.lead_id = '.JFactory::getApplication()->input->getInt('id'));
		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('id = '.(int) substr($search, 3));
			} else {
			}
		}

		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));

		
		return $query;
	}
}
