<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLeads extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 
				'title',
				'created',
				'campaign_name',
				'allvisits',
				'allsubmission',
				'converted',
				'published',
                                'full_name',
                                'w_metter'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
//		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		//parent::populateState('a.id', 'asc');
		parent::populateState('a.created', 'desc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}


	public function getQuery(){
	    $this->populateState();
        return $this->getListQuery();
    }
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
        ini_set ( 'memory_limit', '1000M' );
		// Create a new query object.
		$db		= $this->getDbo();
                try {
                    $db->setQuery('SET OPTION SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                try {

                    $db->setQuery('SET SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		$query->select('a.*, CONCAT(a.first_name, " ", COALESCE(a.last_name, " ")) AS full_name, b.form_name as form_name,'
//                        . ' GROUP_CONCAT(DISTINCT t.title) as tags,' // modify to show only unique tags and remove text 'in abc campaign as too much info
//                      . ' GROUP_CONCAT(t.title ," %in% ", ltc.`name` ) as tags,' //removed due to not working, showing dupes
//                      . 'GROUP_CONCAT(s.name ," %in% ", lsc.`name` ) as statuses'
                        . ' (Select GROUP_CONCAT(s.`name`, " %in% ", lsc.`name`) FROM `#__mrocket_lead_statuses` AS ls
LEFT JOIN `#__mrocket_statuses` AS s ON ls.status_id = s.id
LEFT JOIN `#__mrocket_campaign` AS lsc ON ls.campaign_id = lsc.id
WHERE a.id = ls.lead_id
) AS statuses,'
//(
//		SELECT
//			GROUP_CONCAT(
//				t2.title
//			)
//		FROM
//			`#__mrocket_leads_tags` AS lt2
//		LEFT JOIN `#__mrocket_tags` AS t2 ON lt2.tag_id = t2.id
//		WHERE
//			a.id = lt2.lead_id
//		AND lt2.campaign_id = 0
//	) AS type2tags,
        .'ld.value as form_name
'
                        );
		$query->from($db->qn('#__mrocket_leads'). ' AS a');
		$query->join('LEFT' , $db->qn('#__mrocket_landings'). ' AS b ON a.landing_id = b.id');
                
                $query->join('LEFT' , $db->qn('#__mrocket_lead_details'). ' AS ld ON a.id = ld.lead_id AND ld.field_name = "MR_form_name"');
                
                
//                $query->join('LEFT' , $db->qn('#__mrocket_lead_statuses'). ' AS ls ON a.id = ls.lead_id');
//		$query->join('LEFT' , $db->qn('#__mrocket_statuses'). ' AS s ON ls.status_id = s.id');
//                $query->join('LEFT' , $db->qn('#__mrocket_campaign'). ' AS lsc ON ls.campaign_id = lsc.id');
                
//                $query->join('LEFT' , $db->qn('#__mrocket_leads_tags'). ' AS lt ON a.id = lt.lead_id AND lt.campaign_id != 0');
//                $query->join('LEFT' , $db->qn('#__mrocket_tags'). ' AS t ON lt.tag_id = t.id');
//                $query->join('LEFT' , $db->qn('#__mrocket_campaign'). ' AS ltc ON lt.campaign_id = ltc.id');
                
//                $query->join('LEFT' , $db->qn('#__mrocket_leads_tags') .' AS lt2 ON a.id = lt2.lead_id AND lt2.campaign_id = 0');
//                $query->join('LEFT',  $db->qn('#__mrocket_tags') .' AS t2 ON lt2.tag_id = t2.id');
		
		
		$query->where('a.is_temp = 0');
                $query->group('a.id');
                
		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				
                                
                                $query->join('LEFT' , $db->qn('#__mrocket_lead_details'). ' AS ldsearch ON a.id = ldsearch.lead_id AND ldsearch.value LIKE '.$search);
                                
                                $query->where('((a.first_name LIKE '.$search.' OR a.last_name LIKE '.$search.') OR ldsearch.value IS NOT NULL)')
                                ;
			}
		}
                
                $published = $this->getState('filter.published');
		
		if (is_numeric($published))
		{
			$query->where('a.published = ' . (int) $published);
		}
                
                $tags = $this->getState('filter.tag');
                
                if(!empty($tags) && !empty($tags[0])){

//                    $query->where('lt.tag_id IN ('.  implode(',', $tags).') OR lt2.tag_id IN ('.implode(',', $tags).')');


                    $query->join('LEFT' , $db->qn('#__mrocket_leads_tags'). ' AS lt ON a.id = lt.lead_id')
                        ->where('lt.tag_id IN ('.  implode(',', $tags).')');
                    ;
                }
                
                $campaign = $this->getState('filter.campaign');
                
                if (!empty($campaign))
		{
                    $query->join('INNER' , $db->qn('#__mrocket_lead_statuses'). ' AS ls ON a.id = ls.lead_id');
			$query->where('ls.campaign_id = ' . (int) $campaign);
                        
		}
                
                $status = $this->getState('filter.status');
                
                if (is_numeric($status))
		{
                    if(empty($campaign))
                        $query->join('LEFT' , $db->qn('#__mrocket_lead_statuses'). ' AS ls ON a.id = ls.lead_id');
                    $query->where('ls.status_id = ' . (int) $status);
		}
                
                
                // Add filter for registration ranges select list
		$range = $this->getState('filter.range');
                
                // Apply the range filter.
		if ($range)
		{
			// Get UTC for now.
			$dNow = new JDate;
			$dStart = clone $dNow;

			switch ($range)
			{
				case 'past_week':
					$dStart->modify('-7 day');
					break;

				case 'past_1month':
					$dStart->modify('-1 month');
					break;

				case 'past_3month':
					$dStart->modify('-3 month');
					break;

				case 'past_6month':
					$dStart->modify('-6 month');
					break;

				case 'post_year':
				case 'past_year':
					$dStart->modify('-1 year');
					break;

				case 'today':
					// Ranges that need to align with local 'days' need special treatment.
					$app = JFactory::getApplication();
					$offset = $app->getCfg('offset');

					// Reset the start time to be the beginning of today, local time.
					$dStart = new JDate('now', $offset);
					$dStart->setTime(0, 0, 0);

					// Now change the timezone back to UTC.
					$tz = new DateTimeZone('GMT');
					$dStart->setTimezone($tz);
					break;
			}

			if ($range == 'post_year')
			{
				$query->where(
					'a.created < ' . $db->quote($dStart->format('Y-m-d H:i:s'))
				);
			}
			else
			{
				$query->where(
					'a.created >= ' . $db->quote($dStart->format('Y-m-d H:i:s')) .
						' AND a.created <=' . $db->quote($dNow->format('Y-m-d H:i:s'))
				);
			}
		}
		$blacklistfilter = $this->getState('filter.blacklist');
		if (isset($blacklistfilter) && $blacklistfilter != '')
		{
			//$query->where("a.recieve_email = '". $blacklistfilter."');
			$query->where(

				'a.recieve_email= ' . $db->quote($blacklistfilter)

			);
		}
                
                if(isset($_POST['show_fields'])){
                    $fields = JFactory::getApplication()->input->post->get('show_fields',array(), 'array');
                    
                    $params = JComponentHelper::getParams('com_marketingrocket');
                        
                    $params->set('show_fields', json_encode($fields));
                    $q = $db->getQuery(true);

                    // Build the query
                    $q->update('#__extensions AS a');
                    $q->set('a.params = ' . $db->quote((string)$params));
                    $q->where('a.element = "com_marketingrocket"');

                    // Execute the query
                    $db->setQuery($q);
                    $db->execute();
                }   
                else {
                    $fields = json_decode(JComponentHelper::getParams('com_marketingrocket')->get('show_fields', '[]'), true);
                }
                
                $app = JFactory::getApplication();
                $app->setUserState('MR_LEADS_SHOWING_FIELDS', $fields);
                
                if(!empty($fields)){
                    foreach ($fields as $key => $field){
                        $scapedName = str_replace("'", '', $field);
                        if(empty($scapedName))
                            continue;
//                        $query->leftJoin($db->qn('#__mrocket_lead_details', 'LD_'.$key).' ON '.$db->qn('a.id').' = '.$db->qn('LD_'.$key.'.lead_id').' AND '.$db->qn('LD_'.$key.'.field_name').' = '.$db->q($field));
                        
                        
                        $query->leftJoin($db->qn('#__mrocket_lead_details', 'LD_'.$key).' ON '.$db->qn('a.id').' = '.$db->qn('LD_'.$key.'.lead_id').' AND '.$db->qn('LD_'.$key.'.id').' =  (SELECT id FROM #__mrocket_lead_details WHERE lead_id = a.id AND '.$db->qn('field_name').' = '.$db->q($scapedName).' ORDER BY id DESC LIMIT 1)');
                        
                        $query->select($db->qn('LD_'.$key.'.value', 'additional_'.$scapedName));
                        
//                        $query->select('(SELECT 
//			GROUP_CONCAT(
//				'.$db->qn('LD_'.$key.'.value').'
//			)
//		FROM
//			'.$db->qn('#__mrocket_lead_details', 'LD_'.$key).'
//		WHERE '.$db->qn('a.id').' = '.$db->qn('LD_'.$key.'.lead_id').'
//AND '.$db->qn('LD_'.$key.'.field_name').' = '.$db->q($field).') AS '.$db->qn('additional_'.$scapedName));
                    }
                }

		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
                
		$query->order($db->escape($orderCol.' '.$orderDirn));
                
//                echo $query->dump();
//                die;
//                
		return $query;
	}
	public function getTags($leadId){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select('b.id,b.title')
		->from($db->qn('#__mrocket_leads_tags') . ' AS a');
		$query->join('INNER' , $db->qn('#__mrocket_tags'). ' AS b ON a.tag_id = b.id');
		$query->where($db->qn('a.lead_id') .' = '.$db->q($leadId));
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	public function getAllTags(){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select('*')
		->from($db->qn('#__mrocket_tags'))
		->where('published = 1');
		$db->setQuery($query);
		return $db->loadObjectList();
		
	}
	public function getAllStatuses(){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select('*')
		->from($db->qn('#__mrocket_statuses'))
		->where('published = 1');
		$db->setQuery($query);
		return $db->loadObjectList();
	}
        
        public function getBulkForm(){
		$app = JFactory::getApplication();
		
		// Get the form.
		$form = $this->loadForm('com_marketingrocket.edit.leadbulk', 'leadbulk', array('control' => 'batch', 'load_data' => false));
		if (empty($form))
		{
			return false;
		}
		
		
		return $form;
	}
        
        public function getAllFields($justCol = false, $fields = array()){
            $db = $this->getDbo();
            $q = $db->getQuery(true);            
            if($justCol)
                $q->select($db->qn('ld.field_name'));
            else {
                $q->select(
                    $db->qn(array('ld.field_name', 'ld.label','l.recieve_email'))
                );
            }
        
            $q->from('#__mrocket_lead_details AS ld')->group('ld.field_name');
			$q->join('LEFT','#__mrocket_leads as l ON l.id = ld.lead_id');
            if(!empty($fields)){

               $q->where($db->qn('ld.field_name').' IN ('.implode(',', $db->q($fields)).')');
            }
		
            $db->setQuery($q);
            
            
            if($justCol){
                $res = $db->loadColumn();
                $res[] = 'created';
                return $res;
            }
            
            $res = $db->loadObjectList();
            
            $array = array();
            foreach ($res as $row){
                $array[$row->field_name] = $row->label;
            }
            $array['created'] = JText::_('COM_USERS_HEADING_REGISTRATION_DATE');
            return $array;
        }

        public function getTotalUnfiltered(){
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            $query->select('COUNT(a.id)')->from($db->qn('#__mrocket_leads'). ' AS a')
            ->where($db->qn('a.is_temp').' = 0');

            $db->setQuery($query);
            return $db->loadResult();

        }

	
}
