<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLead extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canDelete($record)
	{

		if (!empty($record->id))
		{
			return parent::canDelete($record);

		}
	}

	/**
	 * Method to test whether a record can have its state changed.
	 *
	 * @param   object	A record object.
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return parent::canEditState($record);
	}
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Lead', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	
	
	public function getForm($data = array(), $loadData = true){
		
                JForm::addRulePath(JPATH_COMPONENT_SITE . '/models/rules');
		
		// Get the form.
		$form = $this->loadForm('com_marketingrocket.edit.lead', 'lead', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}
                
		return $form;
	}
	
	protected function loadFormData()
	{
            $input = JFactory::getApplication()->input;
            if($input->getString('layout', '') == 'import'){
                $data = JFactory::getApplication()->getUserState('com_marketingrocket.import.lead.data', array());
            }
            else 
                $data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.lead.data', array());
            
            // Check the session for previously entered form data.
            if (empty($data))
            {
                $data = $this->getItem();
                
                $leadId =(int) $this->getState($this->getName() . '.id');
                if(!empty($leadId)){ // new lead defaults is set in xml and its empty
                    
                    // get tags first
                    $db = $this->getDbo();
                    $q = $db->getQuery(true);
                    $q->select(array(
                                    $db->qn('tag_id'),
                                    $db->qn('campaign_id'),
                                )
                            )
                            ->from($db->qn('#__mrocket_leads_tags'))
                            ->where($db->qn('lead_id').' = '.$leadId);
                    $db->setQuery($q);
                    $tags = $db->loadObjectList();

                    $newArray = array('campaign_id' => array(0), 'tag_id' => array(0));
                    foreach ($tags as $k => $tag){
                        $newArray['campaign_id'][$k] = $tag->campaign_id;
                        $newArray['tag_id'][$k] = $tag->tag_id;
                    }
                    
                    // the data must be json decoded like this : {'campaign_id':[0],'tag_id':[0]} 
                    // for more info see https://docs.joomla.org/Repeatable_form_field_type
                    $tags = json_encode($newArray);

                    $data->lead_tags = $tags;
                    
                    // get status of lead
                    $db = $this->getDbo();
                    $q = $db->getQuery(true);
                    $q->select(array(
                                    $db->qn('campaign_id'),
                                    $db->qn('status_id'),
                                )
                            )
                            ->from($db->qn('#__mrocket_lead_statuses'))
                            ->where($db->qn('lead_id').' = '.$leadId);
                    $db->setQuery($q);
                    
                    $statuses = $db->loadObjectList();

                    $newArray = array('campaign_id' => array(0), 'status_id' => array(0));
                    foreach ($statuses as $k => $status){
                        $newArray['campaign_id'][$k] = $status->campaign_id;
                        $newArray['status_id'][$k] = $status->status_id;
                    }
                    
                    // the data must be json decoded like this : {'campaign_id':[0],'tag_id':[0]} 
                    // for more info see https://docs.joomla.org/Repeatable_form_field_type
                    $statuses = json_encode($newArray);
                    $data->lead_statuses = $statuses;
                    
                    
                    if($data->recieve_email == 1)
                        $data->blacklist_email = 0;
                    else 
                        $data->blacklist_email = 1;
                }
                
            }
            return $data;
	}
	
        /**
         * Deprected this function is not using anywhere and most not used
         * @param array $tags
         * @param integer $lead_id
         */
	public function changeLeadTags($tags, $lead_id){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->delete($db->qn('#__mrocket_leads_tags'))
		->where('lead_id = '.$db->q($lead_id));
		$db->setQuery($query);
		$db->execute();
		foreach($tags as $tag){
			
			
			$query	= $db->getQuery(true);
			$query->insert($db->qn('#__mrocket_leads_tags'))
			->set('lead_id = '.$db->q($lead_id))
			->set('tag_id = '.$db->q($tag))
			;
			$db->setQuery($query);
			$db->execute();
		}
	}
	public function changeStatus($status, $lead_id){
		$db		= $this->getDbo();
		
		$query	= $db->getQuery(true);
		$query->update($db->qn('#__mrocket_leads'))
		->set('lead_status = '.$db->q($status))
		->where('id = '.$db->q($lead_id));
		
		$checkquery	= $db->getQuery(true);
		$checkquery->select('*')
		->from($db->qn('#__mrocket_statuses'))
		->where('id = '.$db->q($status));
		$db->setQuery($checkquery);
		$res = $db->loadObject();
		if($res->final == '1'){
			$query->set('converted_date = CURDATE()');
		}
		
		
		$db->setQuery($query);
		$db->execute();
	}
	public function updateNote($note, $lead_id){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->update($db->qn('#__mrocket_leads'))
		->set('note = '.$db->q($note))
		->where('id = '.$db->q($lead_id));
		$db->setQuery($query);
		$db->execute();
	}
	
//	public function save($data)
//	{
//		$db = $this->getDbo();
//		
//		$res = parent::save($data);
//		if(!$res)
//			return $res;
//		if(!empty($data['id']))
//			$id = $data['id'];
//		else 
//			$id = $db->insertid();
//		$this->changeLeadTags($data['lead_tags'], $id);
//		return $res;
//	}
	
	public function getLeadCrons(){
		$leadId =(int) $this->getState($this->getName() . '.id');
		
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->qn('#__mrocket_leads_cron'). ' AS a')
		->innerJoin($db->qn('#__mrocket_responder_templates').' AS b ON a.responder_id = b.id')
		->order('a.cron_date DESC')
		->where('a.lead_id = '.$leadId)
//		->where('b.type = "responder"')
		;
		$db->setQuery($query,0,20);
		
		return $db->loadObjectList();
	}
	public function getLeadCampaign(){
		$leadId =(int) $this->getState($this->getName() . '.id');
		
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->qn('#__mrocket_lead_campaigns'). ' AS a')
		->innerJoin($db->qn('#__mrocket_campaign').' AS b ON a.campaign_id = b.id')
		->where('a.lead_id = '.$leadId);
		$db->setQuery($query);
		
		return $db->loadObjectList();
	}
        
        public function getLeadTags(){
            
            $leadId =(int) $this->getState($this->getName() . '.id');
            
            $db = $this->getDbo();
            $query	= $db->getQuery(true);
            $query->select('GROUP_CONCAT(t.title ," %in% ", ltc.`name` ) as tags, GROUP_CONCAT(t.title) as type2tags')->from($db->qn('#__mrocket_leads_tags'). ' AS lt');
            $query->join('LEFT' , $db->qn('#__mrocket_tags'). ' AS t ON lt.tag_id = t.id');
            $query->join('LEFT' , $db->qn('#__mrocket_campaign'). ' AS ltc ON lt.campaign_id = ltc.id')
            ->where('lt.lead_id = '.$leadId)
            ->group('lt.lead_id')
            ;
            
            
            $db->setQuery($query);
            $res = $db->loadObject();
            if(empty($res))
                return null;
            if(empty($res->type2tags))
                return $res->tags;
            if(empty($res->tags))
                return $res->type2tags;
            return $res->tags.','.$res->type2tags;
            
        }
        
        public function getLeadStatuses(){
            
            $leadId =(int) $this->getState($this->getName() . '.id');
            
            $db = $this->getDbo();
            $query	= $db->getQuery(true);
            $query->select('GROUP_CONCAT(s.`name`, " %in% ", lsc.`name`)')->from($db->qn('#__mrocket_lead_statuses'). ' AS ls');
            $query->join('LEFT' , $db->qn('#__mrocket_statuses'). ' AS s ON ls.status_id = s.id');
            $query->join('LEFT' , $db->qn('#__mrocket_campaign'). ' AS lsc ON ls.campaign_id = lsc.id')
            ->where('ls.lead_id = '.$leadId)
            ->group('ls.lead_id')
            ;
            
            
            $db->setQuery($query);
            return $db->loadResult();
            
        }
        
        public function validate($form, $data, $group = null) {
//            if(empty($data['first_name'])){
//                $data['first_name'] = $data['emial'];
//            }
            
            $db = $this->getDbo();
            
            if(!empty($data['user_id'])){
                $q = $db->getQuery(true);

                $q->select('id')->from('#__mrocket_leads')->where('user_id ='.$db->q($data['user_id']));

                if(!empty($data['id'])){
                    $q->where('id !='.$db->q($data['id']));
                }

                $db->setQuery($q);
                $res = $db->loadResult();

                if(!empty($res)){

                    $this->setError(JText::_('COM_MARKETINGROCKET_THIS_USER_ASSIGNED_TO_ANOTEHR_LEAD'));

                    return false;
                }
            }
           
            $q = $db->getQuery(true);
            $q->select('id')->from('#__mrocket_leads')->where('email ='.$db->q($data['email']))->where($db->qn('is_temp').' = 0');
            
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $q->where($db->qn('id').' != '.$id);
            $db->setQuery($q);
            $res = $db->loadResult();
            if(!empty($res)){
                $this->setError(JText::_('COM_MARKETINGROCKET_THERE_IS_ANOTHER_LEAD_WITH_THIS_EMAIL'));

                return false;
            }
            
            
            $ret =  parent::validate($form, $data, $group);
            if(!empty($ret)){
                if($ret['blacklist_email'] == 1)
                    $ret['recieve_email'] = 0;
                else 
                    $ret['recieve_email'] = 1;
            }
            return $ret;
        }


        
        
        /**
	 * Method to perform batch operations on an item or a set of items.
	 *
	 * @param   array  $commands  An array of commands to perform.
	 * @param   array  $pks       An array of item ids.
	 * @param   array  $contexts  An array of item contexts.
	 *
	 * @return  boolean  Returns true on success, false on failure.
	 *
	 */
	public function batch($commands, $pks, $contexts)
	{
            
                try {
                    $db = $this->getDbo();
                    $db->transactionStart();
                    
                    // Sanitize user ids.
                    $pks = array_unique($pks);
                    JArrayHelper::toInteger($pks);

                    // Remove any values of zero.
                    if (array_search(0, $pks, true))
                    {
                            unset($pks[array_search(0, $pks, true)]);
                    }

                    require JPATH_SITE.'/components/com_marketingrocket/models/landing.php';

                    $landingModel = JModelLegacy::getInstance('landing', 'MarketingrocketModel', array('ignore_request' => true));



                    if(!empty($commands['batch_add_tag'][0])){
                        if(count($commands['batch_add_tag']) == 1) // in bulk edit
                            $commands['batch_add_tag'] = explode(',', $commands['batch_add_tag'][0]);

                        foreach ($commands['batch_add_tag'] as $tagId){
                            foreach ($pks as $pk){
                                $landingModel->_addTagToLead($pk, $tagId);
                            }
                        }
                    }

                    if(!empty($commands['batch_remove_tag'][0])){
                         if(count($commands['batch_remove_tag']) == 1)
                            $commands['batch_remove_tag'] = explode(',', $commands['batch_remove_tag'][0]);
                        foreach ($commands['batch_remove_tag'] as $tagId){
                            foreach ($pks as $pk){
                                $landingModel->_removeTagFromLead($pk, $tagId);
                            }
                        }


                    }

                    if(!empty($commands['batch_status']) && !empty($commands['batch_campaign'])){
                        foreach ($pks as $pk){
                            $landingModel->_setLeadStatus($pk, $commands['batch_status'], $commands['batch_campaign']);
                        }
                    }

                    if(!empty($commands['batch_subscrib_campaign'])){
                        foreach ($pks as $pk){
                            $landingModel->_addLeadToCampaign($pk, $commands['batch_subscrib_campaign']);
                        }
                    }

                    if(!empty($commands['batch_unsubscrib_campaign'])){
                        foreach ($pks as $pk){
                            $landingModel->_removeLeadFromCampaign($pk, $commands['batch_unsubscrib_campaign']);
                        }
                    }

                    if(!empty($commands['batch_responder_sequence']) && !empty($commands['batch_responder_sequence'][0])){
                        $seqsId = explode(',', $commands['batch_responder_sequence'][0]);
                        foreach ($seqsId as $seqId){
                             $item = new stdClass();
                            $item->responder_type = 'default';
                            $item->responder_sequence_id = $seqId;
                            foreach ($pks as $pk){
                                $landingModel->_addResponderToLead($pk, '', $item);
                            }
                        }


                    }

                    // Clear the cache
                    $this->cleanCache();

                    
                    
                    $db->transactionCommit();


                    return true;
                }
                catch(Exception $e){

                    $this->setError($e->getMessage());
                    
                    $db->transactionRollback();
                    
                    return false;
                }
		
	}
        
        
        public function getImportForm(){
            // Get the form.
            $form = $this->loadForm('com_marketingrocket.import.lead', 'importlead', array('control' => 'jform', 'load_data' => true));
            if (empty($form))
            {
                return false;
            }


            return $form;
        }
        
        public function getFormData(){
            
            $id = JFactory::getApplication()->input->getInt('id');
            if(empty($id))
                return array();
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            
            $query->select('a.*,b.title,b.form_json')->from('#__mrocket_lead_details AS a')
                    ->leftJoin('#__mrocket_landings AS b ON a.landing_id = b.id')
                    ->where('a.lead_id = '.$id)
                    ->order('a.landing_id DESC,a.id ASC')
            ;
            
            $db->setQuery($query);
            
            $res =$db->loadObjectList();
            $array = array();
            $lastId = false;
            $ids = array();
            $obj = new stdClass();
            foreach ($res as $row){
                if($row->landing_id !== $lastId){
                    if($lastId !== false){
                        $obj->ids = $ids;
                       
                        $array[] = $obj;
                    }
                    $lastId = $row->landing_id;
                    $obj = new stdClass();
                    $obj->title = $row->title;
                    $obj->landing_id = $lastId;
                    $ids = array(0, 0);
                }
                $key = $row->label;
                if(empty($key))
                    $key = $row->field_name;
                if(empty($key))
                    continue;
                if(!$this->_isJson($row->value)){
                    $obj->$key = $row->value;
                }
                else {
                    $jsonVal = json_decode($row->value, true);
                    $jsonVal = implode(',', $jsonVal);
                    $obj->$key = $jsonVal;
                }
                
                
                $ids[] = $row->id;
                
                if($key == 'MR_form_name'){
                    $obj->title =  $row->value;
                }
                
            }
            $obj->ids = $ids;
            $array[] = $obj;
            return $array;
            
        }
        
        private function _isJson($string) {
            return is_array(json_decode($string,true));
        }
        
        public function save($data)
        {
            $db = $this->getDbo();
            try {
                $db->transactionStart();
                
                $ret = parent::save($data);
                if($ret){
                    $leadId = $this->getState($this->getName() . '.id');

                    $tagsArray = json_decode($data['lead_tags']);
                    
                    
                    
                    $lead = $this->getTable();
                    $data['id'] = $leadId;
                    $lead->bind($data);
                    if($this->getState($this->getName() . '.new', false)){
                        $lead->addRefCode();
                        
                        
                        $table = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                        
                        $table->field_name = 'email';
                        $table->label = JText::_('COM_MARKETINGROCKET_EMAIL');
                        $table->value = $data['email'];
                        $table->lead_id = $leadId;
                        $table->store();
                        
                        
                        if(!empty($data['first_name'])){
                            $table = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                        
                            $table->field_name = 'first-name';
                            $table->label = JText::_('COM_MARKETINGROCKET_NAME');
                            $table->value = $data['first_name'];
                            $table->lead_id = $leadId;
                            $table->store();
                        }
                        
                    }
                    
                        
                    $q = $db->getQuery(true);
                    $q->select('*')->from($db->qn('#__mrocket_leads_tags'))->where($db->qn('lead_id').' = '.$db->q($leadId));
                    $db->setQuery($q);
                    
                    $leadTags = $db->loadObjectList();
                    
                    $leadTagsArray = array();
                    foreach ($leadTags as $leadTag){
                        $key = $leadTag->tag_id.'_'.$leadTag->campaign_id;
                        $leadTagsArray[$key] = $leadTag;
                    }
                    $checkedKey = array();//for preventing duplicate
                    if(!empty($tagsArray->tag_id)){
                        foreach ($tagsArray->tag_id as $key => $row){
                            if(!empty($row)){
                                $rowKey = $row.'_'.$tagsArray->campaign_id[$key];
                                if(!isset($leadTagsArray[$rowKey]) && !in_array($rowKey, $checkedKey)){
                                    $checkedKey[] = $rowKey;
                                    $lead->addTag($row , $tagsArray->campaign_id[$key]);
                                }
                                unset($leadTagsArray[$rowKey]);
                            }
                        }
                    }
                    sort($leadTagsArray);
                    foreach ($leadTagsArray as $row){
                        $leadTag = $this->getTable('Leadtag');
                        $leadTag->bind($row);
                        $leadTag->delete();
                    }
                    
                    
                    $statussArray = json_decode($data['lead_statuses']);
                    
                    
                    $q = $db->getQuery(true);
                    $q->select('*')->from($db->qn('#__mrocket_lead_statuses'))->where($db->qn('lead_id').' = '.$db->q($leadId));
                    $db->setQuery($q);
                    
                    $leadStatuses = $db->loadObjectList();
                    
                    $leadStatusArray = array();
                    
                    foreach ($leadStatuses as $leadStatus){
                        $leadStatusArray[$leadStatus->campaign_id] = $leadStatus;
                    }
                    $checkedKey = array();//for preventing duplicate
                    $campaigns = array(); // only one status for each campaign
                    if(!empty($statussArray->status_id)){
                        foreach ($statussArray->status_id as $key => $row){
                            if(!empty($row)){
                                $campaingId = $statussArray->campaign_id[$key];

                                if(isset($leadStatusArray[$campaingId])){
                                    $dbRow = $leadStatusArray[$campaingId];
                                    unset($leadStatusArray[$campaingId]);
                                }

                                if(in_array($campaingId, $campaigns)){
                                    JFactory::getApplication()->enqueueMessage('Multi Status In Campaign Is Not Allowed', 'error');
                                    continue;
                                }
                                $campaigns[] = $campaingId;

                                if($dbRow->status_id == $row) // row is in database
                                    continue;

                                $lead->setStatus($row , $campaingId);
                            }
                        }
                    }
                    foreach ($leadStatusArray as $row){
                        $leadTag = $this->getTable('Leadstatus');
                        $leadTag->delete($row->id);
                    }

                }
                
                $db->transactionCommit();
                
                return $ret;
            }
            catch (Exception $e){
                $db->transactionRollback();
                throw $e;
            }
           
           
        }
        
        public function delete(&$pks) {
            $ret = parent::delete($pks);
            if($ret == true){
                $db = $this->getDbo();
                $q = $db->getQuery();
                foreach ($pks as $pk){
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_leads_cron'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_lead_details'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_leads_tags'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_refcodes'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_lead_campaigns'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    $q->clear();
                    $q->delete($db->qn('#__mrocket_lead_statuses'))
                            ->where($db->qn('lead_id').' = '.$db->q($pk));
                    $db->setQuery($q);
                    $db->execute();
                    
                    
                    
                    
                    
                }
            }
            return $ret;
        }
        
        
        




}
