<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLandingtemplate extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id',
				'name',
				'desc' , 'html'
			);
		}

		parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null)
	{
		
		parent::populateState('a.id', 'asc');
		$this->setState('list.limit', 100);
	}

	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'*'
			)
		);
		$query->from($db->quoteName('#__mrocket_landing_templates'));
		

		
		return $query;
	}
	public function getTypes(){
		$db		= $this->getDbo();
		$db->setQuery('SHOW COLUMNS FROM #__mrocket_landing_templates LIKE "type"');
		$row = $db->loadAssoc();
		
		$type = $row['Type'];
		preg_match('/enum\((.*)\)$/', $type, $matches);
		$vals = explode(',', str_replace("'", "", $matches[1]));
		return $vals;
	}
        
        
        public function getTable($type = 'Landingtemplate', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
        
        
}
