<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelLandings extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 
				'title',
				'created',
				'campaign_name',
				'allvisits',
				'allsubmission',
				'converted',
				'published'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
                
               

		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.id', 'desc');
     
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
                try {
                    $db->setQuery('SET OPTION SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                try {
                
                    $db->setQuery('SET SQL_BIG_SELECTS = ON');
                    $db->execute();
                }
                catch (Exception $e){

                }
                
                
                
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.*,
				c.name as campaign_name,
	SUM(b.visit) AS allvisits,
	SUM(b.submission) AS allsubmission,(
		SELECT
			COUNT(l.id)
		FROM
			#__mrocket_leads AS l
		INNER JOIN #__mrocket_statuses AS s ON l.lead_status = s.id
		AND s.final = 1
                INNER JOIN #__mrocket_lead_statuses AS ls ON l.id = ls.lead_id AND ls.status_id = s.id
		WHERE l.landing_id = a.id AND ls.campaign_id = a.campaign_id
		GROUP BY
			l.landing_id
	)
	AS converted'
			)
		);
		$query->from($db->quoteName('#__mrocket_landings').' AS a');
		$query->join('LEFT', $db->qn('#__mrocket_campaign') .' AS c ON a.campaign_id = c.id');
		$query->join('LEFT', $db->qn('#__mrocket_daily_stat') .' AS b ON a.id = b.landing_id');
		//$query->where($db->qn('a.published') .' = 1');
		$query->group('a.id');
		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('(a.title LIKE '.$search.')');
			}
		}
                
                $campaign = $this->getState('filter.campaign_id');
                
                if (is_numeric($campaign))
		{
                    $query->where('a.campaign_id = '.$campaign);
		}


		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		if(!isset($_REQUEST['list']['fullordering']))
		{
			$query->order('a.published desc, a.id desc');
		}	
		else
		{	
			$query->order($db->escape('a.published desc, '.$orderCol.' '.$orderDirn));
		}	
		return $query;
	}
}
