<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
 
defined('_JEXEC') or die;

class MarketingrocketModelLanding extends JModelAdmin
{
	protected $text_prefix = 'COM_MARKETINGROCKET';
        
        public static $formData = null;

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 * @since   1.6
	 */
	public function getTable($type = 'Landing', $prefix = 'MarketingrocketTable', $config = array())
	{
            if(JFactory::getApplication()->input->post->get('task') == 'landing.savepreview' || JFactory::getApplication()->input->post->get('task') == 'landing.autosave'){
                    return JTable::getInstance('Temp', $prefix, $config);
            }
            else 
                    return JTable::getInstance($type, $prefix, $config);
	}

	public function save($data){
	       header('X-XSS-Protection:0');
	       // echo "<pre>"; print_r($data); die;
            
            if(JFactory::getApplication()->input->post->get('task') == 'landing.savepreview'){
                $data['save_type'] = 'preview';
                
            }
            else if(JFactory::getApplication()->input->post->get('task') == 'landing.autosave'){
                $data['save_type'] = 'auto';
                $data['landing_id'] = JFactory::getApplication()->input->getInt('id', 0);
            }
            
            if(!empty($data['css'])){
                $data['css']  = $this->makeCssSafe($data['css']);
            }
            $data['page_option'] = array();
            
            if(!empty($data['header_code'])){
                $data['page_option']['header_code'] = $data['header_code'];
            }
            if(!empty($data['exit_popup'])){
                $data['page_option']['exit_popup'] = $data['exit_popup'];
                
                $data['page_option']['exit_popup_size'] = $data['exit_popup_size'];
                $data['page_option']['exit_popup_delay'] = $data['exit_popup_delay'];
                $data['page_option']['exit_popup_cookie'] = $data['exit_popup_cookie'];
            }
            if($data['have_paypal'] == 1)
                $data['is_double_optin'] = 0;
            
            $data['page_option']['selected_form_style'] = $data['selected_form_style'];
            
            $data['page_option']['body_code'] = $data['body_code'];

            $data['page_option']['is_double_optin'] = $data['is_double_optin'];

            $data['page_option']['optin_responder'] = $data['optin_responder'];

            $form = json_decode($data['form_json']);
           
            
            $id = JFactory::getApplication()->input->getInt('id');
			$captchkey = '';
            foreach ($form as $key => $row){
                if(!empty($row->name))
                    $name = $row->name;
                else 
                    $name = $row->label;
				
				if($row->field_type=='recaptcha'){
				  //$captchkey = $row->name;
				  $name = 'Recaptcha';
				}	
					
                if(empty($id)){
                    $name = JFilterOutput::stringURLSafe($name);
                    $row->name = $name;
                }
                else {
                    $row->name = strtolower(str_replace(' ', '_', $name));
                }
				if($row->field_type=='recaptcha'){
				  $captchkey = $row->name;
				}
                $form[$key] = $row;
                
            }
			//echo "<pre>";
           // print_r($captchkey); die;
         
            $data['form_json'] = json_encode($form);

            $data['exit_popup_modal'] = str_replace('on-click="', 'onclick="', $data['exit_popup_modal']);
            $data['exit_popup_modal_editor'] = str_replace('on-click="', 'onclick="', $data['exit_popup_modal_editor']);

            $data['modal_editor'] = str_replace('on-click="', 'onclick="', $data['modal_editor']);
            $data['modal_body'] = str_replace('on-click="', 'onclick="', $data['modal_body']);
            $data['page_html'] = str_replace('on-click="', 'onclick="', $data['page_html']);
            $data['page_editor'] = str_replace('on-click="', 'onclick="', $data['page_editor']);
			$data['modal_editor'] = str_replace('Your-Site-Key', $captchkey, $data['modal_editor']);
			

            
            $data['page_option']['no_index'] = $data['no_index'];
            
            $data['page_option']['load_fonts'] = $data['load_fonts'];

            $data['page_option']['font_weights'] = $data['font_weights'];
            
            $data['page_option'] = json_encode($data['page_option']);
            
            $data['viewing_tag'] = (!empty($data['viewing_tag'])) ? json_encode($data['viewing_tag']) : '';
            
            $data['adding_tag'] = (!empty($data['adding_tag'])) ? json_encode($data['adding_tag']) : '';
             
            $data['removing_tag'] = (!empty($data['removing_tag'])) ? json_encode($data['removing_tag']) : '';
            
            $data['responder_sequence_id'] = (!empty($data['responder_sequence_id'])) ? json_encode($data['responder_sequence_id']) : '';
			
			
            
            $task = JFactory::getApplication()->input->post->get('task');
            if($task == 'landing.save2copy'){
                $title = $data['title'].' copy';
                $db = $this->getDbo();
                $q = $db->getQuery(true);
                $firstTime = true;
                do {
                    if($firstTime)
                        $firstTime = false;
                    else 
                        $title = JString::increment($title);
                    $q->clear();
                    $q->select('id')->from($db->qn('#__mrocket_landings'))
                            ->where($db->qn('title').' = '.$db->q($title))
                            ->where($db->qn('campaign_id').' = '.$db->q($data['campaign_id']))
                        ;
                    $db->setQuery($q);
                    $res = $db->loadResult();
                    
                }
                while (!empty($res));
                $data['title'] = $title;
            }
            $ret = parent::save($data);
            
            if($ret == true && $data['is_split'] == 1){
                $db = $this->getDbo();
                $q = $db->getQuery(true);
                $q->update('#__mrocket_landings')->set($db->qn('is_split') .' = 1')->where($db->qn('alias').' = '.$db->q($data['alias']));
                $db->setQuery($q);
                $db->execute();
            }
            if($ret == true && $this->getState($this->getName() . '.new')){
                $id = $this->getState($this->getName() . '.id');
                $session = JFactory::getSession();
                if($session->has('landing_action')){
                    $sessionData = $session->get('landing_action');
                    JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                    foreach ($sessionData as $rowData){
                        $table = JTable::getInstance('Action', 'MarketingrocketTable');
                        $rowData['landing_id'] = $id;
                        $table->bind($rowData);
                        $table->store();
                    }
                    $session->clear('landing_action');
                    
                }
            }
            if($ret == true && $task == 'landing.save2copy'){
                $id = JFactory::getApplication()->input->getInt('id');
                $newId = $this->getState($this->getName() . '.id');
                $actionModel = JModelLegacy::getInstance('Action', 'MarketingrocketModel');
                $actions = $actionModel->getItems($id);
                foreach ($actions as $action){
                        $table = JTable::getInstance('Action', 'MarketingrocketTable');
                        $action['id'] = null;
                        $action['landing_id'] = $newId;
                        $table->bind($action);
                        $table->store();
                }
            }
            
            return true;
	}
	
	public function makeCssSafe($data){
	    $pattern = '/(\}*)(\n*.+)(\{{1})/';
	    preg_match_all($pattern, $data, $matches);
	    for($i = 0; $i < count($matches[0]);$i++){
	        if(false === strpos($matches[0][$i], '#MarketingRocket') && false === strpos($matches[0][$i], '@media') && false === strpos($matches[0][$i], '#MR_Modal_View')){
	            $strings = explode(',', trim($matches[0][$i]));
	            foreach ($strings as $key => $val){
	                if(substr($val, 0,1) == '}')
	                {
	                    $val = substr($val , 1);
	                    $val = '#MarketingRocket '.preg_replace('/\s+/', ' ', $val).' ';
	                    $strings[$key] = '} '.$val;
	                }
	                else {
	                    $strings[$key] = '#MarketingRocket '.preg_replace('/\s+/', ' ', $val).' ';
	                }
	            }
	            $data = str_replace($matches[0][$i], implode(',', $strings), $data);
	            // 	                $matches[0][$i] = implode(',', $strings);
	        }
	    }
	    return $data;
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getTemplatesForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();
		
		
		// Get the form.
		$form = $this->loadForm('com_content.article', 'landing', array('control' => 'jform', 'load_data' => false));
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}
	
	public function getForm($data = array(), $loadData = true){
		
		$app = JFactory::getApplication();
		
		// Get the form.
		$form = $this->loadForm('com_marketingrocket.landing_setting', 'landing_setting', array('control' => 'jform', 'load_data' => $loadData));
                
               
                
                $input = JFactory::getApplication()->input;
                
		if (empty($form))
		{
                    return false;
		}
                if($input->getInt('wizard', 0) > 0){
                    $form->removeField('campaign_id');
                    $form->removeField('responder_type');
                    $form->removeField('api_id');
                    $form->removeField('responder_sequence_id');
                }
                
		$app	= JFactory::getApplication();
		$form->setFieldAttribute('seo_title', 'hint', ' - '.$app->getCfg('sitename'));
                
		return $form;
	}
	
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.landing.data', array());
		if (empty($data))
		{
                    $data = $this->getItem();
                    
                    $input = JFactory::getApplication()->input;
                    if($input->getInt('wizard', 0) > 0){
                        $session = JFactory::getSession();
                        $template = $session->get( 'wizard', null, 'com_marketingrocket');
                        $item = $template->items[$input->getInt('wizard', 0)-2];
                        if(!empty($item->formData) && $item->selected_template == $input->getInt('template')){
						  
                            $data = $item->formData;
                        }
                        else {
						    
                            foreach ($item->options as $key => $val){
                                $data->$key = $val;
                            }
                            $data->type = array_search($item->options->type, MarketingrocketHelper::$landingTypes);
                            $data->title = $item->name;
                        }
                       
                    }
					
					
                    if(!empty($data->page_option)){
                        $pageOptions = json_decode($data->page_option);
                        foreach ($pageOptions as $key => $option){
                            $data->$key = $option;
                        }
                    }
                    if(is_object($data)){
                        $data->viewing_tag = json_decode($data->viewing_tag);
                    
                        if($this->_isJson($data->adding_tag))
                        {
                                $data->adding_tag = json_decode($data->adding_tag);
                        }
                        else {
                            $data->adding_tag = array($data->adding_tag);
                        }

                        if($this->_isJson($data->removing_tag))
                            $data->removing_tag = json_decode($data->removing_tag);
                         else 
                            $data->removing_tag = array($data->removing_tag);
                         
                         if($this->_isJson($data->responder_sequence_id))
                            $data->responder_sequence_id = json_decode($data->responder_sequence_id);
                         else 
                            $data->responder_sequence_id = array($data->responder_sequence_id);
                         
                         $safeName = 'form-style-type';
                         
                         $data->$safeName = isset($data->selected_form_style) ? $data->selected_form_style : '';
                         
                    }
                    else {
                        $data['viewing_tag'] = @json_decode($data['viewing_tag']);
                    
                        if(isset($data['adding_tag']) && $this->_isJson($data['adding_tag']))
                            $data['adding_tag'] = json_decode($data['adding_tag']);
                        else if(isset($data['adding_tag']))
                            $data['adding_tag'] = array($data['adding_tag']);

                        if(isset($data['removing_tag']) && $this->_isJson($data['removing_tag']))
                            $data['removing_tag'] = json_decode($data['removing_tag']);
                         else if(isset($data['removing_tag']))
                            $data['removing_tag'] = array($data['removing_tag']);
                         
                          if($this->_isJson($data['responder_sequence_id']))
                            $data['responder_sequence_id'] = json_decode($data['responder_sequence_id']);
                         else 
                            $data['responder_sequence_id'] = array($data['responder_sequence_id']);
                         
                         $data['form-style-type'] = $data['selected_form_style'];
                    }
                  
		}
                $data = $this->publicLoadFormData($data);
				
				//print_r($data); die;
                 if(empty($data['exit_popup_modal_editor'])){
                       $data['exit_popup_modal_editor'] = '<div class="MR-ELEMENTS " id="MR_Exit_View_Holder">
    <div class="container-fluid added-element" id="">
        <div class="row-fluid" id="MR_aPvAnK">
            <div class="col-md-12 span12 sortable preview" id="MR_Exit_View">
                <div class="container-fluid">
                    <div id="MR_atNhOT" class="row-fluid droppable ui-droppable">
                        <a data-original-title="Row Setting" class="MR_Admin hasTooltip btn-mini btn">
                            <i class="fa fa-gear">
                      </i>
                        </a>
                    </div>
                    <a data-original-title="Section Setting" class="MR_Admin hasTooltip btn-mini btn btn-primary">
                        <i class="fa fa-gear"></i>
                    </a>
                    <a data-original-title="Remove Section" class="MR_remove btn-mini btn hasTooltip btn-primary">
                        <i class="fa fa-times"></i>
                    </a>
                    <a data-original-title="Move Up" class="MR_SORT_UP hasTooltip btn-mini btn btn-primary">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <a data-original-title="Move Down" class="MR_SORT_DOWN btn-mini btn hasTooltip btn-primary">
                        <i class="fa fa-chevron-down"></i>
                    </a> 
                </div>
            </div>
        </div> <a data-original-title="Page Settings" class="MR_Admin hasTooltip btn-mini btn btn-primary"><i class="fa fa-gear"></i></a></div>
</div>';
                   }
                self::$formData = $data;
		return $data;
	}
        
        public function getFormData(){
            return $this->loadFormData();
        }
        
        public function publicLoadFormData($data){
            $templateData = $this->getTemplate();
            $data = json_decode(json_encode($data), true);
			 
            if(empty($data['form_json'])){
                if(!empty($templateData['form']))
                        $data['form_json'] = $templateData['form'];
                else  {
                        $data['form_json'] = '[
                  {
                    "label": "'.JText::_('COM_MARKETINGROCKET_FIRST_NAME', true).'",
                    "field_type": "text",
                    "required": true,
                    "field_options": {},
                    "cid": "c1",
                    "name" : "first-name"
                  },
                  {
                    "label": "'.JText::_('COM_MARKETINGROCKET_EMAIL', true).'",
                    "field_type": "email",
                    "required": true,
                    "field_options": {},
                    "cid": "c10",
                    "cantdelete" : true,
                    "name" : "email"
                  }
                ]';
                }

            }
			
			$fieldarray = json_decode($data['form_json']);
			$captchkey = '';
			if($fieldarray){
			  foreach($fieldarray as $key=>$row){
			    if($row->field_type=='recaptcha'){
				  $captchkey = $row->label;
				}
			  }
			}
			// echo "<pre>";
			//  print_r($fieldarray); die;
            if(empty($data['page_editor'])){
                    $data['page_editor'] = $templateData['html'];
            }
            if(empty($data['modal_editor'])){
                    $data['modal_editor'] = $templateData['modal_html'];
					$data['modal_editor'] = str_replace('Your-Site-Key', $captchkey, $data['modal_editor']);
            }
            if(empty($data['exit_popup_modal_editor'])){
                    $data['exit_popup_modal_editor'] = $templateData['exit_modal_html'];
            }
            if(empty($data['css'])){
                    $data['css'] = $templateData['css'];
            }
            
            if(empty($data['javascript'])){
                    $data['javascript'] = $templateData['javascript'];
            }
            
            if(empty($data['page_option'])){
                    $data['page_option'] = ($templateData['page_option']);
                    if(!empty($data['page_option'])){
                        $pageOptions = json_decode($data['page_option']);
                        foreach ($pageOptions as $key => $option){
                            $data[$key] = $option;
                        }
                    }
            }

            if(empty($data['hidden_css'])){
                    $data['hidden_css'] = $templateData['hidden_css'];
            }
            return $data;
        }
	public function getMenuUrl(){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select(array('a.path', 'a.home'))
		->from($db->quoteName('#__menu').' AS a')
		->join('INNER', '#__extensions AS b ON a.component_id = b.extension_id')
		->where('b.name = "com_marketingrocket" and a.published = 1')
		->where('a.link = '.$db->q('index.php?option=com_marketingrocket&view=seo'))
                ->where('( '.$db->qn('a.language') .' = '.$db->q(JFactory::getLanguage()->get('tag')).' OR '.$db->qn('a.language').' = '.$db->q('*').' )')
                ->order($db->qn('language'). ' DESC')
		;
		$db->setQuery($query);
		return $db->loadAssoc();
	}
	public function getTemplate(){
	  
		$app		= JFactory::getApplication();
		$templateId = $app->input->getInt('template', 1);
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select(array('*'))
		->from($db->quoteName('#__mrocket_landing_templates'))
		->where('id = '.$templateId)
		;
		$db->setQuery($query);
		$data =  $db->loadAssoc();
	
		return $data;
			
	}
        
	public function validate($form, $data, $group = null)
	{
		if($data['is_split'] == 1){
			$form->setFieldAttribute('alias', 'required', 'true');
		}
		if($data['form_or_cta'] == 'form')
			$data['form_name'] = $data['title'];
		
		if(!empty($data['have_paypal'])){
			$form->setFieldAttribute('price', 'required', 'true');
			$form->setFieldAttribute('paypal_account', 'required', 'true');
                        $form->setFieldAttribute('paypal_product_name', 'required', 'true');
		}
                

		$ret = parent::validate($form, $data,$group);	
                if($ret !== false){
                    JLoader::import('joomla.plugin.helper');
                    JPluginHelper::importPlugin('marketingrocket');
                    JPluginHelper::importPlugin('system');
                    JPluginHelper::importPlugin('user');
                    $dispatcher = JDispatcher::getInstance();
                    $dispatcher->trigger('onLandingFormValidate', array(&$ret, $form, &$data) );
                }
                return $ret;
	}
	public function getTemplates(){
		
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select(array('*'))
		->from($db->quoteName('#__mrocket_landing_templates'))
		;
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	public function getButtonSettingForm(){
	    // Get the form.
	    $form = $this->loadForm('com_marketingrocket.button_setting', 'button_setting', array('control' => 'jform', 'load_data' => false));
	    if (empty($form))
	    {
	        return false;
	    }
	    
	    return $form;
	}
        
        public function getIconSettingForm(){
            $form = $this->loadForm('com_marketingrocket.icon_setting', 'icon_setting', array('control' => 'jform', 'load_data' => false));
	    if (empty($form))
	    {
	        return false;
	    }
	    
	    return $form;
        }
        
        public function getTimerSettingForm(){
            $form = $this->loadForm('com_marketingrocket.timer_setting', 'timer_setting', array('control' => 'jform', 'load_data' => false));
	    if (empty($form))
	    {
	        return false;
	    }
	    
	    return $form;
        }
        
        public function dynamicList(&$options, $element, $form){
            
            $fieldName = (string)$element->attributes()->name;
            
            if($fieldName == 'after_filling'){
                $input = JFactory::getApplication()->input;
                if($input->getInt('wizard', 0) == 0)
                        unset($options['wizard']);
            }
            else if($fieldName == 'load_fonts'){
                $json = file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS.'fonts.json');
                
                $json = json_decode($json);
                
                $options['google'] = array( 'text' => '-- Google Fonts --', 'disabled' => true , 'requires' => '', 'class' => '', 'onclick' => '', 'value' => 'google');
                
                foreach ($json->items as $row){
                    $options['google-'.$row->family] = array( 'text' => $row->family, 'disabled' => false , 'requires' => '', 'class' => '', 'onclick' => '', 'value' => 'google-'.$row->family);
                }
                
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                JPluginHelper::importPlugin('system');
                JPluginHelper::importPlugin('user');
                $dispatcher = JDispatcher::getInstance();
                $dispatcher->trigger('onLoadFontListCreation', array(&$options, $form) );
            }
            else if($fieldName == 'font-family' || $fieldName == 'button-font-family'){
                $id = JFactory::getApplication()->input->getInt('id');
                if(empty($id))
                    return;
                $item = $this->getItem($id);
                $landingOptions = json_decode($item->page_option);
                if(!is_array($landingOptions->load_fonts))
                    return;
                foreach ($landingOptions->load_fonts as $font){
                    
                    $font = preg_replace('/\w+-{1}/', '', $font);
                    
                    $options[$font] = array( 'text' => $font, 'disabled' => false , 'requires' => '', 'class' => '', 'onclick' => '', 'value' => $font);
                }
            }
        }
	
        
        private function _isJson($string) {
            return is_array(json_decode($string,true));
        }
        
        public function getLastTempId(){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('id')->from('#__mrocket_temp')->where('save_type = "preview"');
            $db->setQuery($q);
            
            return (int)$db->loadResult();
        }
        
        public function resetstat($pks)
	{
            $pks = (array) $pks;
            $db = $this->getDbo();
            try {
                $db->transactionStart();
                
                // Access checks.
                foreach ($pks as $i => $pk)
                {
                    $q = $db->getQuery(true);
                    $q->update($db->qn('#__mrocket_leads'))
                            ->set($db->qn('landing_id') .' = 0')
                            ->where($db->qn('landing_id') .' = '.$db->q($pk))
                            ;
                    $db->setQuery($q);
                    $db->execute();
                    
                    $q = $db->getQuery(true);
                    $q->delete($db->qn('#__mrocket_daily_stat'))
                            ->where($db->qn('landing_id') .' = '.$db->q($pk))
                            ;
                    $db->setQuery($q);
                    $db->execute();
                    
                }
                
                $db->transactionCommit();
            }
            catch (Exception $e){
                $db->transactionRollback();
                throw new Exception($e);
            }
            
        }
        
        public function getLastAutoSave(){
            $id = JFactory::getApplication()->input->getInt('id');
            
            $table = $this->getTable('Temp');
            $table->load(array('landing_id' => $id, 'save_type' => 'auto'));
            
            if(!empty($table->id)){
                return $table;
            }
            return false;
            
        }
        
        public function getLandingList(){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select(
                array(
                    $db->qn('a.alias'),
                    'CONCAT('.$db->qn('a.title').'," (",'.$db->qn('b.name').',") ") AS full_title',
                )
            )
            ->from($db->qn('#__mrocket_landings', 'a'))
            ->innerJoin($db->qn('#__mrocket_campaign', 'b').' ON a.campaign_id = b.id')
            ;
            $db->setQuery($q);
            $res = $db->loadObjectList();
            
            $array = array();
            foreach ($res as $row){
                $array[$row->alias] = $row->full_title;
            }
            return $array;
            
        }
        
	




}
