<?php
/**
 * @package     Joomla.Libraries
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

/**
 * Form Field class for the Joomla CMS.
 * Provides a modal media selector including upload mechanism
 *
 * @since  1.6
 */
class JFormFieldKcfile extends JFormField
{
	protected $type = 'Kcfile';
        
	protected static $initialised = false;
        
        protected $directory;
        
        protected $link;

	/**
	 * Method to get certain otherwise inaccessible properties from the form field object.
	 *
	 * @param   string  $name  The property name for which to the the value.
	 *
	 * @return  mixed  The property value or null.
	 *
	 * @since   3.2
	 */
	public function __get($name)
	{
		switch ($name)
		{
			case 'link':
			case 'directory':
				return $this->$name;
		}

		return parent::__get($name);
	}
	public function __set($name, $value)
	{
		switch ($name)
		{
			case 'link':
			case 'directory':
				$this->$name = (string) $value;
				break;
			default:
				parent::__set($name, $value);
		}
	}

	public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		$result = parent::setup($element, $value, $group);

		if ($result == true)
		{
			$this->link          = (string) $this->element['link'];
			$this->directory     = (string) $this->element['directory'];
		}

		return $result;
	}

	/**
	 * Method to get the field input markup for a media selector.
	 * Use attributes to identify specific created_by and asset_id fields
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.6
	 */
	protected function getInput()
	{
		if (!self::$initialised)
		{
			// Include jQuery
			JHtml::_('jquery.framework');

			// Build the script.
			$script = 'function openKCFinder_singleFile(el) {
    window.KCFinder = {};
    window.KCFinder.el = jQuery(el).prev();
    window.KCFinder.callBack = function(url) {
        window.KCFinder.el.val(url);
        window.KCFinder.el.keyup();
        window.KCFinder = null;
    };
    window.open(\''.$this->link.'\', \'kcfinder_single\', \'status=0, toolbar=0, location=0, menubar=0,directories=0, resizable=1, scrollbars=0, width=800, height=600\');
}
 ';
                        JFactory::getDocument()->addScriptDeclaration($script);

			self::$initialised = true;
		}

		$html = array();
		$attr = '';

		// Initialize some field attributes.
		$attr .= !empty($this->class) ? ' class="input-small ' . $this->class . '"' : ' class="input-small"';
		$attr .= !empty($this->size) ? ' size="' . $this->size . '"' : '';

		// The text field.
		$html[] = '<div class="input-prepend input-append">';

		$html[] = '	<input type="text" name="' . $this->name . '" id="' . $this->id . '" value="'
			. htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '" readonly="readonly"' . $attr . ' />';

		// The button.
		if ($this->disabled != true)
		{
			JHtml::_('bootstrap.tooltip');

			$html[] = '<a class="btn" title="' . JText::_('JLIB_FORM_BUTTON_SELECT') . '" onclick="openKCFinder_singleFile(this)">';
			$html[] = JText::_('JLIB_FORM_BUTTON_SELECT') . '</a><a class="btn hasTooltip" title="'
				. JText::_('JLIB_FORM_BUTTON_CLEAR') . '" href="#" onclick="';
			$html[] = 'jInsertFieldValue(\'\', \'' . $this->id . '\');jQuery(this).prev().prev().keyup()';
			$html[] = 'return false;';
			$html[] = '">';
			$html[] = '<span class="icon-remove"></span></a>';
		}

		$html[] = '</div>';

		return implode("\n", $html);
	}
}
