<?php
/**
 * @package     Joomla.Platform
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

/**
 * Form Field class for the Joomla Platform.
 * Supports a generic list of options.
 *
 * @since  11.1
 */
require_once JPATH_LIBRARIES.DS.'joomla'.DS.'form'.DS.'fields'.DS.'list.php';

class JFormFieldDynamiclist extends JFormFieldList
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  11.1
	 */
	protected $type = 'List';
        
        protected $model;
        protected $prefix;
        
        
        public function __get($name)
	{
            switch ($name)
            {
                case 'model':
                case 'prefix':
                    return $this->$name;
            }

            return parent::__get($name);
	}
        
        public function __set($name, $value)
	{
            switch ($name)
            {
                    case 'model':
                    case 'prefix':
                        $this->$name = (string) $value;
                        break;
                    default:
                        parent::__set($name, $value);
            }
	}
        
        public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		$return = parent::setup($element, $value, $group);

		if ($return)
		{
			$this->model   = $this->element['model'] ? (string) $this->element['model'] : '';
			$this->prefix = $this->element['prefix'] ? (string) $this->element['prefix'] : '';
		}

		return $return;
	}
        

	protected function getOptions()
	{
            $fieldOptions = array();
            foreach ($this->element->children() as $option){
                if ($option->getName() != 'option')
                {
                    continue;
                }
                $rowArray = array('text' =>  trim((string) $option), 'disabled' => false, 'requires' => '', 'class' => '', 'onclick' => '');
                foreach ($option->attributes() as $key => $val){
                    $rowArray[$key] = (string) $val;
                }
                $fieldOptions[$rowArray['value']] = $rowArray;
            }
            
            $model = JModelLegacy::getInstance($this->model, $this->prefix , array('ignore_request' => true));
            if(method_exists($model, 'dynamicList')){
                $model->dynamicList($fieldOptions, $this->element, $this->form);
            }
            JLoader::import('joomla.plugin.helper');
            JPluginHelper::importPlugin('marketingrocket');
            JPluginHelper::importPlugin('system');
            JPluginHelper::importPlugin('user');
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onDynamicList', array(&$fieldOptions, $this->model, $this->prefix, $this->element, &$this->form) );
            
            
            foreach ($fieldOptions as $option){
                // Filter requirements
                if ($requires = explode(',', (string) @$option['requires']))
                {
                        // Requires multilanguage
                        if (in_array('multilanguage', $requires) && !JLanguageMultilang::isEnabled())
                        {
                                continue;
                        }

                        // Requires associations
                        if (in_array('associations', $requires) && !JLanguageAssociations::isEnabled())
                        {
                                continue;
                        }
                }
                
//                $type =

                $value =  $option['value'];

                $disabled = @$option['disabled'];
                $disabled = ($disabled == 'true' || $disabled == 'disabled' || $disabled == '1');

                $disabled = $disabled || ($this->readonly && $value != $this->value);

                // Create a new option object based on the <option /> element.
                $tmp = JHtml::_(
                        'select.option', $value,
                        JText::alt($option['text'], preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)), 'value', 'text',
                        $disabled
                );

                // Set some option attributes.
                $tmp->class = (string) @$option['class'];

                // Set some JavaScript option attributes.
                $tmp->onclick = (string) @$option['onclick'];

                // Add the option object to the result set.
                $options[] = $tmp;
            }
            reset($options);
            return $options;
	}
}
