<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelCampaigns extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'created',
				'name', 'a.name',
				'category' , 'category_title', 'a.created', 'cnt'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);


		// Load the parameters.
		$params = JComponentHelper::getParams('com_marketingrocket');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.id', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id	A prefix for the store id.
	 * @return  string  A store id.
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');

		$id .= ':' . $this->getState('filter.state');


		return parent::getStoreId($id);
	}
	public function delete($pk = null)
	{
		$result = parent::delete($pk);
		return $result && $this->tagsHelper->deleteTagData($this, $pk);
	}
	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.id, a.name,a.created'
			)
		);
		$query->from($db->quoteName('#__mrocket_campaign').' AS a');

		// Join over the users for the checked out user.
		$query->select('uc.name AS editor');
		$query->join('LEFT', $db->quoteName('#__users').' AS uc ON uc.id=a.created_by');
		
		// Join over the categories.
		$query->select('c.title AS category_title');
		$query->join('LEFT', $db->quoteName('#__categories').' AS c ON c.id = a.cat_id');
		
		$query->select('COUNT(d.lead_id) as cnt');
		$query->join('LEFT', $db->quoteName('#__mrocket_lead_campaigns').' AS d ON a.id = d.campaign_id');
		
		$query->group('a.id');
		
		// Implement View Level Access
// 		if (!$user->authorise('core.admin'))
// 		{
// 			$groups	= implode(',', $user->getAuthorisedViewLevels());
// 			$query->where('a.access IN ('.$groups.')');
// 		}

		



		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.')');
			}
		}
                
                $catId = $this->getState('filter.cat_id');
                if(!empty($catId)){
                    $query->where('a.cat_id = '.$db->q($catId));
                }
                    


		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));

		return $query;
	}
	public function getCampaignList(){
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$query->select(array('*'))
		->from($db->quoteName('#__mrocket_campaign'))
		
// 		->where('b.name = "com_marketingrocket" and a.published = 1')
		;
		$db->setQuery($query);
		return $db->loadAssocList('id', 'name');
	}
	public function getLandingsList(){
		$app		= JFactory::getApplication();
		$key = 'id';
		$getList = $app->input->get('get', false);
		if($getList == 'landingalias')
			$key = 'alias';
		$id = $app->input->get('campaing_id', 0);
		$currentId = $app->input->get('landing_id', 0); 
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
			
		$nullDate	= $db->quote($db->getNullDate());
		$nowDate	= $db->quote(JFactory::getDate()->toSql());
			
		$query->select(array('*'))
		->from($db->quoteName('#__mrocket_landings'))
                    ->where('published = 1')
                    ->where('id != '.$currentId)
		;
                
                if(!empty($id))
                    $query->where('campaign_id = '.$id);
                
		$db->setQuery($query);
		return $db->loadAssocList($key, 'title');
	}
	public function getRespondersList($type = "" , $id = 0){
        $db		= $this->getDbo();
        $query	= $db->getQuery(true);

        $query->select('*')
        ->from($db->quoteName('#__mrocket_reponders_sequences'));
        if(!empty($id))
            $query->where('campaign_id = '.$id.' AND published = 1');


        $db->setQuery($query);
        return $db->loadAssocList('id', 'name');

	}
}
