<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class MarketingrocketModelApi extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MARKETINGROCKET';

    private $plugin = null;
        
        public $apiType = '';

	public function getTable($type = 'Api', $prefix = 'MarketingrocketTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array  $data		An optional array of data for the form to interogate.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$app = JFactory::getApplication();
        $type = $app->input->get('type');
        if(empty($type) && !empty($_POST)){
            $type = $_POST['jform']['type'];
        }


        if(empty($type)){
            $row = $this->getItem();
             $type = $row->type;
             if(empty($type))
                 return false;
        }





        $this->apiType = $type;


        JLoader::import('joomla.plugin.helper');
        JPluginHelper::importPlugin('marketingrocket');
        JPluginHelper::importPlugin('system');
        JPluginHelper::importPlugin('user');
        JPluginHelper::importPlugin('breezingforms_addons');
        $this->setPlugin($type);
        $dispatcher = JEventDispatcher::getInstance();
        $dispatcher->trigger('onBeforeFormLoad', array(&$type) );

		// Get the form.
		$form = $this->loadForm('com_marketingrocket.api', 'api_'.$type, array('control' => 'jform', 'load_data' => $loadData));
                
        $dispatcher->trigger('onAfterFormLoad', array(&$type, &$form, $loadData) );
		if (empty($form))
		{
            return false;
		}


		return $form;
	}

	private function setPlugin($type){
	    if($this->plugin === null){

            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->select($db->qn('plugin'))
                ->from($db->qn('#__mrocket_api_types'))
                ->where($db->qn('type').' = '.$db->q($type))
            ;
            $db->setQuery($q);

            $rowType = $db->loadResult();

            $plugin = explode('_', $rowType);

            $this->plugin = $plugin[1];
        }

        if(!empty($this->plugin)){
            JPluginHelper::importPlugin($this->plugin);
        }
    }

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.api.data', array());
                JFactory::getApplication()->setUserState('com_marketingrocket.edit.api.data', array());
                
              
		if (empty($data))
		{
                    $data = $this->getItem();
                    if(!empty($data->id)){
                        $registry = new Registry;
                
                        $registry->loadObject($data);
                        $data = $registry->toArray();
                    }
                    else 
                        $data = array();
                   
		}
                $type = false;
                if(!empty($data['type'])){
                    $type = $data['type'];
                }
                if(empty($type))
                     $type = JFactory::getApplication()->input->get('type', '');
                 
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                JPluginHelper::importPlugin('system');
                JPluginHelper::importPlugin('user');
                $this->setPlugin($type);
                $dispatcher = JEventDispatcher::getInstance();
                $dispatcher->trigger('onApiLoadFormData', array(&$type, &$data) );

		return $data;
	}
        public function validate($form, $data, $group = null)
	{
            $ret = parent::validate($form, $data, $group);
            if($ret !== false){
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                JPluginHelper::importPlugin('system');
                JPluginHelper::importPlugin('user');
                $this->setPlugin('');
                $dispatcher = JEventDispatcher::getInstance();
                $dispatcher->trigger('onApiFormValidate', array(&$ret, $form, &$data) );
            }
            return $ret;
        }
        
        public function save($data) {
            //set transistion
            $db = JFactory::getDbo();
            $oldData = array();
            
            if(!empty($data['id'])){
                $oldData = $this->getItem($data['id']);
                
            }
            
            
            $newData = $data;
            $readyForSaveData = array('id' => $data['id'], 'title' => $data['title'], 'type' => $data['type']);
            unset($newData['id']);
            unset($newData['params']);
            $readyForSaveData['params'] = json_encode($newData);

            try {
                $db->transactionStart();
                $ret = parent::save($readyForSaveData);
                if($ret === true){
                    
                    $id = $this->getState($this->getName() . '.id', '0');
                    
                    $type = $data['type'];
                    JLoader::import('joomla.plugin.helper');
                    JPluginHelper::importPlugin('marketingrocket');
                    JPluginHelper::importPlugin('system');
                    JPluginHelper::importPlugin('user');
                    $this->setPlugin($type);
                    $dispatcher = JEventDispatcher::getInstance();
                    $dispatcher->trigger('afterApiSaveForm', array(&$type, $data, $oldData, $id) );
                }


                $db->transactionCommit();
            }
            catch (Exception $e){
                $db->transactionRollback();
                $this->setError($e->getMessage());
                return false;
            }

            return $ret;
        }
        
        public function delete(&$pks) {
            $db = $this->getDbo();
            try {
                $db->transactionStart();
                
                foreach ($pks as $pk){
                    $item = $this->getItem($pk);
                    $type = $item->type;
                    JLoader::import('joomla.plugin.helper');
                    JPluginHelper::importPlugin('marketingrocket');
                    JPluginHelper::importPlugin('system');
                    JPluginHelper::importPlugin('user');
                    $this->setPlugin($type);
                    $dispatcher = JEventDispatcher::getInstance();
                    $dispatcher->trigger('onDeleteApi', array(&$type, $item) );
                }
                
                $db->transactionCommit();
            }
            catch (Exception $e){
                $db->transactionRollback();
                $this->setError($e->getMessage());
                return false;
            }
            
            
           return parent::delete($pks);
        }
        
        /*
         * Overide the row fields with params that inserted in params field
         */
        
        public function getItem($pk = null)
	{
            $row = parent::getItem($pk);
            
            if(!empty($row->params)){
               foreach ($row->params as $key => $val){
                   $row->$key = $val;
                } 
            }
            
            return $row;
        }

        public function getItemRecursiveDecodde($pk = null){
            $row = parent::getItem($pk);

            if(!empty($row->params)){
                foreach ($row->params as $key => $val){
                    if(self::isJson($val))
                        $row->$key = json_decode($val);
                    else
                        $row->$key = $val;
                }
            }

            return $row;
        }

        public static function isJson($string) {
            @json_decode($string);
            return (json_last_error() == JSON_ERROR_NONE);
        }
        
        public function getItemsByType($type){
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            $query->select('*')->from('#__mrocket_api')->where('type ='.$db->q($type));
            $db->setQuery($query);
            return $db->loadObjectList();
            
        }
        
        public function getItemByType($type){
            $table = $this->getTable();
            $table->load(array('type' => $type));
            if(empty($table->id))
                return false;
            return $this->getItem($table->id);
        }
        
        
}
