<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelAction extends JModelAdmin
{
    /**
     * @var		string	The prefix to use with controller messages.
     * @since   1.6
     */
    protected $text_prefix = 'COM_MARKETINGROCKET';

    public function getTable($type = 'Action', $prefix = 'MarketingrocketTable', $config = array())
    {
            return JTable::getInstance($type, $prefix, $config);
    }

    public function getForm($data = array(), $loadData = true) {
        
    }
    
    public function getActiveActions(){
        $db = $this->getDbo();
        $q = $db->getQuery(true);
        
        
        $nullDate	= $db->quote($db->getNullDate());
        $nowDate	= $db->quote(JFactory::getDate('now', JFactory::getConfig()->get('offset'))->toSql(true));
        
        $q->select('b.*')->from($db->qn('#__mrocket_action_item', 'a'))
                ->innerJoin($db->qn('#__mrocket_actions', 'b').' ON '.$db->qn('a.id').' = '.$db->qn('b.landing_id').' AND '.$db->qn('b.type').' = '.$db->q('tag_action'))
                ->where($db->qn('published').' = 1')
                ->where('(a.publish_up = '.$nullDate.' OR a.publish_up <= '.$nowDate.')')
                ->where('(a.publish_down = '.$nullDate.' OR a.publish_down >= '.$nowDate.')')
                ;
        
        $db->setQuery($q);
        return $db->loadObjectList();
    }
    
    public function getItems($id = null, $type = 'landing_action'){
        
        $input = JFactory::getApplication()->input;
        if(empty($id)){
            if($input->getString('view') == 'action'){
                $id = $input->getInt('landing_id');
                $type = 'landing_action';
            }
            else {
//                $id = $input->getInt('id');
                $type = 'tag_action';
            }
        }
        
        
        if(empty($id) && $type == 'landing_action')
            return array();
        
        $db = $this->getDbo();
        $q = $db->getQuery(true);
        
        
        $q->select('*')->from('#__mrocket_actions')
                ->where($db->qn('type').' = '.$db->q($type))
                ->order($db->qn('order').' ASC');
        
        if($id !== null){
            $q->where('landing_id = '.$id);
        }
        
        $db->setQuery($q);
        
        return $db->loadAssocList();
    }
    public function getResponderApiList(){
        $db = $this->getDbo();
        $q = $db->getQuery(true);

        $q = "select a.type,a.title from #__mrocket_api_types AS a 
                            INNER JOIN #__mrocket_api AS b ON a.type = b.type WHERE a.category = 'email_responder' GROUP BY a.title";
        $db->setQuery($q);
        
        $list = array('0' => array('type' => 'default', 'title' => 'Default Auto Responder'));
        $list = array_merge($list,  $db->loadAssocList('type', 'title'));
        return $list;
    }
    
    public function getTagsList(){
        $db		= JFactory::getDbo();
        $query	= $db->getQuery(true);
        $query->select(array('id,title'))
        ->from($db->quoteName('#__mrocket_tags'));
        $db->setQuery($query);
        return $db->loadAssocList();
    }

}
