<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketHelper
{
    
    public static $landingTypes = array(
                    1 => 'COM_MARKETINGROCKET_SQUEEZE_PAGE',
                    2 => 'COM_MARKETINGROCKET_CONTENT_PAGE',
                    3 => 'COM_MARKETINGROCKET_SALES_PAGE',
                    4 => 'COM_MARKETINGROCKET_CHECKOUT_PAGE',
                    5 => 'COM_MARKETINGROCKET_SPECIAL_OFFER_PAGE',
                    6 => 'COM_MARKETINGROCKET_THANKYOU_PAGE'
            );


    public static $labelMap = null;
    
	public static function addSubmenu($vName = 'dashboard')
	{
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_DASHBOARD' ),
		'index.php?option=com_marketingrocket', 
		$vName == 'dashboard');
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_WIZARD' ),
		'index.php?option=com_marketingrocket&view=wizard',
		$vName == 'wizard' );
		
		JHtmlSidebar::addEntry ( JText::_ ('COM_MARKETINGROCKET_CAMPAIGNS' ),
		'index.php?option=com_marketingrocket&view=campaigns',
		$vName == 'campaigns');
		
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_CAMPAIGNS_CATEGGORIES' ), 
        'index.php?option=com_categories&extension=com_marketingrocket',
        $vName == 'categories' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_CAMPAIGN_VISUALISER' ),
		'index.php?option=com_marketingrocket&view=visualiser',
		$vName == 'visualiser' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_CAMPAIGNS_RESPONDERS' ),
		'index.php?option=com_marketingrocket&view=responders',
		$vName == 'responders' );
		
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_SEQUENCES' ),
		'index.php?option=com_marketingrocket&view=sequences',
		$vName == 'sequences' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_MANAGER_QUEUEDS' ),
		'index.php?option=com_marketingrocket&view=queueds',
		$vName == 'queueds' );
		
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_LANDINGS' ),
		'index.php?option=com_marketingrocket&view=landings',
		$vName == 'landings' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_LEADS_MANAGER' ),
		'index.php?option=com_marketingrocket&view=leads',
		$vName == 'leads' );
		
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_LEADS_TAGS' ),
		'index.php?option=com_marketingrocket&view=tags',
		$vName == 'tags' );
		
		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_LEADS_STATUSES' ),
		'index.php?option=com_marketingrocket&view=statuses',
		$vName == 'statuses' );

		JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_REPORTS' ),
		'index.php?option=com_marketingrocket&view=reports',
		$vName == 'reports' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_APILIST' ),
		'index.php?option=com_marketingrocket&view=apilist',
		$vName == 'apilist' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_WEBINARS' ),
		'index.php?option=com_marketingrocket&view=webinars',
		$vName == 'webinars' );
                
        JHtmlSidebar::addEntry ( JText::_ ( 'COM_MARKETINGROCKET_MANAGE_LOGIC' ),
		'index.php?option=com_marketingrocket&view=logics',
		$vName == 'logics' );
                
          //      if($vName == 'categories'){
          //          if(!defined('DS'))
          //              define('DS', DIRECTORY_SEPARATOR);
          //          $videoText = 'Campaign Categories';
          //          $videoId = 'j_W9A1OXtdc?rel=0';
          //          $videoImg = 'components/com_marketingrocket/assets/images/videos/categories.png';
          //          require JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'views'.DS.'_common'.DS.'edit_video_modal.php';
          //      }
		

	}
	public static function getActions($categoryId = 0)
	{
		$user	= JFactory::getUser();
		$result	= new JObject;
		$assetName = null;

		$actions = JAccess::getActions('com_marketingrocket');

		foreach ($actions as $action)
		{
			$result->set($action->name,	$user->authorise($action->name, $assetName));
		}

		return $result;
	}
	public static function videoHelper($vName){
		switch ($vName){
			case 'dashboard':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/dashboard.png', 'videoId' => 'BWPxXP3q6uE?rel=0', 'text' => 'Introducing the Dashboard');
			case 'wizard':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/campaign-wizard.png', 'videoId' => '2qgvb--eLWc?rel=0', 'text' => 'Using the Campaign Wizard');
			case 'campaigns':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/campaigns.png', 'videoId' => 'wKJp7H5WIyw?rel=0', 'text' => 'Starting your First Campaign');
			case 'categories':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/campaigns.png', 'videoId' => 'wKJp7H5WIyw?rel=0', 'text' => 'Starting your First Campaign');
			case 'responders':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/responders.png', 'videoId' => '3MlmHWS7aaI?rel=0', 'text' => 'Auto Responders & Email Nurturing');
			case 'sequences' :
				return array('img' => 'components/com_marketingrocket/assets/images/videos/responders.png', 'videoId' => '3MlmHWS7aaI?rel=0', 'text' => 'Auto Responders & Email Nurturing');
			case 'tags':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/leads.png', 'videoId' => 'utevVyXnoeo?rel=0', 'text' => 'Lead Tags & Lead Management');
			case 'statuses':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/leads.png', 'videoId' => 'utevVyXnoeo?rel=0', 'text' => 'Lead Status & Lead Management');
			case 'visualiser':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/visualiser.png', 'videoId' => 'YaVRvuCcG68?rel=0', 'text' => 'Visualising your Campaigns');
			case 'apilist':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/apilist.png', 'videoId' => 'YaVRvuCcG68?rel=0', 'text' => 'Visualising your Campaigns');
			case 'queueds':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/queueds.png', 'videoId' => 'YaVRvuCcG68?rel=0', 'text' => 'Visualising your Campaigns');
			case 'landings':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/landings.png', 'videoId' => '35kTjtPko-Q?rel=0', 'text' => 'How to use the Landing Page Creator');
			case 'leads':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/leads.png', 'videoId' => 'utevVyXnoeo?rel=0', 'text' => 'Lite CRM & Lead Management');
			case 'reports':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/reports.png', 'videoId' => 'KJrYoAqIcIE?rel=0', 'text' => 'Reporting & Stats');
			case 'landing':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/landings.png', 'videoId' => '35kTjtPko-Q?rel=0', 'text' => 'How to use the Landing Page Creator');
			case 'webinars':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/webinars.png', 'videoId' => 'eqVvJuH7fFc?rel=0', 'text' => 'Creating Webinars using Marketing Rocket');
			case 'logics':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/logics.png', 'videoId' => '6KwYOhVWQWI?rel=0', 'text' => 'Webinars');
            case 'dashborad':
				return array('img' => 'components/com_marketingrocket/assets/images/videos/dashboard.png', 'videoId' => 'BWPxXP3q6uE?rel=0', 'text' => 'Introducing the Dashboard');
            default:
				return array('img' => 'components/com_marketingrocket/assets/images/videos/default.png', 'videoId' => '6KwYOhVWQWI?rel=0', 'text' => 'Getting Started with Marketing Rocket');
		}
	}
        public static function log($object, $type, $log , $lead_id = 0, $target_id = 0, $table = null){
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
            $row = JTable::getInstance('Log', 'MarketingrocketTable');
            $row->object = $object;
            $row->type = $type;
            $row->log = $log;
            $row->lead_id = $lead_id;
            $row->target_id = $target_id;
            $row->table = $table;
            $res = $row->store();
            if($res){
                $convert = false;
                if($row->object == 'status' && $row->type == 'add'){
                    $statusTable = JTable::getInstance('Status', 'MarketingrocketTable');
                    $statusTable->load($target_id);
                    if($statusTable->final)
                        $convert = true;
                }
                
                
                self::calculateWarmMetter($lead_id, $convert);
                return $row->id;
            }
            return false;
        }
        
        /**
         * Calculate Lead Warmth Meter 
         * @param int $leadId
         * @param bool $convert
         * @param bool $force , if set to true , will recalulate from start 
         */
        public static function calculateWarmMetter($leadId, $convert = false, $force = false){
            if(!defined('DS'))
                define('DS', DIRECTORY_SEPARATOR);
            
            
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'tables');
            
            $lead = JTable::getInstance('Lead' ,'MarketingrocketTable');
            $lead->load($leadId);
            if(empty($lead->id))
                return;
            
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_logs'))
                    ->where($db->qn('lead_id').' = '.$db->q($leadId))
                    ->where($db->qn('object').' IN ('.implode(',', $db->q(array('responder', 'landing', 'form'))).')')
                    
                ;
            if($force == false)
                $q->where($db->qn('id').' > '.$db->q($lead->w_last_log_id));
            
            $db->setQuery($q); 
            $logs = $db->loadObjectList(); 
            
            $dom = new DOMDocument();
            $dom->load(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'config.xml');
            $xpath = new DOMXpath($dom);
            
            
            
            $defaults = array();
            
            $parent = $xpath->query('//*[@name="warmth_metter"]');
            $xmlFields = $parent->item(0)->getElementsByTagName('field');
            
            foreach ($xmlFields as $element){
                $xmlFieldName = $element->getAttribute('name');
                $defaults[$xmlFieldName] = $element->getAttribute('default');
                
            }
            
            $score = 0;
            if($force == false)
                $score = $lead->w_metter;
            
            $params = JComponentHelper::getParams('com_marketingrocket');  
            $lastLog = null;
            foreach ($logs as $row){
                $key = 'wm_'.$row->object.'_'.$row->type;
                if(!isset($defaults[$key]))
                    $defaults[$key] = false;
                $value = $params->get($key, $defaults[$key]);
            
                if(empty($value))
                    continue;
                $score = $score+$value;
                
                $lastLog = $row;
            }
            if($convert || ($force && $lead->isConverted())){
                $key = 'wm_status_convert';
                
                $value = $params->get($key, false);
                $score = $score+$value;
            }
           
            $functionConvert = false; // need to mark lead as convert ?
            
            if(!$lead->isConverted()){
                self::getLabelOfWarmth($score);
                foreach (self::$labelMap as $row){ // check to see if number is enouph for convert
                    if($score >= $row->from && $score <= $row->to && $row->convert){
                        $functionConvert = true;
                    }
                }
            }
            
            
            $lead->w_metter = $score;
            if(isset($lastLog->id))
                $lead->w_last_log_id = (int)$lastLog->id;
            $lead->store();
            
            if($functionConvert)
                $lead->convert();
            
        }
        public static function getLabelOfWarmth($value){
            $value = min(array($value, 100));
            if(self::$labelMap == null){
                
                if(!defined('DS'))
                    define('DS', DIRECTORY_SEPARATOR);
                
                $dom = new DOMDocument();
                $dom->load(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'config.xml');
                $xpath = new DOMXpath($dom);
                $elements = $xpath->query('//*[@name="wm_levels"]');
                $levelDefaults = $elements->item(0)->getAttribute('default');
                $levelDefaults = str_replace("'", '"', $levelDefaults);
               
                
                $params = JComponentHelper::getParams('com_marketingrocket');  
                $levels = $params->get('wm_levels', $levelDefaults);
                $levels = json_decode($levels, true);
                if(empty($levels)){
                    $levels = str_replace("'", '"', $params->get('wm_levels'));
                    $levels = json_decode($levels, true);
                }
                 
                $levelArray = array();
                foreach ($levels['name'] as $key => $row){

                    $obj = new stdClass();
                    $obj->from = $levels['from'][$key];
                    $obj->to = $levels['to'][$key];
                    $obj->name = $row;
                    $obj->convert = (boolean) $levels['convert'][$key];

                    if(empty($row) || empty($obj->to))
                        continue;
                    
                    

                    $levelArray[] = $obj;
                }
                
                function cmp($a, $b)
                {
                    return strcmp((int)$a->from, (int)$b->from);
                }

                usort($levelArray, "cmp");
                
                if(empty($levelArray))
                    $levelArray = array();
                
                self::$labelMap = $levelArray;
            }
            
            foreach (self::$labelMap as $row){
                if($value >= $row->from && $value <= $row->to){
                    return $row->name;
                }
            }
            return '';
            
        }
        
        public static function getVersion(){
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query->select('manifest_cache')->from('#__extensions')->where('element = "pkg_marketingrocket"');

            $db->setQuery($query);
            $res = $db->loadResult();

            $versionNumber= json_decode($res);
            $versionNumber= $versionNumber->version;
            return $versionNumber;
        }
        
        public static function sendSystemMessage($title, $message){
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'tables');
            
            $messageTable = JTable::getInstance('Messages' ,'MarketingrocketTable');
            
            $messageTable->title = $title;
            $messageTable->description = $message;
            $messageTable->is_system = 1;
            $messageTable->published = 1;
            $messageTable->store();
            
            return $messageTable->id;
            
            
        }

        public static function checkDownloadId($downloadId, $return = false){
            // Do some validation
            $urlPatch = JUri::getInstance();
            $domain = $urlPatch->getHost();
            $domain = str_replace('www.', '', $domain);

            $content = @file_get_contents('https://marketing-rocket.com/index.php?option=com_mrmangement&task=check_id&download_id='.$downloadId.'&rand='.md5(time()).'&domain='.$domain);
            $content = @json_decode($content);
            if(isset($content->success)){
                if($content->success === false){
                    $app = JFactory::getApplication();
                    $app->enqueueMessage($content->message, 'error');
                    if($return)
                        return false;
                }
            }
            else
                return false;



            $db = JFactory::getDBO();
            $query = $db->getQuery(true);

            $query->update('#__update_sites');
            $query->set('location = ' . $db->quote('https://marketing-rocket.com/mr-update?file=package.xml&dlid='.$downloadId.'&domain='.$domain));
            $query->where('name = "MarketingRocket Update Server"');

            // Execute the query
            $db->setQuery($query);
            $db->execute();

            $params = JComponentHelper::getParams('com_marketingrocket');
            $params->set('download_id', $downloadId);
            $params->set('save_download_id', $downloadId);


            $params->set('last_download_id_check', time());


            $query = $db->getQuery(true);
            // Build the query
            $query->update('#__extensions AS a');
            $query->set('a.params = ' . $db->quote((string)$params));
            $query->where('a.element = "com_marketingrocket"');

            // Execute the query
            $db->setQuery($query);
            $db->execute();

            return true;
        }

}
