<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerWizard extends JControllerForm
{

	protected $view_list = 'wizard';


    public function start(){
        $templateName = $this->input->getString('template');
        $model = $this->getModel();

        $template = $model->getTemplate($templateName.'.xml');
        $template->lastStep = 1;
        $template->campaign_desc = '';
        $template->campaign_catid = 0;
        $template->canDone = false;
        $template->position = 0;

        $session = JFactory::getSession();
        $session->set( 'wizard', $template, 'com_marketingrocket');
        $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));
    }
    public function debug(){
        $session = JFactory::getSession();
        $template = $session->get('wizard', false, 'com_marketingrocket');
        if($this->input->getInt('step', 0) > 0)
                Zend_Debug::dump($template->items[$this->input->getInt('step', 0)-2]);
        else 
            Zend_Debug::dump($template);

        die;
    }
    public function nextstep(){
        
        if(JSession::checkToken() == false){
            echo new JResponseJson(array(), JText::_('JINVALID_TOKEN'),true);
            die;
        }
        $names = MarketingrocketHelper::$landingTypes;

        $data  = $this->input->post->get('jform', array(), 'array');
        $model = $this->getModel();
        $form = $model->getForm($data, false);
        $validData = $model->validate($form, $data);
        if(empty($validData)){
            echo new JResponseJson(array(), $model->getError(0, false)->getMessage(),true);
            die;
        }
        $session = JFactory::getSession();
        $template = $session->get('wizard', false, 'com_marketingrocket');
        if(empty($template))
        {
             echo new JResponseJson(array(), 'Session Expired',true);
             die;
        }

        if($validData['step'] == 1){

            $template->title = $validData['name'];
            $template->campaign_desc = $validData['desc'];
            $template->campaign_catid = $validData['cat_id'];
            $template->lastStep = 2;
            $session->set( 'wizard', $template, 'com_marketingrocket');


             echo new JResponseJson(array('next_step' => 2));
             die;

        }
        else {
            $step = $validData['step']-2;
            $template->position = $step;
            $template->items[$step]->done = true;

            if($template->items[$step]->type == 'landing'){
               if(
                       empty($template->items[$step]->formData) ||
                       (!empty($template->items[$step]->selected_template) && $template->items[$step]->selected_template != $validData['selected_template'])){
                   $template->items[$step]->formData = array();
                   $dataArray = array();
                   if(!empty($template->items[$step]->options->alias)){
                       $dataArray['alias'] = $template->items[$step]->options->alias;
                   }
                   else if(!empty($template->items[$step]->options->seo_title)){
                       $dataArray['seo_title'] = $template->items[$step]->options->seo_title;
                   }
                   else {
                       $dataArray['title'] = $validData['name'];
                   }

                   $template->items[$step]->alias = $this->_genAlias($dataArray);
               }
               $template->items[$step]->selected_template = $validData['selected_template'];
               $template->items[$step]->name = $validData['name'];
               $template->items[$step]->body = $validData['body'];
               $template->items[$step]->modal = $validData['modal'];
               $template->items[$step]->hidden_css = $validData['hidden_css'];

               $template->items[$step]->css = $validData['css'];



            }
            else if($template->items[$step]->type == 'responder'){
                $template->items[$step]->responder_type = $validData['responder_type'];
                if($validData['responder_type'] == 'default'){

                    $template->items[$step]->sequence_name = $validData['sequence_name'];
                    $template->items[$step]->from_name = $validData['from_name'];
                    $template->items[$step]->from_email = $validData['from_email'];

                    $template->items[$step]->adding_tag_before = $validData['adding_tag_before'];

                    $template->items[$step]->add_to_existing_lead = $validData['add_to_existing_lead'];
                    $template->items[$step]->add_to_recieved_before = $validData['add_to_recieved_before'];

                    $template->items[$step]->send_to_tags_if = $validData['send_to_tags_if'];
                    $template->items[$step]->send_to_tags = (!empty($validData['send_to_tags'])) ? json_encode($validData['send_to_tags'][0]) : '';
                    $template->items[$step]->dont_send_to_tags_if = $validData['dont_send_to_tags_if'];
                    $template->items[$step]->dont_send_to_tags = (!empty($validData['dont_send_to_tags'])) ? json_encode($validData['dont_send_to_tags'][0]) : '';

                    $template->items[$step]->adding_tag = $validData['adding_tag'];

                    $template->items[$step]->adding_tag_end = $validData['adding_tag_end'];
                    $template->items[$step]->remove_tag_end = $validData['remove_tag_end'];



//                    $key = 0;
//                    foreach ($validData['templates'] as $key => $selectedTemplate){
//                        if(empty($selectedTemplate)){
//                            echo new JResponseJson(array(), 'Please Select Template For All Responders', true);
//                            die;
//                        }
//
//                        if(!isset($template->items[$step]->options->days->day[$key]))
//                            $template->items[$step]->options->days->day[$key] = new stdClass();
//
//                        $title = $validData['titles'][$key];
//
//                        $template->items[$step]->options->days->day[$key]->title = $title;
//                        $template->items[$step]->options->days->day[$key]->subject = $validData['subjects'][$key];
//                        $template->items[$step]->options->days->day[$key]->selected_template = $selectedTemplate;
//                        $template->items[$step]->options->days->day[$key]->email_text = $validData['emailtext'][$key];
//
//                    }

                    // remove additional days
//                    $key++;
//                    while(isset($template->items[$step]->options->days->day[$key])){
//                        unset($template->items[$step]->options->days->day[$key]);
//                        $key++;
//                    }

                }
                else {
                    $template->items[$step]->api_id = $validData['api_id'];
                    $template->items[$step]->responder_sequence_id = $validData['responder_sequence_id'];
                }



            }
            else {
                $template->items[$step]->responder_type = $validData['responder_type'];

                foreach ($validData['templates'] as $key => $selectedTemplate){
                    if(empty($selectedTemplate)){
                        echo new JResponseJson(array(), 'Please Select Template For All Responders', true);
                        die;
                    }

                    $title = $validData['titles'][$key];

                    $template->items[$step]->options->days->day[$key]->title = $title;
                    $template->items[$step]->options->days->day[$key]->subject = $validData['subjects'][$key];
                    $template->items[$step]->options->days->day[$key]->selected_template = $selectedTemplate;
                    $template->items[$step]->options->days->day[$key]->email_text = $validData['emailtext'][$key];

                }
            }



            if(JFactory::getApplication()->input->post->getInt('reload', 0) == 0){
                $template->lastStep++;
            }
            $template->canDone = false;
            if(!isset($template->items[$template->lastStep-1])){

                $canDone = true;
                foreach ($template->items as $item) {
                    if(empty($item->done))
                        $canDone = false;
                }

                $template->canDone = $canDone;
            }
            if(JFactory::getApplication()->input->post->getInt('done', 0) == 1 && $template->canDone = true){

                try {
                    $db = JFactory::getDbo();
                    $db->transactionStart();

                    $campaignTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                    $data = array('name' => $template->title, 'cat_id' => $template->campaign_catid, 'desc' => $template->campaign_desc);
                    $campaignTable->bind($data);
                    $campaignTable->check();
                    $campaignTable->store();
                    $template->items = array_reverse($template->items);
                    $lastLandingId = 0;
                    $lastLandingAlias = '';
                    $resondersIds = array();
                    foreach ($template->items as $key => $item){
                        if($item->type == 'landing'){
                            $landingTable = JTable::getInstance('Landing', 'MarketingrocketTable');
                            $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
                            if(empty($item->formData)){

                                $type = array_search($item->options->type, $names);

                                $data = array(
                                    'title' => $item->name,
                                    'published' => 1,
                                    'type' => $type,
                                    'public_accsess' => 1,
                                    'responder_type' => 0,
                                    'form_or_cta' => 'form',
                                    'page_html' => $item->body,
                                    'modal_body' => $item->modal
                                );
                                
                                if($key == 0){ // last landing
                                    $data['form_or_cta'] = 'none';
                                }
                                
                                $this->input->set('template', $item->selected_template);
                                $data = $landingModel->publicLoadFormData($data);

                                foreach ($item->options as $optionKey => $val){
                                    if($optionKey == 'type')
                                        continue;
                                    $data[$optionKey] = $val;
                                }

                                $data['hidden_css'] = $item->hidden_css;
                                $data['css'] = $item->css;

                            }
                            else {
                                $data = $item->formData;
                                if(!empty($data['exit_popup'])){
                                    $data['page_option']['exit_popup'] = $data['exit_popup'];

                                    $data['page_option']['exit_popup_size'] = $data['exit_popup_size'];
                                    $data['page_option']['exit_popup_delay'] = $data['exit_popup_delay'];
                                    $data['page_option']['exit_popup_cookie'] = $data['exit_popup_cookie'];
                                }
                            }
                            $prevItem = @$template->items[$key-1];
                            if(!empty($prevItem) && $prevItem->type != 'landing'){
                                if($prevItem->responder_type == 'default'){
                                    $data['responder_type'] = 'default';
                                    if(!empty($resondersIds))
                                        $data['responder_sequence_id'] = json_encode($resondersIds);
                                    else
                                        $data['responder_sequence_id'] = 0;

                                }
                                else {
                                    $data['responder_type'] = 'mail_chimp';
                                    $data['api_id'] = $prevItem->api_id;
                                    if(!empty($resondersIds))
                                        $data['responder_sequence_id'] = json_encode($resondersIds);
                                    else
                                        $data['responder_sequence_id'] = 0;
                                }

                                $resondersIds = array();
                            }

                            if(empty($data['after_filling']) || $data['after_filling'] == 'wizard')
                                $data['after_filling'] = 'to_landing_page';

                            $data['campaign_id'] = $campaignTable->id;
                            if(empty($data['to_landing_page']) || in_array($data['after_filling'], array('wizard', 'to_landing_page')))
                                $data['to_landing_page'] = $lastLandingId;

                            if(empty($data['alias']))
                                $data['alias'] = $item->alias;

                            $landingTable->bind($data);
//                            $landingTable->check(); // this causing problem for splits
                            $landingTable->store();
                            $lastLandingId = $landingTable->id;
                            $lastLandingAlias = $landingTable->alias;

                            if(!empty($item->options->actions)){
                                foreach ($item->options->actions as $action){
                                    $table = JTable::getInstance('Action', 'MarketingrocketTable');
                                    $action->landing_id = $lastLandingId;
                                    $table->bind($action);
                                    $table->store();
                                }
                            }

                        }
                        else {
                            if($item->responder_type == 'default'){
                                if($item->type == 'responder'){
                                    $sequnceTable = JTable::getInstance('Sequence', 'MarketingrocketTable');
                                    $data = array(
                                        'name' => $item->sequence_name,
                                        'campaign_id' => $campaignTable->id,
                                        'published' => 1,
                                        'add_to_existing_lead' => $item->add_to_existing_lead,
                                        'send_to_tags_if' => $item->send_to_tags_if,
                                        'send_to_tags' => $item->send_to_tags,
                                        'dont_send_to_tags_if' => $item->dont_send_to_tags_if,
                                        'dont_send_to_tags' => $item->dont_send_to_tags,
                                        'adding_tag' => $item->adding_tag,
                                        'add_to_recieved_before' => $item->add_to_recieved_before,
                                        'from_name' => $item->from_name,
                                        'from_email' => $item->from_email,
                                    );
                                    $sequnceTable->bind($data);
                                    $sequnceTable->store();

                                    $resondersIds[] = $sequnceTable->id;
                                }
                                $daysIds = array();
                                foreach ($item->options->days->day as $dayKey => $day){
                                    if(empty($day))
                                        continue;
                                    $responderModel = $this->getModel('Responder', 'MarketingrocketModel');
                                    $data = array(
                                            'name' => $day->title,
                                            'subject' => $day->subject,
                                            'from_name' => @$item->from_name,
                                            'from_email' => @$item->from_email,
                                            'send_type' => 'after',
                                            'send_after_day' => $day->count,
                                            'send_after_hour' => 0,
                                            'send_after_minute' => 0,
                                            'body' => @$day->email_text,
                                            'type' => 'responder',
                                            'published' => 1
                                        );
                                    if($item->type == 'responder'){
                                        $data['sequence_id'] = $sequnceTable->id;
                                    }
                                    else {
                                        $data['type'] = 'marketing';
                                    }
                                    if(!empty($day->formData)){
                                        if($item->type == 'responder'){
                                            $data['name'] = @$day->formData['name'];
                                            $data['subject'] = @$day->formData['subject'];
                                            $data['second_subject'] = @$day->formData['second_subject'];
                                            
                                            $data['send_type'] = @$day->formData['send_type'];
                                            $data['send_after_day'] = @$day->formData['send_after_day'];
                                            $data['send_after_hour'] = @$day->formData['send_after_hour'];
                                            $data['send_after_minute'] = @$day->formData['send_after_minute'];
                                            
                                            $data['send_on_date'] = @$day->formData['send_on_date'];
                                            $data['webinar_id'] = @$day->formData['webinar_id'];
                                            $data['send_before_hour'] = @$day->formData['send_before_hour'];
                                            $data['send_before_day'] = @$day->formData['send_before_day'];
                                            $data['split_id'] = @$day->formData['split_id'];
                                        }
                                        $data['body'] = @$day->formData['body'];
                                    }
                                    
                                    if(!empty($data['split_id'])){
                                        $splitId = $data['split_id']-1;
                                        if(!empty($daysIds[$splitId]))
                                            $data['split_id'] = $daysIds[$splitId];
                                        else 
                                            $data['split_id'] = 0;
                                    }

                                    if(strpos($data['body'], '{landing-link=%wizard%}') !== false){
                                        $pattern = '/({landing-link=%wizard%}{1})(.*[^{\/landing-link}]+)({\/landing-link}{1})/';
                                        preg_match_all($pattern, $data['body'], $matches);

                                        foreach ($matches[0] as $k => $match){
                                            $count = 1;
                                            $data['body'] = str_replace('{landing-link=%wizard%}', '{landing-link='.$lastLandingAlias.'}', $data['body'], $count);
//
                                        }


                                    }
                                    $responderModel->save($data);
                                    $daysIds[$dayKey] = $responderModel->getState('responder.id');
                                    if(!empty($day->attachments)){
                                        foreach ($day->attachments as $attach){
                                            $attachMentTable = JTable::getInstance('Responderattachment', 'MarketingrocketTable');
                                            $attachMentTable->responder_id = $responderModel->getState('responder.id');
                                            $attachMentTable->file_name = $attach->tempName;
                                            $attachMentTable->orginal_file_name = $attach->orginal_file_name;
                                            $attachMentTable->size = $attach->size;
                                            $attachMentTable->store();
                                        }
                                    }

                                    if($item->type == 'start'){
                                        $campaignTable->responder_id = $responderModel->getState('responder.id');
                                        $campaignTable->store();
                                    }

                                }

                            }
                            else {
                                $resondersIds[] = $item->responder_sequence_id;
                            }
                        }
                    }

                    $db->transactionCommit();
                }
                catch (Exception $e){
                    $db->transactionRollback();
                }

//
//                Zend_Debug::dump($template);
//                die;
                $session->clear('wizard', 'com_marketingrocket');

                echo new JResponseJson(array('done' => true, 'campaing_id' => $campaignTable->id));
                die;
            }

            $session->set( 'wizard', $template, 'com_marketingrocket');

            echo new JResponseJson(array('next_step' => $template->lastStep));
            die;
        }


        die('sd');
    }

    public function applylanding(){
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

        $data  = $this->input->post->get('jform', array(), 'array');
        $app = JFactory::getApplication();
        $wizardId = $app->input->post->getInt('wizard');

        $model = JModelLegacy::getInstance('landing', 'MarketingrocketModel', array('ignore_request' => true));

        $form = $model->getForm($data, false);
        $validData = $model->validate($form, $data);
        if ($validData === false)
        {
                // Get the validation messages.
                $errors = $model->getErrors();

                // Push up to three validation messages out to the user.
                for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
                {
                        if ($errors[$i] instanceof Exception)
                        {
                                $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
                        }
                        else
                        {
                                $app->enqueueMessage($errors[$i], 'warning');
                        }
                }

                // Save the data in the session.
                $app->setUserState('com_marketingrocket.edit.landing.data', $data);

                // Redirect back to the edit screen.
                $this->setRedirect(
                        JRoute::_(
                                'index.php?option=com_marketingrocket&view=landing&layout=edit&id=0&wizard='.$wizardId.'&template='.$app->input->getInt('template'), false
                        )
                );

                return false;
        }

        if($validData['is_split'] == 0)
            $validData['alias'] = $this->_genAlias($validData);

        $app->setUserState('com_marketingrocket.edit.landing.data', array());
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $template->items[$wizardId-2]->selected_template = $app->input->getInt('template');
        $template->items[$wizardId-2]->name = $validData['title'];
        $template->items[$wizardId-2]->formData = $validData;
        $template->items[$wizardId-2]->alias = $validData['alias'];

        $names = MarketingrocketHelper::$landingTypes;
        
        $template->items[$wizardId-2]->options->type = $names[$validData['type']];
        $session->set( 'wizard', $template, 'com_marketingrocket');
        $app->enqueueMessage('Saved');
        $this->setRedirect(
                JRoute::_(
                        'index.php?option=com_marketingrocket&view=wizard&step=1', false
                )
        );

        return true;

    }

    private function _genAlias($validData){
         if(empty($validData['alias'])){
                if(!empty($validData['seo_title']))
                        $validData['alias'] = $validData['seo_title'];
                else
                        $validData['alias'] = $validData['title'];
        }
        $validData['alias'] = JApplication::stringURLSafe($validData['alias']);


        // check for user limitaion


        // check that alias is not taken
        $i = '';
        $alias = $validData['alias'];

        $db = JFactory::getDbo();

        do {
                $validData['alias'] = $alias.$i;
                $query = 'SELECT id FROM #__mrocket_landings WHERE alias = '.$db->q($validData['alias']);
                if(empty($i))
                        $i = 0;
                $i = $i+1;
                $db->setQuery($query);

                $xid = (int) $db->loadResult();
        }while ($xid);

        return $validData['alias'];
    }

    public function applyresponder(){
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

        $data  = $this->input->post->get('jform', array(), 'array');
        $app = JFactory::getApplication();
        $wizardId = $app->input->post->getInt('wizard');
        $day = $app->input->post->getInt('day');

        $model = JModelLegacy::getInstance('responder', 'MarketingrocketModel', array('ignore_request' => true));

        $form = $model->getForm($data, false);
        $validData = $model->validate($form, $data);
        if ($validData === false)
        {
                // Get the validation messages.
                $errors = $model->getErrors();

                // Push up to three validation messages out to the user.
                for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
                {
                        if ($errors[$i] instanceof Exception)
                        {
                                $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
                        }
                        else
                        {
                                $app->enqueueMessage($errors[$i], 'warning');
                        }
                }

                // Save the data in the session.
                $app->setUserState('com_marketingrocket.edit.responder.data', $data);

                // Redirect back to the edit screen.
                $this->setRedirect(
                        JRoute::_(
                                'index.php?option=com_marketingrocket&view=responder&layout=edit&tmpl=component&id=0&wizard='.$wizardId.'&day='.$day.'&template='.$app->input->getInt('template'), false
                        )
                );

                return false;
        }
        $app->setUserState('com_marketingrocket.edit.responder.data', array());
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');

        $template->items[$wizardId-2]->options->days->day[$day]->selected_template = $app->input->getInt('template');
        $template->items[$wizardId-2]->options->days->day[$day]->formData = $validData;
        $template->items[$wizardId-2]->options->days->day[$day]->edited = true;
        
        if(!empty($_FILES['attachment'])){
            $totalSize = 0;
            if(!empty($template->items[$wizardId-2]->options->days->day[$day]->attachments)){
                foreach ($template->items[$wizardId-2]->options->days->day[$day]->attachments as $attach){
                    $totalSize += $attach->size;
                }
            }
            $maxAttachment = 2000000;
            foreach ($_FILES['attachment']['name'] as $key => $file){
                if(empty($file))
                    continue;
                $path = pathinfo($file);
                if(!in_array($path['extension'], array('docx', 'doc', 'xls', 'xlsx', 'ppt', 'pptx', 'jpg', 'png', 'gif' , 'pdf'))){
                    $this->setError(sprintf(JText::_('COM_MARKETINGROCKET_EXTENSION_NOT_ALLOWED'), $path['extension']));
                    $ret = false;
                    break;
                }
                $totalSize += $_FILES['attachment']['size'][$key];
                if($totalSize > $maxAttachment){
                    $this->setError(JText::_('COM_MARKETINGROCKET_MAXIMUM_SIZE_ERROR'));
                    $ret = false;
                    break;
                }
                $tempName = md5(uniqid().time());
                $uploaded = move_uploaded_file(
                        $_FILES['attachment']['tmp_name'][$key],
                        JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                        DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$tempName);
                if($uploaded){
                    
                    
                    if(!isset($template->items[$wizardId-2]->options->days->day[$day]->attachments))
                        $template->items[$wizardId-2]->options->days->day[$day]->attachments = array();
                    
                    $obj = new stdClass();
                    $obj->tempName = $tempName;
                    $obj->size = $_FILES['attachment']['size'][$key];
                    $obj->orginal_file_name = $file;
                    
                    $template->items[$wizardId-2]->options->days->day[$day]->attachments[] = $obj;
                    
                }
            }
        }
        
        
        
        $session->set( 'wizard', $template, 'com_marketingrocket');
        $app->enqueueMessage('Saved');
        $this->setRedirect(
                JRoute::_(
                        'index.php?option=com_marketingrocket&view=responder&layout=edit&tmpl=component&id=0&wizard='.$wizardId.'&day='.$day.'&template='.$app->input->getInt('template'), false
                )
        );
        return true;
    }
    public function cancel($key = null){
        $this->setRedirect(
                JRoute::_(
                        'index.php?option=com_marketingrocket&view=wizard&step=1', false
                )
        );
        return true;
    }
    public function template(){
        $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
        $template = $landingModel->getTemplate();
        echo new JResponseJson(array('body' => $template['html'], 'modal' => $template['modal_html'], 'hidden_css' => $template['hidden_css'], 'css' => $template['css']));
        die;
    }
    public function done(){

        JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_WIZARD_SUCCESS'));
        $this->setRedirect(
                JRoute::_(
                        'index.php?option=com_marketingrocket&view=visualiser&id='.$this->input->getInt('id'), false
                )
        );
        return true;

    }
    public function custom(){
        $template = new stdClass();
        $template->name = 'custom';
        $template->title = 'Custom Campaign';
        $template->desc = '';
        $template->landingCount = 1;


        $obj = new stdClass();
        $obj->type = 'landing';
        $obj->name = '';

        $obj->options = new stdClass();
        $obj->options->type = 'COM_MARKETINGROCKET_SQUEEZE_PAGE';
        $template->items = array($obj);

        $template->lastStep = 1;
        $template->campaign_desc = '';
        $template->campaign_catid = 0;
        $template->canDone = false;
        $template->position = 0;

        $session = JFactory::getSession();
        $session->set( 'wizard', $template, 'com_marketingrocket');

        $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));
    }
    public function addpage(){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $obj = new stdClass();
        $obj->type = 'landing';
        $obj->name = '';
        $obj->options = new stdClass();
        $obj->options->type = 'COM_MARKETINGROCKET_SQUEEZE_PAGE';


        $template->items = $this->_insert($template->items, $this->input->getInt('position'), $obj);
        $template->landingCount++;
        $session->set( 'wizard', $template, 'com_marketingrocket');
         $template->canDone = false;

        $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));

        return true;

    }
    public function addresponder(){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');

        // check prev item
//        if($template->items[$this->input->getInt('position')-1]->type != 'landing')
//            return false;
//        if(isset($template->items[$this->input->getInt('position')]) && $template->items[$this->input->getInt('position')]->type == 'responder')
//            return false;

        $obj = new stdClass();
        $obj->type = 'responder';
        $obj->name = '';
        $obj->options = new stdClass();
        $obj->options->days = new stdClass();
        $obj->options->days->day = array();
        $day = new stdClass();
        $day->count = 0;
        $obj->options->days->day[] = $day;

        $template->items = $this->_insert($template->items, $this->input->getInt('position'), $obj);
//        $template->landingCount++;
        $session->set( 'wizard', $template, 'com_marketingrocket');
        $template->canDone = false;

        $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));

        return true;
    }
    private function _insert($array, $index, $val)
    {
        $temp = array();
        $size = count($array);
        if (!is_int($index) || $index < 0 || $index > $size)
        {
            return -1;
        }
        else
        {
            $temp   = array_slice($array, 0, $index);
            $temp[] = $val;
            return array_merge($temp, array_slice($array, $index, $size));
        }
    }

    public function deletestep(){
//        Zend_Debug::dump($this->input->getInt('step'));

        $step = $this->input->getInt('step')-2;
        $this->_deleteSection($step);

        $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));
        return true;
    }
    private function _deleteSection($step, $alsoDelete = true){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        
        if($template->items[$step]->type == 'responder'){
            foreach ($template->items[$step]->options->days->day as $day){
                if(!empty($day->attachments))
                {
                    foreach ($day->attachments as $attach){
                        $tempName = JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                            DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attach->tempName;
                        unlink($tempName);
                    }
                }
            }
        }
        
        array_splice($template->items, $step, 1);

        if($alsoDelete){
            while(isset($template->items[$step]) && $template->items[$step]->type != 'landing' &&
                (!isset($template->items[$step-1]) || $template->items[$step-1]->type != 'landing')
                ){
                array_splice($template->items, $step, 1);
            }
        }


        $session->set( 'wizard', $template, 'com_marketingrocket');
    }

    public function alias(){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $wizard = $this->input->getInt('wizard')-2;
        $list = array();
        foreach ($template->items as $key => $item){
            if($item->type == 'landing' && $key != $wizard && !empty($item->alias)){
                $list[$item->alias] = $item->name;
            }
        }

        echo json_encode($list);
        die;
    }
    public function unmark(){
        $wizardId = $this->input->post->getInt('step');
        $day = $this->input->post->getInt('day');

        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
//        Zend_Debug::dump($template->items[$wizardId-2]->options->days->day[$day]->edited) ;
        $template->items[$wizardId-2]->options->days->day[$day]->edited = false;
        $session->set( 'wizard', $template, 'com_marketingrocket');
//        Zend_Debug::dump($template->items[$wizardId-2]->options->days->day[$day]->edited) ;
        die('ok');
    }

    public function import(){
        // Check for request forgeries.
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

        $app = JFactory::getApplication();

        if(!empty($_FILES['file'])){
            $pathinfo = pathinfo($_FILES['file']['name']);
            if($pathinfo['extension'] != 'xml'){
                 $app->enqueueMessage('File Format Is Wrong', 'error');
                 $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item, false
                    )
                 );
                return false;
            }

            $name = $pathinfo['basename'];
            $path = JPATH_SITE.DS.'media'.DS.'com_marketingrocket'.DS.'wizard'.DS;
            if(file_exists($path.$name)){
                unlink($path.$name);
            }
            move_uploaded_file($_FILES['file']['tmp_name'], $path.$name);

            $app->enqueueMessage('File Imported Successfully', 'message');
            $this->setRedirect(
                JRoute::_(
                    'index.php?option=' . $this->option . '&view=' . $this->view_item.'&template='.$pathinfo['filename'], false
                )
             );

            return true;
        }

        return false;
    }

    public function changeorder(){
        $step = $this->input->getInt('step', 0);
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $item = $template->items[$step];
        $this->_deleteSection($step, false);

        if($this->input->get('type') == 'up'){
            $position = $step-1;
        }
        else
            $position = $step+1;

        $template->items = $this->_insert($template->items, $position, $item);
        $session->set( 'wizard', $template, 'com_marketingrocket');

         $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1' , false));

        return true;
    }
    
    public function removemail(){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $step = $this->input->post->getInt('step')-2;
        $email = $this->input->post->getInt('email');
        if($template->items[$step]->type == 'responder'){
            
            if(!empty($template->items[$step]->options->days->day[$email]->attachments)){
                foreach ($template->items[$step]->options->days->day[$email]->attachments as $attach){
                    $tempName = JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                        DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attach->tempName;
                    unlink($tempName);
                }
            }
            
            $template->items[$step]->options->days->day[$email] = false;
        }
        
        $session->set( 'wizard', $template, 'com_marketingrocket');
        
        die('ok');
    }
    
    public function addemail(){
        $session = JFactory::getSession();
        $template = $session->get( 'wizard', null, 'com_marketingrocket');
        $step = $this->input->post->getInt('step')-2;
        if($template->items[$step]->type == 'responder'){
            $obj = new stdClass();
            $obj->count = 0;
            $obj->title = '';
            $obj->subject = '';
            $obj->selected_template = '';
            $template->items[$step]->options->days->day[] = $obj;
        }
//        $c = 0;
//        foreach ($template->items[$step]->options->days->day as $day){
//            if(!empty($day))
//                $c++;
//        }
        
        $session->set( 'wizard', $template, 'com_marketingrocket');
        echo new JResponseJson(array('id' => count($template->items[$step]->options->days->day)-1));
        die;
    }
}
