<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');


class MarketingrocketControllerWebinars extends JControllerAdmin
{
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Webinar', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
        
        public function getlist(){
            $db		= JFactory::getDbo();
            $query	= $db->getQuery(true);
            $query->select(array('id,title'))
            ->from($db->quoteName('#__mrocket_webinar'))
            ;
            $db->setQuery($query);
            $list = $db->loadAssocList();
            echo new JResponseJson($list);
	    die;
            
        }
        
        public function delete(){
           
            $session =  JFactory::getSession();
           
            if(empty($session->get('task', false, 'com_marketingrocket'))
                    && empty($session->get('cid', array(), 'com_marketingrocket'))
              ){
                 // Check for request forgeries
                JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
                
                $cid = JFactory::getApplication()->input->get('cid', array(), 'array');
                $session->set('cid',$cid, 'com_marketingrocket');
                $session->set('task','delete', 'com_marketingrocket');
                $session->set('api_id',JFactory::getApplication()->input->get('api'), 'com_marketingrocket');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&task=webinar.auth', false));
            }
            
            $cid = $session->get('cid',$cid, 'com_marketingrocket');
            $session->set('cid',array(), 'com_marketingrocket');
            // Get the model.
            $model = $this->getModel();
            foreach ($cid as $id){
                try {
                     $table = $model->getTable();
                    $table->load($id);
                    $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
                    $apiId = $session->get('api_id', '', 'com_marketingrocket');
                    $apiRow = $apiModel->getItem($apiId);

                     require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.
                                      'com_marketingrocket'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Google'.DIRECTORY_SEPARATOR.'autoload.php';
                    $urlPatch = JUri::getInstance();
                    $client = new Google_Client();
                    $client->setClientId($apiRow->client_id);
                    $client->setClientSecret($apiRow->client_secret);
                    $client->setScopes('https://www.googleapis.com/auth/youtube');
                    $redirect = filter_var(JUri::root().'administrator/index.php?option=com_marketingrocket&task=webinar.auth',
                        FILTER_SANITIZE_URL);
                    $client->setRedirectUri($redirect);

                    $array = array('access_token' => $apiRow->token, 'expires_in' => $apiRow->expire, 'created' => $apiRow->created);
                    $client->setAccessToken(json_encode($array));

                    // Define an object that will be used to make all API requests.
                    $youtube = new Google_Service_YouTube($client);

                    $youtube->liveBroadcasts->delete($table->snipest_id);
                }
                catch (Exception $e){
                     $this->setMessage($e->getMessage());
                }
               
            }
            // Make sure the item ids are integers
            jimport('joomla.utilities.arrayhelper');
            JArrayHelper::toInteger($cid);

            // Remove the items.
            if ($model->delete($cid))
            {
                    $this->setMessage(JText::plural($this->text_prefix . '_N_ITEMS_DELETED', count($cid)));
            }
            else
            {
                    $this->setMessage($model->getError(), 'error');
            }
	
            // Invoke the postDelete method to allow for the child class to access the model.
            $this->postDeleteHook($model, $cid);

            $this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
            
        }

	
}
