<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerWebinar extends JControllerForm
{

	protected $view_list = 'webinars';

        
        public function choose(){
            $app = JFactory::getApplication();
            $context = "$this->option.edit.$this->context";
            // Clear the record edit information from the session.
            $app->setUserState($context . '.data', null);

            // Redirect to the edit screen.
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item.'&layout=choose', false
                    )
            );

            return true;
        }
        protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
		$tmpl   = $this->input->get('tmpl');
		$layout = $this->input->get('layout', 'edit', 'string');
		$append = '';

		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}

		if ($layout)
		{
			$append .= '&layout=' . $layout;
		}

		if ($recordId)
		{
			$append .= '&' . $urlVar . '=' . $recordId;
		}
                $append .= '&api='.$this->input->getInt('api');
		return $append;
	}

        public function auth(){
            
            $urlPatch = JUri::getInstance();
            $session =  JFactory::getSession();
            
            $apiId = $session->get('api_id', '', 'com_marketingrocket');
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
             
            $apiRow = $apiModel->getItem($apiId);
              require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.
                            'com_marketingrocket'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Google'.DIRECTORY_SEPARATOR.'autoload.php';
            
            $client = new Google_Client();
            $client->setClientId($apiRow->client_id);
            $client->setClientSecret($apiRow->client_secret);
            $client->setScopes('https://www.googleapis.com/auth/youtube');
            $redirect = filter_var(JUri::root().'administrator/index.php?option=com_marketingrocket&task=webinar.auth',
                FILTER_SANITIZE_URL);
            $client->setRedirectUri($redirect);
            $code = $this->input->getString('code', '');
            if (!empty($code)) {
                if (strval($session->get('state', '', 'com_marketingrocket')) !== strval($this->input->getString('state', ''))) {
                  die('The session state did not match.');
                }

                $client->authenticate($code);
            }
            if ($client->getAccessToken()) {
                  $task = $session->get('task', 'add', 'com_marketingrocket');
                  $token = json_decode($client->getAccessToken());
                  $data = (array)$apiRow;
                  array_shift($data);
                  $data['token'] = $token->access_token;
                  $data['created'] = $token->created;
                  $data['expire'] = time()+$token->expires_in;
                  $apiModel->save($data);
                  if($task == 'add'){
                      $this->setRedirect(
                            JRoute::_(
                                    'index.php?option=' . $this->option . '&view=' . $this->view_item.'&layout=edit&api='.$apiId.'&id='.$session->get('webinar_id', 0, 'com_marketingrocket'), false
                            ));
                  }
                  else {
                      $session->set('task', false, 'com_marketingrocket');
                      $this->setRedirect(
                            JRoute::_(
                                    'index.php?option=' . $this->option . '&view=' . $this->view_item.'&task=webinars.delete', false
                            ));
                  }
                  

                return true;

            }
            else {
                $state = mt_rand();
                $client->setState($state);
                $session->set('state', $state, 'com_marketingrocket');
                JFactory::getApplication()->redirect($client->createAuthUrl());
            }

        }
	
}
