<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');


class MarketingrocketControllerStatuses extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	

		$this->registerTask('makeUnFinal',	'makeFinal');
	}
	
	
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Status', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
	
	public function makeDefault(){
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$task   = $this->getTask();
		
		$ids    = $this->input->get('cid', array(), 'array');
		
		$model = $this->getModel();
		$model->makeDefault($ids);
		$this->setRedirect('index.php?option=com_marketingrocket&view=statuses');
	}
	public function makeFinal(){
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$ids    = $this->input->get('cid', array(), 'array');
		$values = array('makeFinal' => 1, 'makeUnFinal' => 0);
		$task   = $this->getTask();
		$value  = JArrayHelper::getValue($values, $task, 0, 'int');
		
		$model = $this->getModel();
		$model->makeFinal($ids, $value);
		$this->setRedirect('index.php?option=com_marketingrocket&view=statuses');
	}
        
        public function getlist(){
            $db		= JFactory::getDbo();
            $query	= $db->getQuery(true);
            $query->select(array('id,name as title'))
            ->from($db->quoteName('#__mrocket_statuses'));
            $db->setQuery($query);
//            $list = array('0' => array('id' => 0, 'title' => '-'));
            $list = array();
            $list = array_merge($list,  $db->loadAssocList());
            echo new JResponseJson($list);
	    die;
            
        }

	
}
