<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerResponder extends JControllerForm
{

	protected $view_list = 'responders';
	private $cacheInHook = false;
        
        public function savetemplate(){
            
            // Check for request forgeries
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            
            
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $responderTable = JTable::getInstance('Responder', 'MarketingrocketTable');
            $responderTable->name = $this->input->post->getString('name','');
            $responderTable->subject = $this->input->post->getString('subject', '');            
            $responderTable->body = $this->input->post->get('body', '', 'RAW');
            $responderTable->type = $this->input->post->getString('type', 'template');
            $responderTable->css = $this->input->post->get('css', '', 'RAW');
            $responderTable->editor_body = $this->input->post->get('editor_body', '', 'RAW');
            $responderTable->store();
            
            echo new JResponseJson(true);
            
            
            die;
        }
        
        protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
            
            $ret = parent::getRedirectToItemAppend($recordId,$urlVar);
            $ret .= '&type='.$this->input->getString('type', 'responder');
            return $ret;
	}
        
    public function addempty(){
        // Check for request forgeries
        JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

        $id = $this->input->post->getInt('sequence');

        $model = $this->getModel();
        $table = $model->getTable();

        $table->published = 0;
        $table->sequence_id = $id;
        $table->store();

        echo new JResponseJson($table->id);
        die;

    }

    public function save($key = null, $urlVar = null)
    {

        $data  = $this->input->post->get('jform', array(), 'array');
        if ($data['save_type'] == 'sequence.save2copy')
        {
            $this->cacheInHook = true;
            $this->set('task', 'save2copy');
        }
            return parent::save($key, $urlVar);



    }

    public function postSaveHook(JModelLegacy $model, $validData = array())
    {

        if($this->cacheInHook){
            $id = (array) $model->getState($this->context . '.id');
            $id = $id[0];

            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_responder_attachments'))
                ->where($db->qn('responder_id').' = '.$db->q($id))
            ;
            $db->setQuery($q);
            $attachments = $db->loadAssocList();
            foreach ($attachments as $attachment){
                $attachmentTable = JTable::getInstance('Responderattachment', 'MarketingrocketTable');
                $tempName = md5(uniqid().time());
                $location = JPATH_SITE.DS.'media'.DS.'com_marketingrocket'.DS.'attachments'.DS;
                if(copy($location.$attachment['file_name'], $location.$tempName)){
                    $attachment['id'] = null;
                    $attachment['file_name'] = $tempName;
                    $attachment['responder_id'] = $id;

                    $attachmentTable->save($attachment);
                }
                else {
                    JFactory::getApplication()->enqueueMessage('Cannot Copy Attachment File:'.$attachment['orginal_file_name'], 'errro');
                }

            }


            $session = JFactory::getSession();

            $ids = $session->get('responder_copy', array(), 'MR');
            $ids[] = $id;

            $session->set('responder_copy', $ids, 'MR');
        }

        parent::postSaveHook($model, $validData);
    }


}
