<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerReports extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Reports', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
	
        
        public function export(){
            
            
            // Check for request forgeries
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            
            $model = $this->getModel();
                
            $this->state		= $model->getState();
            $this->list		= $model->getItems();
            
            $list = new stdClass();
            
            $begin = $model->getState('filter.begin');
            $end = $tempEnd = $model->getState('filter.end');
            if(empty($end)){
                    $end = date('Y-m-d');
            }
            $this->stats = $model->getDailyStat($begin, $end);
            $this->convertedCount = $model->getConvertedCount($begin, $end);



            $totalView = 0;
            $totalSubmission = 0;
            foreach ($this->stats as $row){
                    $totalView += $row->visits;
                    $totalSubmission += $row->submissions;
            }
            $this->totalView = $totalView;
            $this->totalSubmission = $totalSubmission;
            
            $hideChart = true;
            
            $showType = 'pdf';
            
             $css = '<!DOCTYPE html>
<html xmlns:fb="http://ogp.me/ns/fb#"  xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-gb" lang="en-gb" dir="ltr">
<head>
	  <meta http-equiv="content-type" content="text/html; charset=utf-8" /><style>'.  file_get_contents(JPATH_COMPONENT.'/assets/css/dashboard.css').'.span2 {width: 200px;float : left}.row-fluid:after {
    clear: both;
} .text-center {text-align:center} .dashboard.row-fluid .dashboard-box {width : 180px} ul {list-style-type : none; margin : 10px 0}
table { width: 100%; } td,th,tr {text-align : left; border-bottom : 1px dotted #6B6B6B}</style></head><body>';
            ob_start();
            include JPATH_COMPONENT.'/views/_common/default_stat.php';
            echo '<div style="clear:both"></div>';
            include JPATH_COMPONENT.'/views/_common/default_toplanding.php';
            $content = ob_get_contents();
            ob_end_clean();
            
            $content = $css.$content.'</body></html>';
            
//            echo $content;
//            die;
//            
//            
            require_once JPATH_LIBRARIES . '/dompdf/dompdf_config.inc.php';
            
            $dompdf = new DOMPDF();
            $dompdf->set_option('enable_css_float', true);
            $dompdf->load_html($content);
            $dompdf->set_paper('a4', 'landscape');
            $dompdf->render();

            $dompdf->stream('MR_Report_'.JHtml::_('date', time(), 'Y_m_d_H_i_s').'.pdf', array("Attachment" => true));
            
            
            die;
            return true;
        }
        
        
        
        
        
        
	
	
		

	
}
