<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerQuicklanding extends JControllerForm
{

        public $foundedImages;
        public $replaceImages;
        
        protected $view_list = 'landings';
        
        
        public function save($key = null, $urlVar = null) {
            // Check for request forgeries.
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $app = JFactory::getApplication();
            
            $model = $this->getModel();
            $data  = $this->input->post->get('jform', array(), 'array');
            
            // Sometimes the form needs some posted data, such as for plugins and modules.
            $form = $model->getForm($data, false);

            if (!$form)
            {
                    $app->enqueueMessage($model->getError(), 'error');

                    return false;
            }
            // Test whether the data is valid.
            $validData = $model->validate($form, $data);

            // Check for validation errors.
            if ($validData === false)
            {
                // Get the validation messages.
                $errors = $model->getErrors();

                // Push up to three validation messages out to the user.
                for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
                {
                        if ($errors[$i] instanceof Exception)
                        {
                                $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
                        }
                        else
                        {
                                $app->enqueueMessage($errors[$i], 'warning');
                        }
                }

                // Save the data in the session.
                $app->setUserState('com_marketingrocket.edit.quicklanding.data', $data);

                // Redirect back to the edit screen.
                $this->setRedirect(
                        JRoute::_(
                                'index.php?option=' . $this->option . '&view=' . $this->view_item
                                . $this->getRedirectToItemAppend($recordId, $urlVar), false
                        )
                );

                return false;
            }
            
            $landingTable = JTable::getInstance('Landing', 'MarketingrocketTable');
            $landingModel = $this->getModel('Landing', 'MarketingrocketModel');

            $data = array(
                'title' => $validData['name'],
                'published' => 1,
                'campaign_id' => $validData['campaign_id'],
                'type' => $validData['type'],
                'public_accsess' => 1,
                'responder_type' => 0,
                'form_or_cta' => 'form',
                'page_html' => $validData['body'],
                'modal_body' => $validData['modal']
            );
            $this->input->set('template', $validData['selected_template']);
            $data = $landingModel->publicLoadFormData($data);

            $landingTable->bind($data);
            $landingTable->check();
            $landingTable->store();
            
            $app->setUserState('com_marketingrocket.edit.quicklanding.data', array());
            
            // Redirect back to the edit screen.
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend($landingTable->id, 'id'), false
                    )
            );
        }
        
        
	
}
