<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;



class MarketingrocketControllerLogic extends JControllerForm
{
    
        public $targetResponder;
        public $targetLanding;
        public $targetCampaign;
        public $actNow;
        
        public $id = 0;

	protected $view_list = 'logics';
        
        public function getModel($name = 'Logic', $prefix = 'MarketingrocketModel', $config = array()) {
            return parent::getModel($name, $prefix, $config);
        }
        
        protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
            $this->id = $model->getState($this->context . '.id');
	}
        
        public function save($key = null, $urlVar = null) {
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $ids = $this->input->post->get('id', array(), 'array');
            $this->input->set('id', (int)$_GET['id']);
            
            $ret = parent::save($key, $urlVar);
            if(!$ret)
                return $ret;
            
            
            set_time_limit(0);
            
            $conditionType = $this->input->post->get('condition_type', array(), 'array');
            $tags = $this->input->post->get('tags', array(), 'array');
            $action = $this->input->post->get('action', array(), 'array');
            $responderType = $this->input->post->get('responder_type', array(), 'array');
            $this->targetResponder = $this->input->post->get('target_responder', array(), 'array');
            $this->targetLanding = $this->input->post->get('target_landing', array(), 'array');
            $this->targetCampaign = $this->input->post->get('target_campaign', array(), 'array');
            $actNow = $this->input->post->get('act_now', array(), 'array');
            

            $id = $ids;
            $apiId = $this->input->post->get('api_id', array(), 'array');
            $order = $this->input->post->get('order', array(), 'array');
            
            $leads = array();
            $ladningModel = false;
            $affrectedLeads = 0;
            
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            foreach ($id as $key => $rowId){

                $data = array(
                    'condition_type' => $conditionType[$key],
                    'landing_id' => $this->id,
                    'tags' => $tags[$key],
                    'action' => $action[$key],
                    'responder_type' => $responderType[$key],
                    'api_id' => @$apiId[$key],
                    'order' => $order[$key],
                    'type' => 'tag_action'
                );

                $actionRow = explode('_', $data['action']);
                array_shift($actionRow);
                $actionRow = implode('_', $actionRow);

                $varName = 'target'.(ucfirst($actionRow));

                $rowData = $this->input->post->get('target_'.$actionRow, array(), 'array');

                $data['target'] = $rowData[$key];
                $table = JTable::getInstance('Action', 'MarketingrocketTable');
                if(!empty($rowId))
                    $table->load($rowId);
    //             
    //             
                 $table->bind($data);

                 $table->store();
                 
                 if(!empty($actNow[$key])){
                     if(empty($leads)){
                         $db = JFactory::getDbo();
                         $q = $db->getQuery(true);
                         $q->select('*')->from($db->qn('#__mrocket_leads'))
                                 ->where($db->qn('is_temp').' = 0')
                                 ;
                         $db->setQuery($q);
                         $leads = $db->loadObjectList();
                         
                         require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'landing.php';
                         $ladningModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
                     }
                     foreach ($leads as $lead){
                        if($ladningModel->actionConditionCheck($lead, $table) == true){
                            $ladningModel->_handleAction($table , $lead);
                            $affrectedLeads++;
                        }
                    }
                 }

            }
            $this->setMessage(JText::_('COM_MARKETINGROCKET_LOGIC_SAVED_SUCESS'));
            
            if($affrectedLeads){
                $this->setMessage(JText::sprintf('COM_MARKETINGROCKET_LOGIC_APPLIED_TO_N_LEAD', $affrectedLeads));
            }
            
            return true;
        }
        
}
