<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerLeads extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Lead', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
	
	public function notes(){
		$model = $this->getModel();
		$app		= JFactory::getApplication();
		$id = $app->input->get('id', 0);
		$note =  $app->input->get('note', 0);
		$model->updateNote($note, $id);
		die;
	}
         public function import(){
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=lead&layout=import', false));
            return true;
        }
        
        
        public function export(){
            ini_set ( 'memory_limit', '1000M' );
            // Check for request forgeries
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            $model = JModelLegacy::getInstance('Leads', 'MarketingrocketModel');
            // Get items to publish from the request.
            $cid = JFactory::getApplication()->input->get('cid', array(), 'array');
            $jinput = JFactory::getApplication()->input;
			$temp = explode(',',$jinput->get('exportFieldOrder', '', ''));
			array_shift($temp);
			$fields = array();
			foreach($temp as $val)
			{
				if($val == 'Registration Date'){ $fields[] = 'created'; }
				else if($val == 'Black List'){ $fields[] = 'recieve_email'; }
				else if($val == 'Name'){ $fields[] = 'first-name'; }
				else{ $fields[] = str_replace(' ' ,'_',strtolower($val)); }
			}
			
            if(empty($fields)){
                $fields = $model->getAllFields(true);
                if(array_search('email', $fields) === false){
                    array_unshift($fields, 'email');
                }
                if(array_search('first_name', $fields) === false){
                    array_unshift($fields, 'first_name');
                }
				if(array_search('recieve_email', $fields) === false){
                    array_unshift($fields, 'recieve_email');
                }
            }
			 
            $fields = array_unique($fields);
            $db = JFactory::getDbo();
            $st = "(";
            $sep = '';
            foreach ($fields as $field){
               $st .= $sep.$db->q($field);
               $sep = ",";
            }
            $st .= ")";
            try {
                $db->setQuery('SET OPTION SQL_BIG_SELECTS = ON');
                $db->execute();
            }
            catch (Exception $e){
            }

            try {
                $db->setQuery('SET SQL_BIG_SELECTS = ON');
                $db->execute();
            }
            catch (Exception $e){

            }
              $query = $db->getQuery(true);
              $query->select(array($db->qn('b.value'), $db->qn('a.id'), $db->qn('field_name'), $db->qn('a.first_name'), $db->qn('last_name'), $db->qn('email') , $db->qn('a.created'), $db->qn('a.recieve_email')))
                      ->from($db->qn('#__mrocket_leads', 'a'))
                      ->leftJoin($db->qn('#__mrocket_lead_details', 'b').' ON a.id = b.lead_id AND b.field_name IN '.$st)
                      ->order('a.id ASC')
                      ->group('b.lead_id,b.field_name')
                      ;
            if(empty($cid)){
                $model = $this->getModel('Leads');
                $q = $model->getQuery();
                $q->clear('select');
                $q->select('a.id');
                $db->setQuery($q);
                $cid = $db->loadColumn();
            }
            if(!empty($cid))
                $query->where('a.id IN ('.implode(',', $cid).')');
            else
                $query->where('a.is_temp = 0');

              $db->setQuery($query);
              $res = $db->loadObjectList();
			 
              $leads = array();
              $lastLead = 0;
              foreach ($res as $row){
                  if($row->id != $lastLead){
                      if(isset($obj)){
                          $leads[] = $obj;
                      }
                      $obj = new stdClass();
                      if(array_search('email', $fields) !== false)
                          $obj->email = $row->email;
                      if(array_search('first_name', $fields) !== false)
                          $obj->first_name = $row->first_name;
                      if(array_search('MR_submited_date', $fields) !== false)
                          $obj->MR_submited_date = JHtml::_('date', $row->created, JText::_('DATE_FORMAT_LC2'));
                      if(array_search('created', $fields) !== false)
                          $obj->created = JHtml::_('date', $row->created, JText::_('DATE_FORMAT_LC2'));
					  if(array_search('recieve_email', $fields) !== false)
                          $obj->recieve_email = $row->recieve_email;
                      $lastLead = $row->id;
                  }
                  $key = $row->field_name;
                  $key = strtolower($key);
                if(empty($key))
                  continue;
                if (DateTime::createFromFormat('Y-m-d G:i:s', $row->value) !== FALSE) {
                    $obj->$key =  JHtml::_('date', $row->value, JText::_('DATE_FORMAT_LC2'));
                }
                else if(isset($row->value))
                    $obj->$key = $row->value;
                else
                    $obj->$key = '';
              }
              $leads[] = $obj;
              $out = '';
			 
              $fieldsTitle = $model->getAllFields(false, $fields);
			  
              foreach ($fields as $field){
                    $title = $fieldsTitle[$field];
                    $out .= $title.'	';
               }
			   
              $out .= "\n";
              $leadId = false;
			
              foreach ($leads as $lead){
                foreach ($fields as $field){
                    $field = strtolower($field);
                    if(isset($lead->$field))                        
						if($field == 'recieve_email')
						{							
							if($lead->$field == '1')
							{
								$out.= 'No'.'	';
							}
							else
							{
								$out.= 'Yes'.'	';
							}							
						}
						else
						{			
							$out.= $lead->$field.'	';
						} 
                    else
                         $out.= ' - '.'	';

               }
                $out.= "\n"; 
              }

                ob_clean();
                header('Content-Description: File Transfer');
                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment; filename=MarketingRocket_Leads-' . date('Ymd-His') . '.csv' );
                header('Content-Transfer-Encoding: binary');
                header('Expires: 0');
                header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                header('Pragma: public');
                echo chr(255) . chr(254) . mb_convert_encoding( $out , 'UTF-16LE', 'UTF-8');
                exit;
            return true;
        }
    

        
        public function sendemail(){
            
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            
		// Get items to remove from the request.
            $cid = JFactory::getApplication()->input->get('cid', array(), 'array');
            if(empty($cid)){
                throw new Exception('list is empty', 500);
            }
            $session = JFactory::getSession();
            $session->set( 'send_email_list', $cid, 'com_marketingrocket');
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=responder&layout=edit&type=leademail' , false));
            return true;
        }
        
        
        
        
        
	
	
		

	
}
