<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerLead extends JControllerForm
{

	protected $view_list = 'leads';
	/**
	 * Method to run batch operations.
	 *
	 * @param   object  $model  The model.
	 *
	 * @return  boolean   True if successful, false otherwise and internal error is set.
	 *
	 * @since   1.7
	 */
	function __construct($config){
		
		@$this->registerTask('unsubscribe', 'unsubscribe');
		@$this->registerTask('unsubscribeall', 'unsubscribe');
		
		
		parent::__construct($config);
	}
	
	public function unsubscribe(){
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		
		$app   = JFactory::getApplication();
		$lang  = JFactory::getLanguage();
		$model = $this->getModel();
		$table = $model->getTable();
		$campaignId  = $this->input->post->get('campaign', 0, 'int');
		$task = $this->getTask();
		$db = $model->getDbo();
		
		$unsubscribeModel = JModelLegacy::getInstance('Unsubsribe', 'MarketingrocketModel', array('ignore_request' => true));
		
		$leadId = $this->input->get->get('id', 0, 'int');
		if($task == 'unsubscribeall'){
			$unsubscribeModel->unsubscribAllByLead($leadId);
		}
		else 
			$unsubscribeModel->unsubscribeWithLead($leadId, $campaignId);
		$this->setMessage(JText::_('COM_MARKETINGROCKET_UNSUBSCRIBED_SUSCSESS'));
		
		$this->setRedirect(
				JRoute::_(
						'index.php?option=com_marketingrocket&view=lead&layout=subsribes&id='.$leadId, false
				)
		);
		return true;
	}
        
	public function batch($model = null)
	{

		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        ini_set ( 'memory_limit', '1000M' );
        set_time_limit(300);

        $cid  = $this->input->post->get('cid', array(), 'array');

        if(empty($cid)){
            $db = JFactory::getDbo();
            $model = $this->getModel('Leads');
            $q = $model->getQuery();
            $q->clear('select');
            $q->select('a.id');
            $db->setQuery($q);
            $cid = $db->loadColumn();
            $this->input->post->set('cid', $cid);
        }

        $batch = $this->input->post->get('batch', array(), 'array');


		// Set the model
		$model = $this->getModel('Lead', '', array());

        if(empty($batch['batch_responder_sequence']))
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=leads', false));
        else
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=queueds&layout=send', false));
		return parent::batch($model);
	}
        
        public function perview(){
            
            // Check for request forgeries.
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            set_time_limit(0);
            
            $app = JFactory::getApplication();
            $model = $this->getModel();
            $data  = $this->input->post->get('jform', array(), 'array');
            
            $form = $model->getImportForm($data, false);
            
            if (!$form)
            {
                    $app->enqueueMessage($model->getError(), 'error');

                    return false;
            }
             
            // Test whether the data is valid.
            $validData = $model->validate($form, $data);
            
            // Check for validation errors.
            if ($validData === false)
            {
                    // Get the validation messages.
                    $errors = $model->getErrors();

                    // Push up to three validation messages out to the user.
                    for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
                    {
                            if ($errors[$i] instanceof Exception)
                            {
                                    $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
                            }
                            else
                            {
                                    $app->enqueueMessage($errors[$i], 'warning');
                            }
                    }

                    // Save the data in the session.
                    $app->setUserState('com_marketingrocket.import.lead' . '.data', $data);

                    // Redirect back to the edit screen.
                    $this->setRedirect(
                            JRoute::_(
                                    'index.php?option=com_marketingrocket&view=lead&layout=import', false
                            )
                    );

                    return false;
            }
                
            if(isset($_FILES['jform']) && !empty($_FILES['jform']['name'])){
                $handle = fopen($_FILES['jform']['tmp_name']['file'], "r");
                $i = 0;
                $leads = array();
                
                $numberOfErrorRow = 0;
                
                $emailIndex = 0;
                $nameIndex = 1;
                $header = array();
                if(!empty($data['use_head_row'])){
                     $header = fgetcsv($handle, 0, ",");
                     foreach ($header as $key => $h){
                         $header[$key] = strtolower($h);
                     }
                     
                     if(array_search('email',$header) !== false){
                         $emailIndex = array_search('email',$header);
                     }
                     else {
                         array_unshift($header, 'email');
                     }
                     
                     if(array_search('name', $header) !== false){
                         $nameIndex = array_search('name', $header);
                     }
                     if(!empty($data['export_name'])){
                        $header[] = 'last name';
                     }
                }
                
                 set_include_path(implode(PATH_SEPARATOR, array(
                    realpath(JPATH_COMPONENT_SITE.DS.'libs'),
                    get_include_path(),
                )));

                require_once JPATH_COMPONENT_SITE.DS.'libs'.DS.'Zend'.DS.'Validate'.DS.'EmailAddress.php';
                try {
                    if(JComponentHelper::getParams('com_marketingrocket')->get('mx_check', 1) == 1 && $data['check_domain'] == 1){
                        $validate = new Zend_Validate_EmailAddress(array('mx' => true, 'deep' => true));
                    }
                    else {
                        $validate = new Zend_Validate_EmailAddress(array('deep' => true));
                    }
                }
                catch (Exception $e){ // maybe mx check is not available in this host
                    $validate = new Zend_Validate_EmailAddress(array('deep' => true));
                }
                
//                Zend_Debug::dump($nameIndex);
                
                while (($dataRow = fgetcsv($handle, 0, ",")) !== FALSE) {
                    
                    $namesDetail = false;
                    
                    $email = trim($dataRow[$emailIndex]);
                    
                    if (!$validate->isValid($email)) {
                        $numberOfErrorRow++;
                        if($numberOfErrorRow < 5){
                            $app->enqueueMessage($email.' Is Not A Valid Email', 'Error');
                        }
                        continue;
                    }
                    $row = array();
                    $name = '';
                    if(isset($dataRow[$nameIndex])){
                        $name = trim($dataRow[$nameIndex]);
                    }
                    if(empty($name))
                        $name = $email;
                    else if(!empty($data['export_name'])){
                        $namesDetail = explode(' ', $name);
                        $name = array_shift($namesDetail);
                        $row['last_name'] = $row['last name'] = implode(' ', $namesDetail);
                    }
                    
                    $row['first_name'] = $row['name'] = $name;
                    $row['email'] = $email; 
//                    $row['published'] = 1;
                    
                    if(!empty($header)){
                        foreach ($header as $key => $val){
                            if($val !== 'email' && $val != 'name' && (empty($data['export_name']) || $val != 'last name')){
                                $row[$val] = @$dataRow[$key];
                            }
                        }
                    }
                    if(empty($row['email']))
                        continue;
                    $leads[] = $row;
                    if(empty($header)){
                        $header = array('email');
                        if(count($dataRow) > 1)
                            $header[] = 'name';
                    }
                }
                
                $app->setUserState('com_marketingrocket.import.header', $header);
                $app->setUserState('com_marketingrocket.import.leadslist', $leads);
                
                $app->setUserState('com_marketingrocket.import.lead.data', $data);
                
                $this->setRedirect(
                    JRoute::_(
                            'index.php?option=com_marketingrocket&view=lead&layout=preview', false
                    )
                );
                
                return true;
                
            }
            
            $app->enqueueMessage('Upload File Is Empty', 'Error');
            $this->setRedirect(
                JRoute::_(
                        'index.php?option=com_marketingrocket&view=lead&layout=import', false
                )
            );
            
            return true;
            
            
            
            
            
           
        }
        
        public function import(){
            
            // Check for request forgeries.
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
             set_time_limit(0);
            
            $app = JFactory::getApplication();
            $model = $this->getModel();
            
            $table = $model->getTable();
                
            $headers = $app->getUserState('com_marketingrocket.import.header', array());
            $leadData = $app->getUserState('com_marketingrocket.import.leadslist', array());

            $validData = $app->getUserState('com_marketingrocket.import.lead.data', array());
            
            if(empty($leadData) || empty($validData)){
                $app->enqueueMessage('File Is Empty', 'Error');
                $this->setRedirect(
                    JRoute::_(
                            'index.php?option=com_marketingrocket&view=lead&layout=import', false
                    )
                );
                return true;
            }
            
            
            $db = JFactory::getDbo();
            $i = 0;
            
            require JPATH_COMPONENT_SITE.DS.'tables'.DS.'leaddetails.php';
            
            foreach ($leadData as $rowData){
                $data = array(
                    'first_name' => $rowData['first_name'],
                    'email' => $rowData['email'],
                    'published' => 1,
                    'is_temp' => 0
                );
                
                if(!empty($rowData['last_name'])){
                    $data['last_name'] = $rowData['last_name'];
                }
                
                $model->setState('lead.id', 0);
                            
                $query = $db->getQuery(true);

                $query->select('id')->from($db->qn('#__mrocket_leads'))
                        ->where('email = '.$db->q($data['email']))->where('is_temp = 0');
                $db->setQuery($query);
                $res = $db->loadResult();
                if(!empty($res))
                    continue;


                if($model->save($data)){
                    $i++;
                    $lead_id =  $model->getState($this->context . '.id');
                    
                    $table->reset();
                    $table->bind(array('id' => $lead_id));
//                        
                   $table->addRefCode();
                    
                    $leads[] = $lead_id;
                    
                    foreach ($headers as $header){
                        
                        if($header == 'email' || $header == 'first_name')
                            continue;
                        
                        $rowVal = $rowData[$header];
                        if(empty($rowVal))
                            continue;
                        
                        $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                        $leadDetailsTable->landing_id = 0;
                        $leadDetailsTable->lead_id = $lead_id;
                        $leadDetailsTable->field_name = $header;
                        $leadDetailsTable->value = $rowVal;

                        $leadDetailsTable->store();
                    }

                    $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                    $leadDetailsTable->landing_id = 0;
                    $leadDetailsTable->lead_id = $lead_id;
                    $leadDetailsTable->field_name = 'MR_form_name';
                    $leadDetailsTable->value = JText::_('COM_MARKETING_BULK_IMPORTED');

                    $leadDetailsTable->store();


                    $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                    $leadDetailsTable->landing_id = 0;
                    $leadDetailsTable->lead_id = $lead_id;
                    $leadDetailsTable->field_name = 'MR_submited_date';
                    $leadDetailsTable->value = JFactory::getDate()->toSql();

                    $leadDetailsTable->store();

                }
            }
            $model->batch($validData , $leads, ''); 
            $app->enqueueMessage(sprintf(JText::_('COM_MARKETING_ROCKET_ITEM_IMPORTED'), $i));
            
            
            $app->setUserState('com_marketingrocket.import.header', array());
            $app->setUserState('com_marketingrocket.import.leadslist', array());

            $app->setUserState('com_marketingrocket.import.lead.data', array());

            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=leads', false));

            return true;
                
                
        }
        
        public function formdetail(){
            $model = $this->getModel();
            $data = $model->getFormData();
            $text = '';
            foreach ($data as $row){
                if(!empty($row->MR_submited_date)){
                    $date =  JHtml::_('date', $row->MR_submited_date, JText::_('DATE_FORMAT_LC2'));
                    if(!empty($text))
                        $text .= '<hr />';
                    $text .= $row->title.' At '.$date.'<br />';
                }
                else {
                     if(!empty($text))
                        $text .= '<hr />';
                    $text .= JText::_('COM_MARKETINGROCKET_CUSTOM_FIELDS').'<br />';
                }
                
                foreach ($row as $key => $val){
                    if(in_array($key, array('landing_id', 'title', 'MR_form_name', 'MR_submited_date', 'ids')))
                        continue;
                    $label = str_replace('_', ' ', $key);
                    $label= ucwords($label);
                    
                    $text .= $label .' : '.$val.'<br />';
                }
                
            }
            
            echo $text;
            die;
        }
        public function tags(){
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);

            $q->select(array(
                $db->qn('t.title', 'tag_title'),
                $db->qn('c.name', 'campaign_name'),
                $db->qn('lt.campaign_id')
            ))
                ->from($db->qn('#__mrocket_leads_tags', 'lt'))
                ->innerJoin($db->qn('#__mrocket_tags', 't').' ON '.$db->qn('lt.tag_id').' = '.$db->qn('t.id'))
                ->leftJoin($db->qn('#__mrocket_campaign', 'c').' ON '.$db->qn('lt.campaign_id').' = '.$db->qn('c.id'))
                ->where($db->qn('lead_id').' = '.$db->q($this->input->getInt('id')))
            ;

            $db->setQuery($q);
            $items = $db->loadObjectList();

            $tags = array();
            $returnText = '';
            $sep = '';
            foreach ($items as $item) {
                if(empty($item->campaign_id))
                    $text = $item->tag_title;
                else
                    $text = JText::plural('COM_MARKETINGROCKET_TAG_IN_CAMPAIGN', $item->tag_title, $item->campaign_name);
                if(in_array($tags, $tags))
                    continue;
                $returnText .= $sep.$text;
                $sep = ',';
            }
            if(empty($returnText))
                $returnText = JText::_('COM_MARKETINGROCKET_NO_TAG_FOUND');
            echo '<a href="'.JRoute::_('index.php?option=com_marketingrocket&view=leadtags&id='.$this->input->getInt('id')).'">'.$returnText.'</a>';
            die;


        }
        
        public function saveformdata(){
            // Check for request forgeries.
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $this->getModel();
            $table = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            
            $id = $this->input->post->getInt('id');
            if(empty($id))
                $id = $this->input->post->getInt('row-id');
            
            $table->load($id);
            
            $table->field_name = trim($this->input->post->getString('field_name'));
            $table->label = trim($this->input->post->getString('field_name'));
            $table->value = trim($this->input->post->getString('field_value'));
            $table->lead_id = $this->input->post->getInt('lead_id');
            
            if(empty($table->landing_id))
                $table->landing_id = 0;
            
            $table->store();
            
            echo new JResponseJson($table->id);
            die;
        }
        
        public function deleteformdata(){
             // Check for request forgeries.
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $this->getModel();
            $table = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            
            $table->load($this->input->post->getInt('id'));
            
            $table->delete();
            
            die;
        }
        
        public function reset(){
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $id = $this->input->getInt('id');
            $model = $this->getModel();
            $table = $model->getTable();
            
            $table->load($id);
            if(empty($table->id)){
                die;
            }
            $table->w_metter = 0;
            $table->store();
            
           $this->setMessage(JText::_('COM_MARKETINGROCKET_RESET_SUCCESS'));
           
           
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend($id, 'id'), false
                    )
            );
            return true;
            
        }
        
        public function recalculate(){
            JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
            
            $id = $this->input->getInt('id');
            $model = $this->getModel();
            $table = $model->getTable();
            
            $table->load($id);
            if(empty($table->id)){
                die;
            }
            
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
            MarketingrocketHelper::calculateWarmMetter($id, false, true);
            
            
           $this->setMessage(JText::_('COM_MARKETINGROCKET_RECALCULATE_SUCCESS'));
           
           
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend($id, 'id'), false
                    )
            );
            return true;
            
        }
        
	
}
