<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerLandingtemplate extends JControllerForm
{
	
    public function detail(){
        $id = $this->input->post->get('id', null, 'int');
         
        $model = $this->getModel();
        
        $db		= $model->getDbo();
        $query	= $db->getQuery(true);

        $query->select('html,form,hidden_css,css,modal_html,exit_modal_html,javascript,page_option')->from('#__mrocket_landing_templates')->where('id = '.$db->q($id));
        $db->setQuery($query);



        $res = $db->loadAssoc();
        $array = @json_decode($res['page_option'], true);
        if(is_array($array)){
            foreach ($array as $key => $val){
                $res[$key] = $val;
            }
        }
        

        echo new JResponseJson($res);
        die;
         
    }
    
    public function import(){
        
        // Check for request forgeries.
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        if(!empty($_FILES['file'])){
            $dir = JPATH_SITE.DIRECTORY_SEPARATOR.'tmp'.DIRECTORY_SEPARATOR.'tmp_'.uniqid();
            mkdir($dir);
            
            $flieName = $_FILES['file']['name'];
            move_uploaded_file($_FILES['file']['tmp_name'], $dir.DIRECTORY_SEPARATOR.$flieName);
            
            
            return $this->importTemplate($dir, $flieName);
            
        }
        
        
        return false;
        
    }
    
    public function importTemplate($dir, $flieName, $isController = true){
        $zip = new ZipArchive;
        $res = $zip->open($dir.DIRECTORY_SEPARATOR.$flieName);
        $zip->extractTo($dir.DIRECTORY_SEPARATOR);
        $zip->close();
        
        $app = JFactory::getApplication();
        unlink($dir.DIRECTORY_SEPARATOR.$flieName);
        if(!file_exists($dir.DIRECTORY_SEPARATOR.'install.json')){
            $this->_deleteFolders($dir);
            if($isController){
                $app->enqueueMessage('Import Error , Cant find installation file', 'error');
                $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend(null, $urlVar), false
                    )
                );
            }
            return false;
        }
        $jsonString = file_get_contents($dir.DIRECTORY_SEPARATOR.'install.json');
        $jsonObject = json_decode($jsonString);

        if(empty($jsonObject->safe_name)){
            $this->_deleteFolders($dir);
            if($isController){
                $app->enqueueMessage('Import Error , Cant find installation file', 'error');
                $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend(null, $urlVar), false
                    )
                );
            }
            return false;
        }


        $tagetDir = JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.$jsonObject->safe_name;
        @mkdir($tagetDir);

        $cdir = scandir($dir.DIRECTORY_SEPARATOR.'media');
        foreach ($cdir as $key => $value)
        {
           if (!in_array($value,array(".","..")))
           {
               $pathInfo = pathinfo($value);
               if(!in_array($pathInfo['extension'], array('jpg', 'jpeg', 'png', 'gif', 'bmp'))){
                    return false; // only handles the images
                }
                if(file_exists($tagetDir.DIRECTORY_SEPARATOR.$value))
                    unlink ($tagetDir.DIRECTORY_SEPARATOR.$value); // some update

                @rename($dir.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.$value, $tagetDir.DIRECTORY_SEPARATOR.$value);
           }
        } 

        $model = $this->getModel();
        $table = $model->getTable();
        $data = (array)$jsonObject;

        require_once JPATH_LIBRARIES . '/htmlpurifier/HTMLPurifier.auto.php';

        $config = HTMLPurifier_Config::createDefault();
        $config->set('Attr.EnableID', true);
        $config->set('HTML.DefinitionRev', '1');
        $config->set('HTML.SafeIframe', true);
        $config->set('URI.SafeIframeRegexp', '%^(https?:)?//(www\.youtube(?:-nocookie)?\.com/|player\.vimeo\.com/video/)%');

        $config->set('HTML.Doctype', 'HTML 4.01 Transitional');

        $def = $config->getHTMLDefinition(true);
        $def->addAttribute('div', 'aria-type', 'Text');

        $def->addAttribute('div', 'aria-mainclass', 'Text');

        $def->addAttribute('span', 'data-size', 'Text'); // icon
        $def->addAttribute('span', 'id', 'Text'); // icon

        $def->addAttribute('div', 'data-addelement', 'Text'); // icon

        $def->addAttribute('div', 'style', 'Text');
        $def->addAttribute('li', 'style', 'Text');
        $def->addAttribute('a', 'style', 'Text');

        $def->addAttribute('div', 'aria-css', 'Text');

        $def->addAttribute('div', 'onclick', 'Click');

        $def->addElement('input', 'Block', 'Flow', 'Common');
        $def->addAttribute('input', 'aria-replace', 'Text');
        $def->addAttribute('input', 'value', 'Text');
        $def->addAttribute('input', 'placeholder', 'Text');


        $def->addElement('button', 'Block', 'Flow', 'Common');
        $def->addAttribute('button', 'type', 'Text');
        $def->addAttribute('button', 'data-dismiss', 'Text');
        $def->addAttribute('button', 'aria-hidden', 'Text');

        $def->addAttribute('a', 'data-original-title', 'Text');
        $def->addAttribute('a', 'style', 'Text');
        
        $def->addAttribute('a', 'contenteditable', 'Text');
        $def->addAttribute('div', 'contenteditable', 'Text');
        $def->addAttribute('span', 'contenteditable', 'Text');
        $def->addAttribute('p', 'contenteditable', 'Text');
        $def->addAttribute('li', 'contenteditable', 'Text');
        $def->addAttribute('ul', 'contenteditable', 'Text');
        $def->addAttribute('h1', 'contenteditable', 'Text');
        $def->addAttribute('h2', 'contenteditable', 'Text');
        $def->addAttribute('h3', 'contenteditable', 'Text');
        $def->addAttribute('h4', 'contenteditable', 'Text');
        $def->addAttribute('h5', 'contenteditable', 'Text');
        $def->addAttribute('h6', 'contenteditable', 'Text');
        
        $def->addAttribute('div', 'data-template', 'Text');
        $def->addAttribute('div', 'data-animation', 'Text');
        
        

        // http://developers.whatwg.org/sections.html
        $def->addElement('section', 'Block', 'Flow', 'Common');
        $def->addElement('nav',     'Block', 'Flow', 'Common');
        $def->addElement('article', 'Block', 'Flow', 'Common');
        $def->addAttribute('article', 'aria-css', 'Text');
        $def->addAttribute('article', 'aria-type', 'Text');
        $def->addAttribute('article', 'style', 'Text');
        $def->addElement('aside',   'Block', 'Flow', 'Common');
        $def->addElement('header',  'Block', 'Flow', 'Common');
        $def->addElement('footer',  'Block', 'Flow', 'Common');

        // Content model actually excludes several tags, not modelled here
        $def->addElement('address', 'Block', 'Flow', 'Common');
        $def->addElement('hgroup', 'Block', 'Required: h1 | h2 | h3 | h4 | h5 | h6', 'Common');

        // http://developers.whatwg.org/grouping-content.html
        $def->addElement('figure', 'Block', 'Optional: (figcaption, Flow) | (Flow, figcaption) | Flow', 'Common');
        $def->addElement('figcaption', 'Inline', 'Flow', 'Common');

        // http://developers.whatwg.org/the-video-element.html#the-video-element
        $def->addElement('video', 'Block', 'Optional: (source, Flow) | (Flow, source) | Flow', 'Common', array(
          'src' => 'URI',
          'type' => 'Text',
          'width' => 'Length',
          'height' => 'Length',
          'poster' => 'URI',
          'preload' => 'Enum#auto,metadata,none',
          'controls' => 'Bool',
        ));
        $def->addElement('source', 'Block', 'Flow', 'Common', array(
          'src' => 'URI',
          'type' => 'Text',
        ));

        $def->addAttribute('div', 'aria-type', 'Text');


        $purifier = new HTMLPurifier($config);
        $data['html'] = $purifier->purify($data['html']);
        $data['modal_html'] = $purifier->purify($data['modal_html']);
        $data['exit_modal_html'] = $purifier->purify($data['exit_modal_html']);
        $data['css'] = strip_tags($data['css']);
        $data['hidden_css'] = strip_tags($data['hidden_css']);

        $data['unique_name'] = $data['safe_name'];
        // Allow an exception to be thrown.
        try
        {
                // Bind the data.
                $table->bind($data);

                // Check the data.
                $table->check();

                // Store the data.
                $table->store();

                if(!empty($data['has_preview'])){
                    rename($dir.DIRECTORY_SEPARATOR.$data['has_preview'], JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'assets'.DIRECTORY_SEPARATOR.'th'.DIRECTORY_SEPARATOR.$table->id.'.png');
                }

        }
        catch (Exception $e)
        {
            $this->_deleteFolders($dir);
            if($isController)
                throw $e;   
        }
        $this->_deleteFolders($dir);

        
        if($isController){
            $app->enqueueMessage(JTEXT::_('COM_MARKETINGROCKET_IMPORTED_SUCCESSFULLY'));
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=' . $this->view_item
                            . $this->getRedirectToItemAppend(null, $urlVar), false
                    )
            );
        }
    }
    
    private function _deleteFolders($dir) { 
        if (is_dir($dir)) { 
          $objects = scandir($dir); 
          foreach ($objects as $object) { 
            if ($object != "." && $object != "..") { 
              if (filetype($dir."/".$object) == "dir") $this->_deleteFolders($dir."/".$object); else unlink($dir."/".$object); 
            } 
          } 
          reset($objects); 
          rmdir($dir); 
        } 
 }
    
    public function delete(){
         // Check for request forgeries.
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        $id = JFactory::getApplication()->input->getInt('id');
        $this->getModel()->getTable()->delete($id);
        
         $this->setMessage(JText::plural($this->text_prefix . '_N_ITEMS_DELETED', 1));
        $this->setRedirect(
                JRoute::_(
                        'index.php?option=' . $this->option . '&view=' . $this->view_item
                        . $this->getRedirectToItemAppend(null, $urlVar), false
                )
        );
    }
	
}
