<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerLandings extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	
		
	
	}
	
	
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Landing', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
        
        
        public function resetstat()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		// Get items to publish from the request.
		$cid = JFactory::getApplication()->input->get('cid', array(), 'array');
		if (empty($cid))
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Get the model.
			$model = $this->getModel();

			// Make sure the item ids are integers
			JArrayHelper::toInteger($cid);

			// Publish the items.
			try
			{
				$model->resetstat($cid);

                                $ntext = 'COM_MARKETINGROCKET_N_ITEMS_STATITIC_RESET';

				$this->setMessage(JText::plural($ntext, count($cid)));
			}
			catch (Exception $e)
			{
				$this->setMessage($e->getMessage(), 'error');
			}
		}

		$extension = $this->input->get('extension');
		$extensionURL = ($extension) ? '&extension=' . $extension : '';
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $extensionURL, false));
	}
        
	
	
		

	
}
