<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class MarketingrocketControllerLanding extends JControllerForm
{

        public $foundedImages = array();
        public $replaceImages;
        
        protected $view_list = 'landings';
        
        function __construct($config){
		
		parent::__construct($config);
		$this->registerTask('autosave', 'savepreview');
	}


        public function add(){
		$this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=landingtemplate', false));
	}
	
	public function safecss(){
	    $model = $this->getModel();
	    
// 	    $document =& JFactory::getDocument();
	    
	    // Set the MIME type for JSON output.
// 	    $document->setMimeEncoding('application/json');

	    $css = $this->input->post->get('css', null, 'string');
	    
	    $safeCss = $model->makeCssSafe($css);
	    echo new JResponseJson($safeCss);
	    die;
	}
	
	public function savepreview(){
		$model = $this->getModel();
		
		
		$table = $model->getTable();
		$data  = $this->input->post->get('jform', array(), 'array');
// 		unset($data['id']);
		
		$form = $model->getForm($data, false);
		$validData = $model->validate($form, $data);
		$return = array();
                
                if(JFactory::getApplication()->input->post->get('task') == 'landing.autosave'){
                    $validData = $data;
                }

		// Check for validation errors.
		if ($validData === false)
		{
			
			$return['error'] = array();
			
			$errors = $model->getErrors();
			
			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
			{
			if ($errors[$i] instanceof Exception)
			{
				$return['error'][] = $errors[$i]->getMessage();
			}
			else
			{
				$return['error'][] = $errors[$i];
			}
			}
		}
		else if($model->save($validData)){
			$db = $table->getDbo();
			$landing_id = $db->insertid();
			$item = $model->getItem();
			$return['ok'] = array();
			$return['ok']['id'] = $landing_id;
                        $return['ok']['date'] = JHtml::_('date', time(), 'H:i:s');
// 			$return['ok']['token'] = $item->token;
			$return['ok']['token'] = JComponentHelper::getParams('com_marketingrocket')->get('salt');
		}
		else {
			$retun['error'] =  $model->getError();
		}	
		ob_clean();
		header ( 'Content-type: application/json' );
		echo json_encode ( $return );
		die;
		
	}
        /**
         * savetemplate action
         * @return boolean
         */
        public function  savetemplate(){
            $this->set('task', 'apply');
            
            $ret = $this->save();
            if($ret === false)
                return $ret;
            
            $data  = $this->input->post->get('jform', array(), 'array');
            
            $templateSafeName = strtolower($data['template_name']);
            $templateSafeName = preg_replace('#[^A-Z0-9_]#i', '', $templateSafeName);
            $templateSafeName = $templateSafeName.'_'.uniqid(); // make sure its unique
            
            
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'landingtemplate.php';
            
            $template = JTable::getInstance('Landingtemplate', 'MarketingrocketTable');
            
            $template->name = $data['template_name'];
            $template->html = $data['page_editor'];
            $template->modal_html = $data['modal_editor'];
            
            $template->exit_modal_html = $data['exit_popup_modal'];
            
            $data['page_option'] = array();
            
            if(!empty($data['exit_popup'])){
                $data['page_option']['exit_popup'] = $data['exit_popup'];
                $data['page_option']['exit_popup_size'] = $data['exit_popup_size'];
            }
            $data['page_option']['selected_form_style'] = $data['selected_form_style'];
            
            $form = json_decode($data['form_json']);
            
            $id = JFactory::getApplication()->input->getInt('id');
            foreach ($form as $key => $row){
                if(!empty($row->name))
                    $name = $row->name;
                else 
                    $name = $row->label;
                if(empty($id)){
                    $name = JFilterOutput::stringURLSafe($name);
                    $row->name = $name;
                }
                else {
                    $row->name = strtolower(str_replace(' ', '_', $name));
                }
                $form[$key] = $row;
                
            }
            
            $data['form_json'] = json_encode($form);
            
            $data['page_option']['load_fonts'] = $data['load_fonts'];

            $data['page_option']['font_weights'] = $data['font_weights'];
            
            $data['page_option'] = json_encode($data['page_option']);
            
            $template->page_option = $data['page_option'];
            $template->form = $data['form_json'];
            $template->javascript = $data['javascript'];
            
            $landingTypes = MarketingrocketHelper::$landingTypes;
            
            $template->type = $landingTypes[$data['type']];
            $template->hidden_css = $data['hidden_css'];
            $template->css = $data['css'];
            
            $template->unique_name = $templateSafeName;
            $template->store();
            
            return true;
            
            
        }

        /**
         * export action
         * @return boolean
         * @throws Exception
         */
        public function export(){
            $this->set('task', 'apply');
            
            $ret = $this->save();
            if($ret === false)
                return $ret;
            
            $landingTypes = MarketingrocketHelper::$landingTypes;
            
            $data  = $this->input->post->get('jform', array(), 'array');
            
            $templateSafeName = strtolower($data['template_name']);
            $templateSafeName = preg_replace('#[^A-Z0-9_]#i', '', $templateSafeName);
            $templateSafeName = $templateSafeName.'_'.uniqid(); // make sure its unique
            
            $dom = new DOMDocument();
            $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			</head><body>'.$data['page_editor'].'</body></html>';
            

            
            
            @$dom->loadHTML($pageHtml);
            
            $imgs = $dom->getElementsByTagName('img');
            
            $tmpFolder = JPATH_SITE.DIRECTORY_SEPARATOR.'tmp'.DIRECTORY_SEPARATOR.'tmp_'.uniqid();
            
            $dirMaked = mkdir($tmpFolder);
            if($dirMaked === false){
                Throw new Exception('Temp Dir is not writable');
            }
            
            mkdir($tmpFolder.DIRECTORY_SEPARATOR.'media');
            
            $urlPatch = JUri::getInstance();
//            $joomlaLocation = 'http://'.$urlPatch->getHost().JURI::root(true);
            $joomlaLocation = JURI::root();
            
//            $joomlaLocation = (JComponentHelper::getParams('com_marketingrocket')->get('site_address', '') == '') ? JUri::root() : JComponentHelper::getParams('com_marketingrocket')->get('site_address');
           
            
            $this->foundedImages = array();
            $this->replaceImages = array();
            
            foreach ($imgs as $img){
                $src = $img->getAttribute('src');
                $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
                
                $src = $img->getAttribute('data-src');
                if(!empty($src))
                    $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
               
            }
            
            $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			</head><body>'.$data['modal_editor'].'</body></html>';
            
             @$dom->loadHTML($pageHtml);
            
            $imgs = $dom->getElementsByTagName('img');
            
            foreach ($imgs as $img){
                $src = $img->getAttribute('src');
                $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
                
                $src = $img->getAttribute('data-src');
                if(!empty($src))
                    $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
               
            }
            
            $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			</head><body>'.$data['exit_popup_modal_editor'].'</body></html>';
            
             @$dom->loadHTML($pageHtml);
            
            $imgs = $dom->getElementsByTagName('img');
            
            foreach ($imgs as $img){
                $src = $img->getAttribute('src');
                $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
                
                $src = $img->getAttribute('data-src');
                if(!empty($src))
                    $this->_saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName);
               
            }
            
            
            foreach ($this->foundedImages as $image){
                $data['page_editor'] = str_replace($image, $this->replaceImages[$image], $data['page_editor']);
                $data['modal_editor'] = str_replace($image, $this->replaceImages[$image], $data['modal_editor']);
                $data['exit_popup_modal_editor'] = str_replace($image, $this->replaceImages[$image], $data['exit_popup_modal_editor']);
            }
            
            $data['hidden_css'] = $this->replaceUrl($data['hidden_css'],$tmpFolder ,$templateSafeName);
            
            $data['css'] = $this->replaceUrl($data['css'],$tmpFolder ,$templateSafeName);
            
            $data['page_editor'] = $this->replaceUrl($data['page_editor'],$tmpFolder ,$templateSafeName);
            
            $data['modal_editor'] = $this->replaceUrl($data['modal_editor'],$tmpFolder ,$templateSafeName);
            
            $data['exit_popup_modal_editor'] = $this->replaceUrl($data['exit_popup_modal_editor'],$tmpFolder ,$templateSafeName);
            
            
            $jsonArray = array();
            if(!empty($data['template_preview'])){
              
               $previewImage = $this->_saveImage('/'.$data['template_preview'], $joomlaLocation, $tmpFolder, $templateSafeName, 'preview');
               $previewImage = pathinfo($previewImage);
               $jsonArray['has_preview'] = 'preview'.'.'.$previewImage['extension'];
                unset($this->replaceImages['/'.$data['template_preview']]);
            }
            
           
            $jsonArray['page_editor'] = $data['page_editor'];
            $jsonArray['name'] = $data['template_name'];
            $jsonArray['desc'] = $data['template_desc'];
            $jsonArray['html'] = $data['page_editor'];
            $jsonArray['modal_html'] = $data['modal_editor'];
            $jsonArray['hidden_css'] = $data['hidden_css'];
            $jsonArray['exit_modal_html'] = $data['exit_popup_modal_editor'];
            $jsonArray['css'] = $data['css'];
            $jsonArray['type'] = $landingTypes[$data['type']];
            $jsonArray['safe_name'] = $templateSafeName;
            
            
            $data['page_option'] = array();
            
            if(!empty($data['exit_popup'])){
                $data['page_option']['exit_popup'] = $data['exit_popup'];
                $data['page_option']['exit_popup_size'] = $data['exit_popup_size'];
            }
            $data['page_option']['selected_form_style'] = $data['selected_form_style'];
            
            $form = json_decode($data['form_json']);
            
            $id = JFactory::getApplication()->input->getInt('id');
            foreach ($form as $key => $row){
                if(!empty($row->name))
                    $name = $row->name;
                else 
                    $name = $row->label;
                if(empty($id)){
                    $name = JFilterOutput::stringURLSafe($name);
                    $row->name = $name;
                }
                else {
                    $row->name = strtolower(str_replace(' ', '_', $name));
                }
                $form[$key] = $row;
                
            }
            
            $data['form_json'] = json_encode($form);
            
            $data['page_option']['load_fonts'] = $data['load_fonts'];
            
            $data['page_option'] = json_encode($data['page_option']);
            
            $jsonArray['form'] = $data['form_json'];
            $jsonArray['javascript'] = $data['javascript'];
            $jsonArray['page_option'] = $data['page_option'];
            
            $file = fopen($tmpFolder.'/install.json', 'w');
            fwrite($file, json_encode($jsonArray));
            fclose($file);
            
            $zip = new ZipArchive;
            
            $zip->open(JPATH_SITE.DIRECTORY_SEPARATOR.'tmp'.DIRECTORY_SEPARATOR.$templateSafeName.'.zip', ZipArchive::CREATE);
            $zip->addFile($tmpFolder.DIRECTORY_SEPARATOR.'install.json', 'install.json');
            
            $zip->addEmptyDir('media');
            foreach ($this->replaceImages as $image){
                $image = pathinfo($image);
                $zip->addFile($tmpFolder.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.$image['basename'], 'media'.DIRECTORY_SEPARATOR.$image['basename']);
              
            }
             if(!empty($data['template_preview'])){
                 echo $tmpFolder.DIRECTORY_SEPARATOR.$jsonArray['has_preview'];
                  $zip->addFile($tmpFolder.DIRECTORY_SEPARATOR.$jsonArray['has_preview'], $jsonArray['has_preview']);
             }
            
            $zip->close();
            
            $session = JFactory::getSession();
            
            $session->set('MR_redirect', JUri::root().'tmp/'.$templateSafeName.'.zip');
            return $ret;
        }
        /**
         * savehtml action
         * @return boolean
         */
        public function savehtml(){
            $this->set('task', 'apply');
            
            $ret = $this->save();
            if($ret === false)
                return $ret;
            
            $url = parse_url($this->redirect);
            parse_str($url['query'], $out);
            $id = $out['id'];
            
            $model = $this->getModel();
            $table = $model->getTable();
            $table->load($id);
            $tempTable = JTable::getInstance('Temp', 'MarketingrocketTable');
            $tempTable->bind($table);
            
            $data  = $this->input->post->get('jform', array(), 'array');
            $api = $data['template_api'];
            $data['landing_id'] = $id;
            
            $this->handleExportJob($table, $data);
           
            $tempTable->bind($data);
            $tempTable->store();
            
//            $url = JUri::root();
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=landing.savehtml&id='.$tempTable->id.'&api='.$api.'&token='.JComponentHelper::getParams('com_marketingrocket')->get('salt'));
            JFactory::getApplication()->redirect($url);
            return true;
        }
        
        public function handleExportJob($table, &$data){
            $data['page_html'] = $this->replaceSrcImages($table->page_html);
           
            $data['modal_body'] = $this->replaceSrcImages($table->modal_body);
            $data['exit_popup_modal'] = $this->replaceSrcImages($table->exit_popup_modal);
            
            $data['page_html'] = $this->replaceLinkUrl($data['page_html']);
            $data['modal_body'] = $this->replaceLinkUrl($data['modal_body']);
            $data['exit_popup_modal'] = $this->replaceLinkUrl($data['exit_popup_modal']);
            
            
            $data['hidden_css'] = $this->replaceUrl($table->hidden_css, null, null, false);
            
            $data['css'] = $this->replaceUrl($table->css,null, null, false);
            
            
            $data['save_type'] = 'html';
            
           
        }
        
        /**
         * make source of image absoulte 
         * @param type $html
         * @return type
         */
        public function replaceSrcImages($html){
//            $url = JUri::root();
             require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = JUri::root();
            
            // replacing relative path for images
            $pattern = '/(src="\/)|(src="[^http])/';
            preg_match_all($pattern, $html, $matches);
            foreach ($matches[0] as $match){

                $char = substr($match, -1);
                if($char == '/')
                    $char = '';
                $html = str_replace($match, 'src="'.$url.$char, $html);
            }
            return $html;
            
        }
        
        /**
         * replace url in of a tag and make them absoulte 
         */
        public function replaceLinkUrl($html){
//            $url = JUri::root();
             require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = JUri::root();
            
            // replacing relative path for images
            $pattern = '/(href="\/)|(href="[^http])/';
            preg_match_all($pattern, $html, $matches);
            foreach ($matches[0] as $match){

                $char = substr($match, -1);
                if($char == '/')
                    $char = '';
                $html = str_replace($match, 'href="'.$url.$char, $html);
            }
            return $html;
            
        }
        /**
         * replace urls in css
         * @param type $html
         * @return type
         */
        public function replaceUrl($html, $tmpFolder, $templateSafeName,  $save = true){
            $pattern = '/url\(([^\(]+)\)/';
            preg_match_all($pattern, $html, $matches);
            
            $url = JUri::root();
            
            if(!empty($matches[1])){
                foreach ($matches[1] as $match){
                    $imageLocation = str_replace("'", '', $match);
                    $imageLocation = str_replace('"', '', $imageLocation);
                    $imageLocation = str_replace('\\', '', $imageLocation);
                    if($save)
                        $newLocation = $this->_saveImage($imageLocation, $url, $tmpFolder, $templateSafeName);
                    else {
                        $newLocation = $url.$imageLocation;
                    }
                    if(!empty($newLocation)){
                        $html = str_replace($imageLocation, $newLocation, $html);
                    }
                }
            }
            return $html;
        }
        private function _saveImage($src, $joomlaLocation, $tmpFolder, $templateSafeName, $target = null){
                 $pathData = parse_url($src);
                 
                if(!empty($pathData['host'])) // its absolute image
                    return false;
                if(in_array($src, $this->foundedImages)){
                    return $this->replaceImages[$src];
                }
                
               
                $this->foundedImages[] = $src;
                $pathInfo = pathinfo($src);
                
                if(!in_array($pathInfo['extension'], array('jpg', 'jpeg', 'png', 'gif', 'bmp'))){
                    return false; // only handles the images
                }
                
                $imageData = @file_get_contents($joomlaLocation.$src);
                if(file_exists($tmpFolder.'/'.$pathInfo['basename']))
                        $pathInfo['basename'] = $pathInfo['filename'].uniqid ().'.'.$pathInfo['extension'];
                if(empty($target))
                    @file_put_contents($tmpFolder.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.$pathInfo['basename'], $imageData);
                else {
                     @file_put_contents($tmpFolder.DIRECTORY_SEPARATOR.$target.'.'.$pathInfo['extension'], $imageData);
                }
                $this->replaceImages[$src] = '/media/com_marketingrocket/'.$templateSafeName.'/'.$pathInfo['basename'];
                 return $this->replaceImages[$src];
        }
        
        public function config(){
            $string = "CKEDITOR.editorConfig = function( config ) {
                // Define changes to default configuration here.
                // For complete reference see:
                // http://docs.ckeditor.com/#!/api/CKEDITOR.config

                // The toolbar groups arrangement, optimized for two toolbar rows.
                config.toolbarGroups = [
                        { name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
                        { name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
                        { name: 'links' },
                        { name: 'insert', groups: [ 'image2', 'table'] },
                        { name: 'forms' },
                        { name: 'tools' },
                        { name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
                        { name: 'others' },
                        '/',
                        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
                        { name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
                        { name: 'colors' },
                        '/',
                        { name: 'styles' },
                        { name: 'about' }
                ];
                
                config.allowedContent = true;
                config.extraPlugins = 'lineutils';
                config.extraPlugins = 'widget';
                config.extraPlugins = 'image2';
                config.extraPlugins = 'sourcedialog';

                config.extraAllowedContent = 'p(*)[*]{*};div(*)[*]{*};li(*)[*]{*};ul(*)[*]{*}';
                ".'CKEDITOR.dtd.$removeEmpty.i = 0;
                CKEDITOR.dtd.$removeEmpty.em = 0;'."

                config.removeButtons = 'Underline,Subscript,Superscript';

                config.format_tags = 'p;h1;h2;h3;pre';

                config.removeDialogTabs = 'image:advanced;link:advanced';
                
                config.fontSize_sizes = '8/8px;9/9px;10/10px;11/11px;12/12px;13/13px;14/14px;15/15px;16/16px;17/17px;18/18px;19/19px;20/20px;21/21px;22/22px;23/23px;24/24px;25/25px;26/26px;27/27px;28/28px;29/29px;30/30px;31/31px;32/32px;33/33px;34/34px;35/35px;36/36px;37/37px;38/38px;39/39px;40/40px;41/41px;42/42px;43/43px;44/44px;45/45px;46/46px;47/47px;48/48px;49/49px;50/50px;51/51px;52/52px;53/53px;54/54px;55/55px;56/56px;57/57px;58/58px;59/59px;60/60px;61/61px;62/62px;63/63px;64/64px;65/65px;66/66px;67/67px;68/68px;69/69px;70/70px;71/71px;72/72px';

                config.filebrowserBrowseUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.browse&opener=ckeditor&type=files', false)."';
                config.filebrowserImageBrowseUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.browse&opener=ckeditor&type=images', false)."';
                config.filebrowserFlashBrowseUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.browse&opener=ckeditor&type=flash', false)."';
                config.filebrowserUploadUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.upload&opener=ckeditor&type=files', false)."';
                config.filebrowserImageUploadUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.upload&opener=ckeditor&type=images', false)."';
                config.filebrowserFlashUploadUrl = '".JRoute::_('index.php?option=com_marketingrocket&task=landing.upload&opener=ckeditor&type=flash', false)."'; ";
            if($this->input->getInt('id', 0) != 0){
                $model = $this->getModel();
                
                $item = $model->getItem($this->input->getInt('id'));
                
                $landingOptions = json_decode($item->page_option);
                if(!empty($landingOptions)){
                    $defstring = 'Arial/Arial, Helvetica, sans-serif;' .
                        'Comic Sans MS/Comic Sans MS, cursive;' .
                        'Courier New/Courier New, Courier, monospace;' .
                        'Georgia/Georgia, serif;' .
                        'Lucida Sans Unicode/Lucida Sans Unicode, Lucida Grande, sans-serif;' .
                        'Tahoma/Tahoma, Geneva, sans-serif;' .
                        'Times New Roman/Times New Roman, Times, serif;' .
                        'Trebuchet MS/Trebuchet MS, Helvetica, sans-serif;' .
                        'Verdana/Verdana, Geneva, sans-serif;';
                
                    $sep = '';
                    $fontString = '';
                   
                    if(is_array($landingOptions->load_fonts)){
                        
                        foreach ($landingOptions->load_fonts as $font){
                            $font = preg_replace('/\w+-{1}/', '', $font);
                            $fontString .= "$font;";

                        }
                    }
                    
                    
                    $string .= "config.font_names='$defstring$fontString'";
                }
            }
            
            $string .= "};";
            header('Pragma: ');
            header('Expires: ' );
            header('Cache-Control: '); // required for certain browsers 
            header("Keep-Alive:	timeout=5, max=100");
            header("Content-Type: text/javascript");
            header("X-Powered-By: ");
            echo $string;
            die;
        }
        
        public function browse(){
            require JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'kcfinder'.DS.'browse.php';
            die;
        }
        
        public function js(){
            require JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'kcfinder'.DS.'js'.DS.'index.php';
            die;
        }
        
        public function css(){
            if($this->input->get('template', '') != '')
                require JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'kcfinder'.DS.'themes'.DS.$this->input->get('template').DS.'css.php';
            else 
                require JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'kcfinder'.DS.'css'.DS.'index.php';
            die;
        }
        
        public function upload(){
            require JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'kcfinder'.DS.'upload.php';
            die;
        }
        
        public function atags(){
            
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            
            $id = $this->input->getInt('id');
            
            $landingTable = JTable::getInstance('Landing','MarketingrocketTable');
            $landingTable->load($id);
            
            $dom = new DOMDocument();
            
            
            $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head><body>'.$landingTable->page_html.'</body></html>';
            
            @$dom->loadHtml($pageHtml);
            
            $xpath = new DOMXpath($dom);
            $elements = $xpath->query('//a[@onclick="showFormPopUp()"]');
            
            $array = array();
            foreach ($elements as $element){
                $array[] = array('id' => '#'.$element->getAttribute('id'), 'text' => $element->textContent);
            }
            
            echo new JResponseJson($array);
	    die;
        }
        
        public function debug(){
            
            $url = 'https://marketing-rocket.com/index.php?option=com_mrmangement&task=debug.log';
            $message = $this->input->post->getString('message');
//            $errorUrl = $this->input->post->getString('url');
            $lineNumber = $this->input->post->getString('lineNumber');
            
            $myvars = 'message=' . $message . '&url=' . 'removed'.'&line='.$lineNumber;

            $ch = curl_init( $url );
            curl_setopt( $ch, CURLOPT_POST, 1);
            curl_setopt( $ch, CURLOPT_POSTFIELDS, $myvars);
            curl_setopt($ch, CURLOPT_URL, $url); // set url
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  
            curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6"); // set browser/user agent    
            curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);

            $response = curl_exec( $ch );
            die;
        }
        
        public function loadsave(){
            if(!JSession::checkToken( 'get' ) )
                jexit(JText::_('JINVALID_TOKEN'));
            
            $model = $this->getModel();
            
            $autoSave = $model->getLastAutoSave();
            
            $form = $model->getForm(array(), false);
            if(!$form instanceof JForm)
                die;
            
            
            $data = array();
            foreach ($form->getFieldsets() as $fieldSet){
               foreach ($form->getFieldset($fieldSet->name) as $field){
                   if(!$field instanceof JFormField)
                       die;
                   $name = $field->__get('fieldname');
                   if(isset($autoSave->$name))
                        $data[$name] = $autoSave->$name;
               }
            }
            
            JFactory::getApplication()->setUserState('com_marketingrocket.edit.landing.data', $data);
            
            $this->setRedirect(
                    JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item.'&layout=edit&id='.$this->input->getInt('id')
					, false
				));
            
            return true;
            
        }
        
        public function tabletemplate(){
            $id = $this->input->getInt('template', 0);
            if(empty($id))
                die;
            
            ob_start();

            include JPATH_COMPONENT.DS.'views'.DS.'_common'.DS.'pricetables'.DS.'template_'.$id.DS.'column.php';

            $output = ob_get_contents();
            ob_end_clean();
            
            include JPATH_COMPONENT.DS.'views'.DS.'_common'.DS.'pricetables'.DS.'template_'.$id.DS.'data.php';
            
            
            echo new JResponseJson(array('html' => $output, 'css' => file_get_contents(JPATH_COMPONENT.DS.'views'.DS.'_common'.DS.'pricetables'.DS.'template_'.$id.DS.'style.css'), 'data' => $data));
	    die;
            
            
        }
	
	
	
	
	
}
