<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerInstallation extends JControllerAdmin
{
    public function version(){
        require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'marketingrocket.php';

        $returnData = array();


        $versionNumber = MarketingrocketHelper::getVersion();
        $returnData['version'] = $versionNumber;



        $ch = $this->getCurl('https://marketing-rocket.com/index.php?option=com_mrmangement&task=version.data&v='.$versionNumber);
        $res = curl_exec($ch);


        curl_close($ch);
        $note = json_decode($res);
        $returnData['note'] = $note->data;

        echo new JResponseJson($returnData);
        die;
    }

    private function getCurl($url){


        //open connection
        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
//                CURLOPT_HEADER         => true,
//            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTPHEADER => array(
                'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
//                   'Accept-Encoding: deflate, sdch',
                'Accept-Language: en-GB,en;q=0.8,en-US;q=0.6,fa;q=0.4,ro;q=0.2,zh-CN;q=0.2,zh;q=0.2',
                'Cache-Control:no-cache',
                'Connection: keep-alive',
                'Pragma:no-cache',
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2490.86 Safari/537.36',
            )
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }

    public function downloadId(){
        $downloadId = $this->input->post->get('download_id', '');


        require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
        $ret = MarketingrocketHelper::checkDownloadId($downloadId, true);

        echo new JResponseJson($ret);
        die;
    }

    public function createMenu(){
        $menuName = $this->input->post->getString('menu_name', 'Marketing Rocket');


        $table = JTable::getInstance ( 'MenuType' );
        $data = array (
            'menutype' => 'marketing-rocket',
            'title' => 'Marketing Rocket',
            'description' => ''
        );
        if (! $table->bind ( $data ) || ! $table->check ()) {
            // Menu already exists, do nothing
        }
        else {
            if (! $table->store ()) {

            }
        }



        $db = $table->getDbo();

        $query = $db->getQuery(true);
        $query->select('extension_id')->from('#__extensions')->where('name = '.$db->q('com_marketingrocket'));
        $db->setQuery($query);
        $res = $db->loadObject();


        $table = JTable::getInstance ( 'menu' );

        $table->load(array('menutype'=>'marketing-rocket', 'link'=>'index.php?option=com_marketingrocket&view=seo', 'published' => 1));
        if(!empty($table->id)){
            echo new JResponseJson(null, 'Menu Already Exist', true);
            die;
        }
        $paramdata = array ('menu-anchor_title'=>'',
            'menu-anchor_css'=>'',
            'menu_image'=>'',
            'menu_text'=>1,
            'page_title'=>'',
            'show_page_heading'=>0,
            'page_heading'=>'',
            'pageclass_sfx'=>'',
            'menu-meta_description'=>'',
            'menu-meta_keywords'=>'',
            'robots'=>'',
            'secure'=>0);

        $gparams = new JRegistry($paramdata);

        $params = clone $gparams;
        $params->loadArray(array('catids'=>0));

        $db = JFactory::getDBO();
        $query = $db->getQuery(true);

        $query->select('id')->from('#__template_styles')->where('template = '.$db->q('marketingrocket'));

        $db->setQuery($query);

        $data = array (
            'menutype' => 'marketing-rocket',
            'title' => $menuName,
            'link' => 'index.php?option=com_marketingrocket&view=seo',
            'type' => 'component',
            'published' => 1,
            'parent_id' => 1,
            'component_id' => $res->extension_id,
            'access' => 1,
            'template_style_id' => $db->loadResult(),
            'params' => (string) $params,
            'home' => 0,
            'language' => '*',
            'client_id' => 0
        );
        $table->setLocation(1, 'last-child');
        if (! $table->bind ( $data ) || ! $table->check () || ! $table->store ()) {

        }

        echo new JResponseJson(true);
        die;
    }
    public function joomla(){


        $db = JFactory::getDbo();

        $q = $db->getQuery(true);

        $q->select('version')->from('#__updates')->where('element = '.$db->q('joomla'));

        $db->setQuery($q);



        $res = $db->loadResult();

        if(empty($res)){
            echo new JResponseJson(true);
            die;
        }



        echo new JResponseJson('<md-card ng-hide="$ctrl.joomlaFixed" flex="25" ><md-card-title>
                        <md-card-title-text>
                        <span class="md-headline">Please Update Your Joomla</span>
                    <span class="md-subhead">The lattest Joomla Version is '.$res.'</span>
                    <span>Please make sure your backup your site before updating, we are not responsible for problems occurring from updating your site</span>
                        </md-card-title-text></md-card-title>
        <md-card-actions layout="row" layout-align="end center">
          <md-button ng-href="index.php?option=com_installer&view=update" target="_blank">Click Here To Update</md-button>
          <md-button ng-click="$ctrl.skipJoomla()">Skip</md-button>
        </md-card-actions>
      </md-card>', '', true);
        die;
    }
    public function seo(){
        $sef =JFactory::getApplication()->get('sef');
        $sefRewirte = JFactory::getApplication()->get('sef_rewrite');

        try {
            if($sef == 0){
                throw new Exception('Search Engline Friendly URLs Is disabled | We highly recommend to for better SEO for your website considor to enable this option');
            }
            if($sefRewirte == 0){
                throw new Exception('Use URL Rewriting Is disabled | We highly recommend to for better SEO for your website considor to enable this option');
            }

            if(!file_exists(JPATH_SITE.'/.htaccess')){
                throw new Exception('htaccess is not renamed  | We highly recommend to for better SEO for your website considor to enable this option');
            }
        }
        catch (Exception $e){
            $message = explode('|', $e->getMessage());
            echo new JResponseJson('<md-card flex="25" ><md-card-title>
                        <md-card-title-text>
                        <span class="md-headline">'.$message[0].'</span>
                    <span class="md-subhead">'.$message[1].'</span>
                        </md-card-title-text></md-card-title>
        <md-card-actions layout="row" layout-align="end center">
          <md-button ng-href="index.php?option=com_config" target="_blank">Click Here For Fixing</md-button>
        </md-card-actions>
      </md-card>', '', true);
            die;
        }

        echo new JResponseJson(true);
        die;
    }
    public function apps(){

        $errors = false;

        if(JComponentHelper::isInstalled('com_sh404sef') && JComponentHelper::isEnabled('com_sh404sef')
            && JComponentHelper::getParams('com_sh404sef')->get('com_marketingrocket___manageURL') != 2
        ){

            $errors = '<md-card  flex="25" ng-class="{\'green-bg\' : $ctrl.shFixed == 2}"><md-card-title>
                        <md-card-title-text>
                        <div ng-show="$ctrl.shFixed < 2">
                            <span class="md-headline">sh404SEF is installed</span>
                            <br />
                            <span class="md-subhead">Marketing Rocket Route Is Not Compatible With This Extension , You Need To Add Exclusion For Marketing Rocket In This Component</span>
                        </div>
                        <div ng-show="$ctrl.shFixed == 2">
                            <span class="md-headline">Fixed !</span>
                        </div>
                        </md-card-title-text></md-card-title>
        <md-card-actions layout="row" layout-align="end center">
          <md-button ng-show="$ctrl.shFixed < 2" ng-click="$ctrl.fixsh()" target="_blank"  style="min-width: 30px;">
                <md-progress-circular ng-show="$ctrl.shFixed == 1" class="md-hue-2" md-diameter="20px"></md-progress-circular>
                <span ng-hide="$ctrl.shFixed == 1">
                    Add Exclusion Automatically
                </span>
          </md-button>
        </md-card-actions>
      </md-card>';
        }
        if(JComponentHelper::isInstalled('com_rsfirewall') && JComponentHelper::isEnabled('com_rsfirewall')){
            $errors .= '<md-card flex="25" ><md-card-title>
                        <md-card-title-text>
                        <span class="md-headline"> RSFirewall! is Installed</span>
                    <span class="md-subhead">Marketing Rocket Have An Incompatibility With RSFirewall! You Need To Add An Exceptions In This Component , <br />
                    <ul>
<li>Head to <strong>Components</strong> &gt;&gt; <strong>RSFirewall!</strong> &gt;&gt; <strong>Exceptions</strong></li>
<li>Click on <strong>New</strong></li>
<li>Select <strong>Component</strong> in the <strong>Exception Type</strong> dropdown</li>
<li>Add <strong>com_marketingrocket</strong> in the <strong>Match</strong> textbox</li>
<li>Set <strong>Skip JS Protections</strong> to <strong>Yes</strong>. </li>
<li>Click on <strong>Save</strong> or <strong>Save &amp; Close</strong>. </li>
</ul></span>
                        </md-card-title-text></md-card-title>
        <md-card-actions layout="row" layout-align="end center">
        </md-card-actions>
      </md-card>';
        }


        if(empty($errors))
            echo new JResponseJson(true);
        else
            echo new JResponseJson($errors, '', true);
        die;

    }

    public function fixsh()
    {

        $db = JFactory::getDbo();

        $params = JComponentHelper::getParams('com_sh404sef');
        $params->set('com_marketingrocket___manageURL', 2);

        $query = $db->getQuery(true);
        // Build the query
        $query->update('#__extensions AS a');
        $query->set('a.params = ' . $db->quote((string)$params));
        $query->where('a.element = "com_sh404sef"');

        // Execute the query
        $db->setQuery($query);
        $db->execute();

        echo new JResponseJson(true);
        die;
    }

    public function editor(){
        $plugin = JPluginHelper::getPlugin('editors', 'tinymce');
        $params = json_decode($plugin->params);
        if(JComponentHelper::getParams('com_marketingrocket')->get('email_editor','simple') == 'simple' && JFactory::getApplication()->get('editor') == 'tinymce' && $params->relative_urls == '1'){
            echo new JResponseJson('<md-card flex="25" ><md-card-title>
                        <md-card-title-text>
                        <span class="md-headline">Tinymce Editor Warning!</span>
                    <span class="md-subhead">'.ucwords(strtolower(JText::_('COM_MARKETINGROCKET_EDITOR_WARNING'))).'</span>
                        </md-card-title-text></md-card-title>
        <md-card-actions layout="row" layout-align="end center">
          
        </md-card-actions>
      </md-card>', '', true);
            die;
        }

        echo new JResponseJson(true);
        die;
    }
}