<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerDashboard extends JControllerAdmin
{
	public function __construct($config = array())
	{
		
		parent::__construct($config);
		
	}
	
	public function getModel($name = 'Reports', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
	
	public function rss(){
	
		$xml = file_get_contents('http://feeds.feedburner.com/marketing-rocket');
		$dom = new DOMDocument();
		$dom->loadXML($xml);
		$items = $dom->getElementsByTagName('item');
		$ret = '';
                $i = 0;
		foreach ($items as $item){
			if($i == 4)
                            break;
                        $link = $item->getElementsByTagName('link')->item(0);
			$title =  $item->getElementsByTagName('title')->item(0);
			$ret .= '<li><a href="'.$link->nodeValue.'" target="_blank">
					<i class="fa fa-angle-right"></i>
					'.$title->nodeValue.'</a></li>';
		
                        $i++;
                }
		echo $ret;
		die;
	}
	
	public function notice(){
            
            $page = $this->input->post->getInt('page', 0);
            $db = JFactory::getDBO();
            
            if(empty($page)){
                $params = JComponentHelper::getParams('com_marketingrocket');
                $lastCheck = $params->get('last_message_download', 1445554315);

                $now = JFactory::getDate();
                $lastCheckTime = JFactory::getDate($lastCheck);

                $lastCheckTime->modify('+1 hour');

               
                if($now->getTimestamp() > $lastCheckTime->getTimestamp()){
                    $lastCheckTime->modify('-1 hour');
                    $json = file_get_contents('https://marketing-rocket.com/index.php?option=com_mrmangement&task=message.messages&last-date='.$lastCheckTime->format('Y-m-d'));

                    $data = json_decode($json);
                    JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');
                    foreach ($data->data as $row){
                        $table = JTable::getInstance('Messages', 'MarketingrocketTable');
                        $table->load(array('message_id' => $row->id));
                        if(empty($table->id)){

                            if($row->deleted)
                                continue;

                            $table->bind($row);
                            $table->message_id = $row->id;
                            $table->id = null;
                            $table->store();
                        }
                        else {
                             if($row->deleted)
                             {
                                 $table->delete();
                                 continue;
                             }
                            $id = $table->id;
                            $table->bind($row);
                            $table->id = $id;
                            $table->store();
                        }
                    }

                    $params->set('last_message_download', $now->getTimestamp());

                    $query = $db->getQuery(true);

                    // Build the query
                    $query->update('#__extensions AS a');
                    $query->set('a.params = ' . $db->quote((string)$params));
                    $query->where('a.element = "com_marketingrocket"');

                    // Execute the query
                    $db->setQuery($query);
                    $db->execute();
                }
            }
            $nullDate = $db->quote($db->getNullDate());
            $date = JFactory::getDate();

            $nowDate = $db->quote($date->toSql());
            
            $query = $db->getQuery(true);
            
            $query->select('*')->from($db->qn('#__mrocket_messages'))
                    ->where($db->qn('published').' = 1')
                    ->where('( '.$db->qn('publish_up').' = '.$nullDate.' OR '.$db->qn('publish_up').' < '.$nowDate.' )')
                    ->where('( '.$db->qn('publish_down').' = '.$nullDate.' OR '.$db->qn('publish_down').' > '.$nowDate.' )')
                    ->order('id DESC')
                    ;
            $db->setQuery($query, $page*50,50);
            $res = $db->loadObjectList();
            
            
            $config = JFactory::getConfig();
            $user = JFactory::getUser();

            
            foreach ($res as $key => $row){
                if($row->is_system == 1){
                     $date = JFactory::getDate($row->created, 'UTC');
                     $date->setTimeZone(new DateTimeZone($user->getParam('timezone', $config->get('offset'))));
                     $row->created = $date->format(JText::_('DATE_FORMAT_LC2'), true);
                     $res[$key] = $row;
                }
            }
            
            echo new JResponseJson($res);
            die;
	}
	
	public function liveupdate(){
            
            $db = JFactory::getDbo();
            
            $q = $db->getQuery(true);
            
            $q->select('update_id')->from('#__updates')->where('element = '.$db->q('pkg_marketingrocket'));
            
            $db->setQuery($q);
            
           
            
            $res = $db->loadResult();
            
            if(!empty($res))
                echo new JResponseJson(true);
            else 
               echo new JResponseJson(false);
            die;
	}
        
        public function resubmit(){
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = MRRoute::createFrontRoute('');
            @file_get_contents('http://cron.marketing-rocket.com/index.php?submit=1&force=1&url='.$url);
            $this->setRedirect(
                    JRoute::_(
                            'index.php?option=' . $this->option . '&view=dashboard', false
                    )
            );
        }
        
        public function mark(){
            // Check for request forgeries
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            
            $id = $this->input->post->getInt('id');
            
            JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');
            $table = JTable::getInstance('Messages', 'MarketingrocketTable');
            $table->load($id);
            
            $table->read_status = 1;
            $table->store();
            die;
            
           
        }
        public function markAll(){
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->update($db->qn('#__mrocket_messages'))
                ->set($db->qn('read_status').' = 1');
            $db->setQuery($q);
            $db->execute();
            die;
        }
        public function deleteall(){
            JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->delete($db->qn('#__mrocket_messages'))
                ->set($db->qn('read_status').' = 1');
            $db->setQuery($q);
            $db->execute();
            die;
        }


	
}
