<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerCampaigns extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	
		
	
	}
	
        public function delete() {
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $db = JFactory::getDbo();
            try {
                $db->transactionStart();
                parent::delete();
                
                $cid = JFactory::getApplication()->input->get('cid', array(), 'array');
                
                foreach ($cid as $id){
                    
                    /**
                     * delete leads campaigns
                     */
                    $q = $db->getQuery(true);
                    $q->delete()->from('#__mrocket_lead_campaigns')->where('campaign_id = '.$db->q($id));
                    $db->setQuery($q);
                    $db->execute();
                    
                    /**
                     * select landings of campaing
                     */
                    $q = $db->getQuery(true);
                    $q->select('id')->from($db->qn('#__mrocket_landings'))->where($db->qn('campaign_id').' = '.$db->q($id));
                    $db->setQuery($q);
                    $landings = $db->loadColumn();
                    foreach ($landings as $landingId){
                        
                        /**
                         * delete landing
                         */
                        $landingRow = JTable::getInstance('Landing', 'MarketingrocketTable');
                        $landingRow->delete($landingId);
                        
                        /**
                         * delete daily stat of landing
                         */
                        $q = $db->getQuery(true);
                        $q->delete()->from('#__mrocket_daily_stat')->where('landing_id = '.$db->q($landingId));
                        $db->setQuery($q);
                        $db->execute();
                    }
                    
                    /**
                     * get campaing sequences
                     */
                    $q = $db->getQuery(true);
                    $q->select('id')->from($db->qn('#__mrocket_reponders_sequences'))->where($db->qn('campaign_id').' = '.$db->q($id));
                    $db->setQuery($q);
                    $sequences = $db->loadColumn();
                    foreach ($sequences as $sequence){
                        
                        /**
                         * get sequence responders
                         */
                        $q = $db->getQuery(true);
                        $q->select('id')->from($db->qn('#__mrocket_responder_templates'))->where($db->qn('sequence_id').' = '.$db->q($sequence));
                        $db->setQuery($q);
                        $responders = $db->loadColumn();
                        

                        if(!empty($responders)){
                            
                            /**
                             * delete responders
                             */
                            $q = $db->getQuery(true);
                            $q->delete()->from('#__mrocket_responder_templates')->where('id IN ('.implode(',', $responders).')');
                            $db->setQuery($q);
                            $db->execute();

                            /**
                             * delete crons of responders
                             */
                            $q = $db->getQuery(true);
                            $q->delete()->from('#__mrocket_leads_cron')->where('responder_id IN ('.implode(',', $responders).')');
                            $db->setQuery($q);
                            $db->execute();

                            /**
                             * select attachments and then delete them
                             */
                            $q = $db->getQuery(true);
                            $q->select('*')->from($db->qn('#__mrocket_responder_attachments'))->where('responder_id IN ('.implode(',', $responders).')');
                            $db->setQuery($q);
                            $attachments = $db->loadObjectList();
                            
                        
                            foreach ($attachments as $attachment){
                                $attachmentTable =  JTable::getInstance('Responderattachment', 'MarketingrocketTable');
                                unlink(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                                                    DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attachment->file_name);
                                $attachmentTable->delete($id);
                            }
                        }
                        
                        
                        /**
                         * delete sequence
                         */
                        $sequenceRow = JTable::getInstance('Sequence', 'MarketingrocketTable');
                        $sequenceRow->delete($sequence);
                        
                        
                    }
                }
                $db->transactionCommit();
            }
            catch(Exception $e){
                $db->transactionRollback();
                JError::raiseWarning($e->getCode(), $e->getMessage());
            }
            
            
            
            
        }
	
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Campaign', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
        
        public function resetstat()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		// Get items to publish from the request.
		$cid = JFactory::getApplication()->input->get('cid', array(), 'array');
		if (empty($cid))
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Get the model.
			$model = $this->getModel();

			// Make sure the item ids are integers
			JArrayHelper::toInteger($cid);

			// Publish the items.
			try
			{
				$model->resetstat($cid);

                                $ntext = 'COM_MARKETINGROCKET_N_ITEMS_STATITIC_RESET';

				$this->setMessage(JText::plural($ntext, count($cid)));
			}
			catch (Exception $e)
			{
				$this->setMessage($e->getMessage(), 'error');
			}
		}

		$extension = $this->input->get('extension');
		$extensionURL = ($extension) ? '&extension=' . $extension : '';
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $extensionURL, false));
	}
	
	
		

	
}
