<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.controlleradmin');

class MarketingrocketControllerApilist extends JControllerAdmin
{
	/**
	 * Proxy for getModel.
	 * @since   1.6
	 */
	public function getModel($name = 'Api', $prefix = 'MarketingrocketModel', $config = array('ignore_request' => true))
	{
		
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
        
    public function getlist(){
        $db		= JFactory::getDbo();
        $query	= $db->getQuery(true);

        $type = $this->input->getString('type');
        if($type == "default"){
            $query->select(array($db->qn('a.id'),$db->qn('a.title')))
                ->from($db->quoteName('#__mrocket_api', 'a'))
                ->innerJoin($db->qn('#__mrocket_api_types', 'b').' ON '.$db->qn('a.type').' = '.$db->qn('b.type'))
                ->where($db->qn('b.category').' = '.$db->q('marketing_email'))
            ;
        }
        else {
            $query->select(array('id,title'))
            ->from($db->quoteName('#__mrocket_api'))
            ->where('type = '.$db->q($type))
            ;

        }

        $db->setQuery($query);
        $list = $db->loadAssocList();
        echo new JResponseJson($list);
        die;

    }

    public function getresponders(){
        $type = $this->input->get('type', 'default');
        $campaignId = $this->input->getInt('campaign_id');
        $apiId = $this->input->getInt('api_id');
        if($type == 'default'){
            $model = $this->getModel('Campaigns');
            $list = $model->getRespondersList($type, $campaignId);

        }
        else {
            JLoader::import('joomla.plugin.helper');
            JPluginHelper::importPlugin('marketingrocket');
            $dispatcher = JEventDispatcher::getInstance();
            $list = array();
            try {
                $dispatcher->trigger('onGetResponders', array(&$type, $campaignId, $apiId, &$list) );
            }
            catch (Exception $e){
                echo new JResponseJson(null, $e->getMessage(), true);
                die;
            }
        }

        $newArray = array();
        foreach ($list as $key => $item) {
            $newArray[] = array('id' => $key, 'title' => $item);
        }

        echo new JResponseJson($newArray);
        die;
    }

	
}
