<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
use Joomla\Registry\Registry;

defined('_JEXEC') or die;



class MarketingrocketControllerAction extends JControllerForm
{

    public $targetResponder;
    public $targetLanding;
    public $targetCampaign;
    
    public function delete(){
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        
        $id = $this->input->post->getInt('id');
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
        $table = JTable::getInstance('Action', 'MarketingrocketTable');
        $table->load($id);

        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->update('#__mrocket_actions')->set($db->qn('order').' = '.$db->qn('order').'-1')->where('landing_id = '.$table->landing_id)
                ->where($db->qn('order').' > '.$table->order);
        $db->setQuery($q);
        $db->execute();
        
        $table->delete();
        
        
        
        die;
        
    }
    
    public function save($key = null, $urlVar = null) {
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        
        $conditionType = $this->input->post->get('condition_type', array(), 'array');
        $tags = $this->input->post->get('tags', array(), 'array');
        $action = $this->input->post->get('action', array(), 'array');
        $responderType = $this->input->post->get('responder_type', array(), 'array');
        $this->targetResponder = $this->input->post->get('target_responder', array(), 'array');
        $this->targetLanding = $this->input->post->get('target_landing', array(), 'array');
        $this->targetCampaign = $this->input->post->get('target_campaign', array(), 'array');
        $id = $this->input->post->get('id', array(), 'array');
        $apiId = $this->input->post->get('api_id', array(), 'array');
        $order = $this->input->post->get('order', array(), 'array');
        
        $landingId = $this->input->getInt('landing_id', 0);
        
        $wizard = $this->input->getInt('wizard', 0);
        
        $sessionData = array();
        
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
        foreach ($id as $key => $rowId){
            
            $data = array(
                'condition_type' => $conditionType[$key],
                'tags' => $tags[$key],
                'action' => $action[$key],
                'responder_type' => $responderType[$key],
                'api_id' => @$apiId[$key],
                'order' => $order[$key]
            );
            
            $actionRow = explode('_', $data['action']);
            array_shift($actionRow);
            $actionRow = implode('_', $actionRow);
            
            $varName = 'target'.(ucfirst($actionRow));
            
            $rowData = $this->input->post->get('target_'.$actionRow, array(), 'array');
            
            $data['target'] = $rowData[$key];
            if(empty($landingId)){
                $sessionData[] = $data;
                continue;
            }
            $data['landing_id'] = $landingId;
            $table = JTable::getInstance('Action', 'MarketingrocketTable');
            if(!empty($rowId))
                $table->load($rowId);
//             
//             
             $table->bind($data);
             
             $table->store();
             
        }
        if(!empty($sessionData)){
            if($wizard > 0){
                $registery = new Registry;
                $registery->loadArray($sessionData);
                $session = JFactory::getSession();
                $template = $session->get('wizard', false, 'com_marketingrocket');
                
                $template->items[$wizard-2]->options->actions = $registery->toObject();
                $session->set('wizard', $template, 'com_marketingrocket');
            }
            else {
                $session = JFactory::getSession();
                $session->set('landing_action', $sessionData);
            }
        }
        $this->setRedirect(
            JRoute::_(
                    'index.php?option=' . $this->option . '&view=' . $this->view_item.'&id=1&layout=edit&tmpl=component'
                    , false
            )
        );
        return true;
    }
        
}
