<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;


class MarketingrocketController extends JControllerLegacy
{
	
	protected $default_view = 'dashboard';
	
	public function display($cachable = false, $urlparams = false)
	{



        require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
        $downloadId = JComponentHelper::getParams('com_marketingrocket')->get('download_id', false);
        $lastDownloadIdCheck = JComponentHelper::getParams('com_marketingrocket')->get('last_download_id_check', 0);
        if(
            (JFactory::getApplication()->input->get('view') != 'installation') &&
            ((!empty($downloadId) && $downloadId != JComponentHelper::getParams('com_marketingrocket')->get('save_download_id'))
                ||
                $lastDownloadIdCheck < strtotime('-30 day'))
            )

          {
              MarketingrocketHelper::checkDownloadId($downloadId);
          }

          if(JFactory::getApplication()->input->get('view') == 'installation' && JFactory::getApplication()->input->get('redirect', false) == false){

              JFactory::getDocument()->addScriptDeclaration('location.href = "index.php?option=com_marketingrocket&view=installation&tmpl=component&redirect=1"');

//              JFactory::getApplication()->redirect('index.php?option=com_marketingrocket&view=installation&tmpl=component&redirect=1');
          }

        $document  = JFactory::getDocument();

		if(JFactory::getApplication()->input->getString('tmpl') != 'component' || JFactory::getApplication()->input->getString('view') == 'landing'){
            $versionNumber = MarketingrocketHelper::getVersion();
            if(version_compare(JVersion::RELEASE, '3.7') < 0)
			    $document->addCustomTag('<link rel="stylesheet" href="' . JUri::root(true) . '/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />');
            else {
                $document->addStyleDeclaration('
                #toolbar .icon-fa.fa.fa-desktop.fa-2x  ,#toolbar  .icon-fa.fa.fa-tablet.fa-2x,
#toolbar .icon-fa.fa.fa-mobile.fa-2x
{
    margin: 0px;
    border: 0px;
    display: block;
    padding: 2px 0;
    background: none;
}
.btn-group.btn-group-yesno label {
    float : none;
    text-align : center;
}
                ');

            }
			$document->addCustomTag('<link id="marketing_rocket_mainstyle" rel="stylesheet" href="' . JUri::base() . '/components/com_marketingrocket/assets/css/style.css?'.$versionNumber.'" type="text/css" />');
                        
            $document->addStyleSheet (JUri::base() . 'components/com_marketingrocket/assets/css/dashboard.css' );
		}
        $document->addStyleSheet ('https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css');
        $lastCronDate = JComponentHelper::getParams('com_marketingrocket')->get('last_cron',1);

        if(strtotime($lastCronDate) < time()-86400 && JFactory::getApplication()->input->getString('tmpl') != 'component'){
           $app = JFactory::getApplication();
           $text = JText::_('COM_MARKETINGROCKET_CRON_ERORR');
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
           $text = sprintf($text, '<a href="'.  JRoute::_('index.php?option=com_marketingrocket&task=dashboard.resubmit').'">', '</a>', JUri::root().'index.php?option=com_marketingrocket&view=cron');
           $app->enqueueMessage($text, 'error');
        }

        if(JComponentHelper::getParams('com_marketingrocket')->get('salt',false) == false){
            $params = JComponentHelper::getParams('com_marketingrocket');
            $params->set('salt', rand(10000,100000));

            $db = JFactory::getDBO();
            $query = $db->getQuery(true);

            // Build the query
            $query->update('#__extensions AS a');
            $query->set('a.params = ' . $db->quote((string)$params));
            $query->where('a.element = "com_marketingrocket"');

            // Execute the query
            $db->setQuery($query);
            $db->execute();

        }

        $document->addScript (JUri::base().'/components/com_marketingrocket/assets/js/browser.js' , "text/javascript" , true );

        $document->addCustomTag('<script src="'.JUri::root(true).'/media/jui/js/jquery-migrate.min.js'.'" type="text/javascript" ></script>');
                
                
		parent::display();
                
                
		
		return $this;
	}
}
