<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

// Set flag that this is a parent file.
const _JEXEC = 1;

error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT & ~E_NOTICE);
ini_set('display_errors', 0);

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php'))
{
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES'))
{
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}

require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';

// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

if(!defined('DS'))
    define('DS', DIRECTORY_SEPARATOR);
if(!defined('JPATH_COMPONENT_ADMINISTRATOR'))
    define('JPATH_COMPONENT_ADMINISTRATOR', JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_marketingrocket');

class MarketingRocket extends JApplicationCli
{
    /**
     * Entry point for the script
     *
     * @return  void
     *
     * @since   2.5
     */
    public function doExecute()
    {

        require( JPATH_BASE .DS.'includes'.DS.'defines.php' );

        jimport( 'joomla.environment.uri' );
        jimport( 'joomla.user.user');
        jimport('joomla.application.module.helper');

        $mainframe = JFactory::getApplication('site');



        $lang = JFactory::getLanguage();
        $extension = 'com_marketingrocket';
        $base_dir = JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket';
//        $language_tag = JFactory::getApplication()->getLanguage()->getTag();
        $reload = true;
        $lang->load($extension, $base_dir, null, false);


        JComponentHelper::getComponents();

        JModelLegacy::addIncludePath(JPATH_SITE .DS. 'components'.DS.'com_marketingrocket'.DS.'models');

        JTable::addIncludePath(JPATH_SITE .DS. 'components'.DS.'com_marketingrocket'.DS.'tables');
        $model = JModelLegacy::getInstance('Cron', 'MarketingrocketModel');
        $default = new Joomla\Application\Cli\Output\Stdout();
        $this->setOutput($default);

        if(!$model instanceof MarketingrocketModelCron){
            $this->out('<error>Martketing Rocket Model Not Found</error>');
            return;
        }

        $ret = true;
        $sent = 0;
        do{
            try {
                $ret = $model->sendCrons(1);
            }
            catch (Exception $e){
                echo $e->getMessage();
                $ret = false;
            }
            if($ret)
                $sent++;
            if($sent > 1000)
                break;
        }while($ret);


        $this->out('<info>'.$sent.' Email Sent</info>');

        $date = JFactory::getDate();
        $params = JComponentHelper::getParams('com_marketingrocket');
        $params->set('last_cron', $date->toSql(true));
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        // Build the query
        $query->update('#__extensions AS a');
        $query->set('a.params = ' . $db->quote((string)$params));
        $query->where('a.element = "com_marketingrocket"');


        // Execute the query
        $db->setQuery($query);
        $db->execute();


    }
}

JApplicationCli::getInstance('MarketingRocket')->execute();