intialize.push('videobox');
MR_landing.prototype.videoboxDropped = function(parent, className){
	var $t = this;
	var $ = jQuery;
	var box = $t.createBox('div', className);
	$(box).attr('aria-type', 'videobox').addClass('videobox');
	$(box).html('<iframe width="420" height="315" data-id="JX7167Nn0R4" src="https://www.youtube.com/embed/dcXUWBw_H1o?rel=0" frameborder="0" id="'+$t.randString(6)+'" allowfullscreen></iframe>');
	$t.addAdminsBtns(box);
	
	$t.customSetting(box, 'fa-youtube-play', COM_MARKETINGROCKET_VIDEOBOX_SETTINGS);
	$t.videoboxFunctions(box);

	$t.addToParent(box, parent, className);
}
MR_landing.prototype.videoboxFunctions = function(box){
	var $t = this;
	var $ = jQuery;
        
        $(box).find('a.MR_Custom').click(function(){
            $t.activeEl = $(box).find('iframe');
            $('#videobox_setting').find('h3').find('small').text('#'+$t.activeEl.attr('id'));
            $t.beforeShowPopUpVideoBox();
            $t.modal('#videobox_setting','show');
        });
}
MR_landing.prototype.videoBoxCreateUrl = function(){
    var $t = this;
    var $ = jQuery;
    
    if($t.videoboxAct == false)
        return;
    
    var url = 'https://www.youtube.com/embed/';
    var videoId = $('#jform_video_id').val();
    
    url += videoId+'?';
    var sep = '';
    $('#videobox_setting').find('input[type="radio"]:checked').each(function(){
        var name = $(this).attr('name');
        name = name.replace('jform[video_', '');
        name = name.replace(']', '');
        
        url += sep+name+'='+$(this).val();
        sep = "&";
    })
    
    $t.activeEl.attr('src', url);
    
    
    
    
};
MR_landing.prototype.beforeShowPopUpVideoBox = function(){
    var $t = this;
    var $ = jQuery;
    
    $t.videoboxAct = false;
    
    var url = $t.activeEl.attr('src');
    url = url.replace('https://www.youtube.com/embed/', '');
    url = url.replace('http://www.youtube.com/embed/', '');
    url = url.replace('//www.youtube.com/embed/', '');
    var safeUrl = url;
    url = url.split('?');
    var videoId = url[0];
    try {
        url = url[1].split('&');
    
        var type = $t.activeEl.attr('data-type');
        if(type == 'webinar'){
            $('#jform_video_type1').next().click();
            $('#jform_video_type1').click();
            $('#jform_webinar_id').val(videoId);
        }
        else {
            $('#jform_video_type0').next().click();
            $('#jform_video_type0').click();
            $('#jform_video_id').val(videoId);
        }

        for(var i =0;i < url.length;i++){
            var rowData = url[i].split('=');
            var name = rowData[0];
            var val  = rowData[1];

            name = 'jform[video_'+name+']';
            $('#videobox_setting [name="'+name+'"][val="'+val+'"]').click().next().click();
        }
       
    }
    catch(e){
        videoId = safeUrl;
        $('#jform_video_id').val(videoId);
    }
    
    $('#jform_video_width').val($t.activeEl.attr('width'));
    $('#jform_video_height').val($t.activeEl.attr('height'));
    
    
    $t.videoboxAct = true;
    

};
MR_landing.prototype.videobox = function(){
    var $t = this;
    var $ = jQuery;
    $t.videoboxAct = true;
    
    $('#videobox_setting [name="jform[video_type]"]').click(function(){
        if($(this).val() == 'video'){
            $('#jform_video_id').parents('.control-group:first').show();
            $('#jform_webinar_id').parents('.control-group:first').hide();
        }
        else {
            $('#jform_video_id').parents('.control-group:first').hide();
            $('#jform_webinar_id').parents('.control-group:first').show();
        }
        if($t.activeEl != undefined){
            $t.activeEl.attr('data-type', $(this).val());
        }
        
    }).eq('0').next().click().prev().click();
    
    $('#jform_video_id').blur(function(){
        $t.videoBoxCreateUrl();
    });
    
    $('#jform_webinar_id').change(function(){
         $('#jform_video_id').val($(this).val()).blur();
    });
    
    $('#videobox_setting [name="jform[video_autoplay]"]'
       +',#videobox_setting [name="jform[video_controls]"]'
       +',#videobox_setting [name="jform[video_showinfo]"]'
       +',#videobox_setting [name="jform[video_theme]"]'
       +',#videobox_setting [name="jform[video_autohide]"]'
       +',#videobox_setting [name="jform[video_rel]"]'
    ).click(function(){
        $t.videoBoxCreateUrl();
    });
    
    $('#jform_video_width').keyup(function(){
        $t.activeEl.attr('width', $(this).val());
    });
    
    $('#jform_video_height').keyup(function(){
        $t.activeEl.attr('height', $(this).val());
    });
    
};
